/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.jobmanager.event.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.stanbol.enhancer.jobmanager.event.impl.EnhancementJob;
import org.apache.stanbol.enhancer.jobmanager.event.impl.EnhancementJobHandler;
import org.apache.stanbol.enhancer.servicesapi.Chain;
import org.apache.stanbol.enhancer.servicesapi.ChainException;
import org.apache.stanbol.enhancer.servicesapi.ChainManager;
import org.apache.stanbol.enhancer.servicesapi.ContentItem;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngineManager;
import org.apache.stanbol.enhancer.servicesapi.EnhancementJobManager;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionPlanHelper;
import org.apache.stanbol.enhancer.servicesapi.helper.execution.Execution;
import org.apache.stanbol.enhancer.servicesapi.helper.execution.ExecutionMetadata;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventJobManagerImpl
implements EnhancementJobManager {
    private final Logger log = LoggerFactory.getLogger(EventJobManagerImpl.class);
    public static final int DEFAULT_SERVICE_RANKING = 0;
    public static final String MAX_ENHANCEMENT_JOB_WAIT_TIME = "stanbol.maxEnhancementJobWaitTime";
    public static final int DEFAULT_MAX_ENHANCEMENT_JOB_WAIT_TIME = 60000;
    protected ChainManager chainManager;
    protected EnhancementEngineManager engineManager;
    protected EventAdmin eventAdmin;
    private ServiceRegistration jobHandlerRegistration;
    private EnhancementJobHandler jobHandler;
    private int maxEnhancementJobWaitTime = 60000;

    protected void activate(ComponentContext ctx) {
        this.log.info("activate {}", (Object)this.getClass().getName());
        this.jobHandler = new EnhancementJobHandler(this.eventAdmin, this.engineManager);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "stanbol/enhancer/jobmanager/event/topic");
        this.jobHandlerRegistration = ctx.getBundleContext().registerService(EventHandler.class.getName(), (Object)this.jobHandler, properties);
        Object maxWaitTime = ctx.getProperties().get(MAX_ENHANCEMENT_JOB_WAIT_TIME);
        if (maxWaitTime instanceof Integer) {
            this.maxEnhancementJobWaitTime = (Integer)maxWaitTime;
        }
    }

    protected void deactivate(ComponentContext ctx) {
        this.log.info("deactivate {}", (Object)this.getClass().getName());
        EnhancementJobHandler jobHandler = this.jobHandler;
        this.jobHandler = null;
        jobHandler.close();
        this.jobHandlerRegistration.unregister();
        this.jobHandlerRegistration = null;
    }

    public void enhanceContent(ContentItem ci) throws EngineException, ChainException {
        Chain defaultChain = this.chainManager.getDefault();
        if (defaultChain == null) {
            throw new ChainException("Unable to enhance ContentItem '" + ci.getUri() + "' because currently no enhancement chain is active. Please" + "configure a Chain or enable the default chain");
        }
        this.enhanceContent(ci, defaultChain);
    }

    public void enhanceContent(ContentItem ci, Chain chain) throws EngineException, ChainException {
        if (ci == null) {
            throw new IllegalArgumentException("The parsed contentItem MUST NOT be NULL!");
        }
        if (chain == null) {
            throw new IllegalArgumentException("Unable to enhance ContentItem '" + ci.getUri() + "' because NULL was passed as enhancement chain");
        }
        long start = System.currentTimeMillis();
        boolean isDefaultChain = chain.equals(this.chainManager.getDefault());
        EnhancementJob job = new EnhancementJob(ci, chain.getName(), chain.getExecutionPlan(), isDefaultChain);
        EnhancementJobHandler.EnhancementJobObserver observer = this.jobHandler.register(job);
        boolean completed = observer.waitForCompletion(this.maxEnhancementJobWaitTime);
        if (!completed) {
            StringBuilder sb = new StringBuilder("Status:\n");
            ExecutionMetadata em = ExecutionMetadata.parseFrom((TripleCollection)job.getExecutionMetadata(), (UriRef)ci.getUri());
            for (Map.Entry ex : em.getEngineExecutions().entrySet()) {
                sb.append("  -").append((String)ex.getKey()).append(": ").append(((Execution)ex.getValue()).getStatus()).append('\n');
            }
            throw new ChainException("Execution timeout after " + (float)(System.currentTimeMillis() - start) / 1000.0f + "sec (timeout:" + this.maxEnhancementJobWaitTime / 1000 + "sec) for ContentItem " + ci.getUri() + "\n" + sb.toString() + " \n To change the timeout change value of property '" + MAX_ENHANCEMENT_JOB_WAIT_TIME + "' for the service " + this.getClass());
        }
        this.log.info("Execution of Chain {} {} after {}ms for ContentItem {}", new Object[]{chain.getName(), job.isFailed() ? "failed" : "finished", System.currentTimeMillis() - start, job.getContentItem().getUri()});
        if (job.isFailed()) {
            Exception e = job.getError();
            if (e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            throw new ChainException(job.getErrorMessage(), (Throwable)e);
        }
        if (!job.isFinished()) {
            this.log.warn("Execution finished, but Job is not finished!");
            EnhancementJobHandler.logJobInfo(this.log, job, null, true);
            this.log.warn("ExecutionMetadata: ");
            Iterator it = job.getExecutionMetadata().iterator();
            while (it.hasNext()) {
                this.log.warn(((Triple)it.next()).toString());
            }
            throw new ChainException("EnhancementJobManager was deactivated while enhancing the passed ContentItem " + job.getContentItem() + " (EnhancementJobManager type: " + this.getClass() + ")");
        }
    }

    public List<EnhancementEngine> getActiveEngines() {
        Graph ep;
        Chain defaultChain = this.chainManager.getDefault();
        if (defaultChain == null) {
            throw new IllegalStateException("Currently no enhancement chain is active. Please configure a Chain or enable the default chain");
        }
        try {
            ep = defaultChain.getExecutionPlan();
        }
        catch (ChainException e) {
            throw new IllegalStateException("Unable to get Execution Plan for default enhancement chain (name: '" + defaultChain.getName() + "'| class: '" + defaultChain.getClass() + "')!", e);
        }
        return ExecutionPlanHelper.getActiveEngines((EnhancementEngineManager)this.engineManager, (TripleCollection)ep);
    }

    protected void bindChainManager(ChainManager chainManager) {
        this.chainManager = chainManager;
    }

    protected void unbindChainManager(ChainManager chainManager) {
        if (this.chainManager == chainManager) {
            this.chainManager = null;
        }
    }

    protected void bindEngineManager(EnhancementEngineManager enhancementEngineManager) {
        this.engineManager = enhancementEngineManager;
    }

    protected void unbindEngineManager(EnhancementEngineManager enhancementEngineManager) {
        if (this.engineManager == enhancementEngineManager) {
            this.engineManager = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

