/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.enhancer.jobmanager.event.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.stanbol.enhancer.jobmanager.event.impl.EnhancementJob;
import org.apache.stanbol.enhancer.jobmanager.event.impl.EventJobManagerImpl;
import org.apache.stanbol.enhancer.servicesapi.EngineException;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngine;
import org.apache.stanbol.enhancer.servicesapi.EnhancementEngineManager;
import org.apache.stanbol.enhancer.servicesapi.helper.ExecutionPlanHelper;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhancementJobHandler
implements EventHandler {
    private EnhancementEngineManager engineManager;
    private EventAdmin eventAdmin;
    private Logger log = LoggerFactory.getLogger(EnhancementJobHandler.class);
    private Map<EnhancementJob, Object> processingJobs;
    private final ReadWriteLock processingLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancementJobHandler(EventAdmin eventAdmin, EnhancementEngineManager engineManager) {
        if (eventAdmin == null) {
            throw new IllegalArgumentException("The parsed EventAdmin service MUST NOT be NULL!");
        }
        if (engineManager == null) {
            throw new IllegalArgumentException("The parsed EnhancementEngineManager MUST NOT be NULL!");
        }
        this.eventAdmin = eventAdmin;
        this.engineManager = engineManager;
        this.processingLock.writeLock().lock();
        try {
            this.processingJobs = new HashMap<EnhancementJob, Object>();
        }
        finally {
            this.processingLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.log.info("deactivate {}", (Object)this.getClass().getName());
        this.processingLock.writeLock().lock();
        try {
            Iterator<Object> i$ = this.processingJobs.values().iterator();
            while (i$.hasNext()) {
                Object o;
                Object object = o = i$.next();
                synchronized (object) {
                    o.notifyAll();
                }
            }
            this.processingJobs = null;
        }
        finally {
            this.processingLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object register(EnhancementJob enhancementJob) {
        boolean init;
        Object o;
        this.processingLock.writeLock().lock();
        try {
            if (enhancementJob == null || this.processingJobs == null) {
                Object var4_2 = null;
                return var4_2;
            }
            o = this.processingJobs.get(enhancementJob);
            if (o == null) {
                o = new Object();
                this.processingJobs.put(enhancementJob, o);
                init = true;
            } else {
                init = false;
            }
        }
        finally {
            this.processingLock.writeLock().unlock();
        }
        if (init) {
            enhancementJob.startProcessing();
            this.log.debug("++ w: {}", (Object)"init execution");
            enhancementJob.getLock().writeLock().lock();
            try {
                this.log.debug(">> w: {}", (Object)"init execution");
                this.executeNextNodes(enhancementJob);
            }
            finally {
                this.log.debug("<< w: {}", (Object)"init execution");
                enhancementJob.getLock().writeLock().unlock();
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        EnhancementJob job = (EnhancementJob)event.getProperty("stanbol.enhancer.jobmanager.event.job");
        NonLiteral execution = (NonLiteral)event.getProperty("stanbol.enhancer.jobmanager.event.execution");
        if (job == null || execution == null) {
            this.log.warn("Unable to process EnhancementEvent where EnhancementJob {} or Execution node {} is null -> ignore", (Object)job, (Object)execution);
        }
        try {
            this.processEvent(job, execution);
        }
        catch (Throwable t) {
            String message = String.format("Unexpected Exception while processing ContentItem %s with EnhancementJobManager: %s", job.getContentItem().getUri(), EventJobManagerImpl.class);
            job.setFailed(execution, null, new IllegalStateException(message, t));
            this.log.error(message, t);
        }
        this.log.debug("++ w: {}", (Object)"check for next Executions");
        job.getLock().writeLock().lock();
        this.log.debug(">> w: {}", (Object)"check for next Executions");
        try {
            if (job.isFinished()) {
                this.finish(job);
            } else if (!job.isFailed()) {
                this.executeNextNodes(job);
            } else if (this.log.isInfoEnabled()) {
                ArrayList<String> running = new ArrayList<String>(3);
                for (NonLiteral runningNode : job.getRunning()) {
                    running.add(ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionPlan(), (NonLiteral)runningNode));
                }
                this.log.debug("Job {} failed, but {} still running!", (Object)job.getContentItem().getUri(), running);
            }
        }
        finally {
            this.log.debug("<< w: {}", (Object)"check for next Executions");
            job.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(EnhancementJob job, NonLiteral execution) {
        NonLiteral executionNode = job.getExecutionNode(execution);
        String engineName = ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionPlan(), (NonLiteral)executionNode);
        EnhancementEngine engine = this.engineManager.getEngine(engineName);
        if (engine != null) {
            int engineState;
            EngineException exception = null;
            try {
                engineState = engine.canEnhance(job.getContentItem());
            }
            catch (EngineException e) {
                exception = e;
                this.log.warn("Unable to check if engine '" + engineName + "'(type: " + engine.getClass() + ") can enhance ContentItem '" + job.getContentItem().getUri() + "'!", (Throwable)e);
                engineState = 0;
            }
            if (engineState == 1) {
                this.log.debug("++ w: {}: {}", (Object)"start sync execution", (Object)engine.getName());
                job.getLock().writeLock().lock();
                this.log.debug(">> w: {}: {}", (Object)"start sync execution", (Object)engine.getName());
                try {
                    engine.computeEnhancements(job.getContentItem());
                    job.setCompleted(execution);
                }
                catch (EngineException e) {
                    job.setFailed(execution, engine, (Exception)((Object)e));
                }
                finally {
                    this.log.debug("<< w: {}: {}", (Object)"finished sync execution", (Object)engine.getName());
                    job.getLock().writeLock().unlock();
                }
            } else if (engineState == 2) {
                try {
                    this.log.debug("++ n: start async execution of Engine {}", (Object)engine.getName());
                    engine.computeEnhancements(job.getContentItem());
                    this.log.debug("++ n: finished async execution of Engine {}", (Object)engine.getName());
                    job.setCompleted(execution);
                }
                catch (EngineException e) {
                    job.setFailed(execution, engine, (Exception)((Object)e));
                }
            } else if (exception != null) {
                job.setFailed(execution, engine, (Exception)((Object)exception));
            } else {
                job.setCompleted(execution);
            }
        } else {
            job.setFailed(execution, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(EnhancementJob job) {
        Object o;
        this.processingLock.writeLock().lock();
        try {
            o = this.processingJobs.remove(job);
        }
        finally {
            this.processingLock.writeLock().unlock();
        }
        if (o != null) {
            Object object = o;
            synchronized (object) {
                this.log.debug("++ n: finished processing ContentItem {} with Chain {}", (Object)job.getContentItem().getUri(), (Object)job.getChainName());
                o.notifyAll();
            }
        } else {
            this.log.warn("EnhancementJob for ContentItem {} is not registered with {}. Will not send notification!", (Object)job.getContentItem().getUri(), (Object)this.getClass().getName());
        }
    }

    protected void executeNextNodes(EnhancementJob job) {
        for (NonLiteral executable : job.getExecutable()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("PREPARE execution of Engine {}", (Object)ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionPlan(), (NonLiteral)job.getExecutionNode(executable)));
            }
            Hashtable<String, EnhancementJob> properties = new Hashtable<String, EnhancementJob>();
            ((Dictionary)properties).put("stanbol.enhancer.jobmanager.event.job", job);
            ((Dictionary)properties).put("stanbol.enhancer.jobmanager.event.execution", (EnhancementJob)executable);
            job.setRunning(executable);
            if (this.log.isDebugEnabled()) {
                this.log.debug("SHEDULE execution of Engine {}", (Object)ExecutionPlanHelper.getEngine((TripleCollection)job.getExecutionPlan(), (NonLiteral)job.getExecutionNode(executable)));
            }
            this.eventAdmin.postEvent(new Event("stanbol/enhancer/jobmanager/event/topic", properties));
        }
    }
}

