/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.resource.reconcile;

import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.entityhub.jersey.resource.reconcile.BaseGoogleRefineReconcileResource;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSite;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteException;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/entityhub/site/{site}/reconcile")
public class ReferencedSiteReconcileResource
extends BaseGoogleRefineReconcileResource {
    private final Logger log = LoggerFactory.getLogger(ReferencedSiteReconcileResource.class);
    private ReferencedSiteManager _siteManager;
    private final String siteId;

    public ReferencedSiteReconcileResource(@PathParam(value="site") String siteId) {
        if (siteId == null || siteId.isEmpty()) {
            this.log.error("Missing path parameter site={}", (Object)siteId);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.siteId = siteId;
    }

    private ReferencedSite getSite() throws WebApplicationException {
        ReferencedSite site;
        if (this._siteManager == null) {
            this._siteManager = (ReferencedSiteManager)ContextHelper.getServiceFromContext(ReferencedSiteManager.class, (ServletContext)this.servletContext);
            if (this._siteManager == null) {
                throw new IllegalStateException("Unable to lookup ReferencedSite '" + this.siteId + "' because ReferencedSiteManager service is unavailable!");
            }
        }
        if ((site = this._siteManager.getReferencedSite(this.siteId)) == null) {
            String message = String.format("ReferencedSite '%s' not acitve!", this.siteId);
            this.log.error(message);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).build());
        }
        return site;
    }

    @Override
    protected QueryResultList<Representation> performQuery(FieldQuery query) throws ReferencedSiteException {
        return this.getSite().find(query);
    }

    @Override
    protected String getSiteName() {
        return this.getSite().getId() + "Referenced Site";
    }

    @Override
    protected FieldQuery createFieldQuery() {
        return this.getSite().getQueryFactory().createFieldQuery();
    }
}

