/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.writers;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.stanbol.entityhub.core.utils.TimeUtils;
import org.apache.stanbol.entityhub.servicesapi.defaults.DataTypeEnum;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.Reference;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.Text;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

final class EntityToJSON {
    private EntityToJSON() {
    }

    static JSONObject toJSON(Entity entity) throws JSONException {
        JSONObject jSign = EntityToJSON.convertEntityToJSON(entity);
        return jSign;
    }

    private static JSONObject convertEntityToJSON(Entity entity) throws JSONException {
        JSONObject jSign = new JSONObject();
        jSign.put("id", (Object)entity.getId());
        jSign.put("site", (Object)entity.getSite());
        jSign.put("representation", (Object)EntityToJSON.toJSON(entity.getRepresentation()));
        jSign.put("metadata", (Object)EntityToJSON.toJSON(entity.getMetadata()));
        return jSign;
    }

    static JSONObject toJSON(Representation rep) throws JSONException {
        JSONObject jRep = new JSONObject();
        jRep.put("id", (Object)rep.getId());
        Iterator fields = rep.getFieldNames();
        while (fields.hasNext()) {
            String field = (String)fields.next();
            Iterator values = rep.get(field);
            if (!values.hasNext()) continue;
            jRep.put(field, (Object)EntityToJSON.convertFieldValuesToJSON(values));
        }
        return jRep;
    }

    private static JSONArray convertFieldValuesToJSON(Iterator<?> values) throws JSONException {
        JSONArray jValues = new JSONArray();
        while (values.hasNext()) {
            jValues.put((Object)EntityToJSON.convertFieldValueToJSON(values.next()));
        }
        return jValues;
    }

    private static JSONObject convertFieldValueToJSON(Object value) throws JSONException {
        JSONObject jValue = new JSONObject();
        if (value instanceof Reference) {
            jValue.put("type", (Object)"reference");
            jValue.put("xsd:datatype", (Object)DataTypeEnum.AnyUri.getShortName());
            jValue.put("value", (Object)((Reference)value).getReference());
        } else if (value instanceof Text) {
            jValue.put("type", (Object)"text");
            jValue.put("xml:lang", (Object)((Text)value).getLanguage());
            jValue.put("value", (Object)((Text)value).getText());
        } else if (value instanceof Date) {
            jValue.put("type", (Object)"value");
            jValue.put("value", (Object)TimeUtils.toString((DataTypeEnum)DataTypeEnum.DateTime, (Date)((Date)value)));
            jValue.put("xsd:datatype", (Object)DataTypeEnum.DateTime.getShortName());
        } else {
            jValue.put("type", (Object)"value");
            Set dataTypes = DataTypeEnum.getPrimaryDataTypes(value.getClass());
            if (!dataTypes.isEmpty()) {
                jValue.put("xsd:datatype", (Object)((DataTypeEnum)dataTypes.iterator().next()).getShortName());
            } else {
                jValue.put("xsd:datatype", (Object)DataTypeEnum.String.getShortName());
            }
            jValue.put("value", value);
        }
        return jValue;
    }
}

