/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.writers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.PlainLiteralImpl;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.jena.serializer.JenaSerializerProvider;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.entityhub.jersey.writers.EntityToRDF;
import org.apache.stanbol.entityhub.query.clerezza.RdfQueryResultList;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;

final class QueryResultsToRDF {
    static final UriRef QUERY_RESULT_LIST = new UriRef(RdfResourceEnum.QueryResultSet.getUri());
    static final UriRef QUERY_RESULT = new UriRef(RdfResourceEnum.queryResult.getUri());
    static final UriRef FIELD_QUERY = new UriRef(RdfResourceEnum.query.getUri());
    static final LiteralFactory literalFactory = EntityToRDF.literalFactory;

    private QueryResultsToRDF() {
    }

    static MGraph toRDF(QueryResultList<?> resultList) {
        IndexedMGraph resultGraph;
        block12: {
            boolean isSignType;
            Class type;
            block13: {
                block11: {
                    type = resultList.getType();
                    if (!String.class.isAssignableFrom(type)) break block11;
                    resultGraph = new IndexedMGraph();
                    for (Object result : resultList) {
                        resultGraph.add((Object)new TripleImpl((NonLiteral)QUERY_RESULT_LIST, QUERY_RESULT, (Resource)new UriRef(result.toString())));
                    }
                    break block12;
                }
                if (Representation.class.isAssignableFrom(type)) {
                    isSignType = false;
                } else if (Representation.class.isAssignableFrom(type)) {
                    isSignType = true;
                } else {
                    throw new IllegalArgumentException("Parsed type " + type + " is not supported");
                }
                if (!(resultList instanceof RdfQueryResultList)) break block13;
                resultGraph = ((RdfQueryResultList)resultList).getResultGraph();
                if (!isSignType) break block12;
                Iterator resultTripleIt = resultGraph.filter((NonLiteral)QUERY_RESULT_LIST, QUERY_RESULT, null);
                while (resultTripleIt.hasNext()) {
                    resultTripleIt.next();
                    resultTripleIt.remove();
                }
                for (Object result : resultList) {
                    UriRef signId = new UriRef(((Entity)result).getId());
                    EntityToRDF.addEntityTriplesToGraph((MGraph)resultGraph, (Entity)result);
                    resultGraph.add((Object)new TripleImpl((NonLiteral)QUERY_RESULT_LIST, QUERY_RESULT, (Resource)signId));
                }
                break block12;
            }
            resultGraph = new IndexedMGraph();
            if (Representation.class.isAssignableFrom(type)) {
                for (Object result : resultList) {
                    UriRef resultId;
                    if (!isSignType) {
                        EntityToRDF.addRDFTo((MGraph)resultGraph, (Representation)result);
                        resultId = new UriRef(((Representation)result).getId());
                    } else {
                        EntityToRDF.addRDFTo((MGraph)resultGraph, (Entity)result);
                        resultId = new UriRef(((Entity)result).getId());
                    }
                    resultGraph.add((Object)new TripleImpl((NonLiteral)QUERY_RESULT_LIST, QUERY_RESULT, (Resource)resultId));
                }
            }
        }
        return resultGraph;
    }

    public static void main(String[] args) throws Exception {
        JenaSerializerProvider p = new JenaSerializerProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SimpleMGraph g = new SimpleMGraph();
        g.add((Object)new TripleImpl((NonLiteral)new UriRef("urn:test"), new UriRef("http://test.org/test"), (Resource)new PlainLiteralImpl("test")));
        p.serialize((OutputStream)out, (TripleCollection)g, "text/rdf+nt");
        System.out.println(new String(out.toByteArray(), Charset.forName("UTF-8")));
    }
}

