/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.resource;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.exception.LDPathParseException;
import at.newmedialab.ldpath.model.programs.Program;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.commons.namespaceprefix.NamespaceMappingUtils;
import org.apache.stanbol.commons.namespaceprefix.NamespacePrefixService;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.commons.web.base.utils.MediaTypeUtil;
import org.apache.stanbol.entityhub.core.query.QueryResultListImpl;
import org.apache.stanbol.entityhub.jersey.utils.JerseyUtils;
import org.apache.stanbol.entityhub.jersey.utils.LDPathHelper;
import org.apache.stanbol.entityhub.ldpath.EntityhubLDPath;
import org.apache.stanbol.entityhub.ldpath.backend.AbstractBackend;
import org.apache.stanbol.entityhub.ldpath.backend.EntityhubBackend;
import org.apache.stanbol.entityhub.ldpath.backend.YardBackend;
import org.apache.stanbol.entityhub.ldpath.query.LDPathSelect;
import org.apache.stanbol.entityhub.model.clerezza.RdfValueFactory;
import org.apache.stanbol.entityhub.servicesapi.Entityhub;
import org.apache.stanbol.entityhub.servicesapi.EntityhubException;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.ValueFactory;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/entityhub")
public class EntityhubRootResource
extends BaseStanbolResource {
    private static Logger log = LoggerFactory.getLogger(EntityhubRootResource.class);
    private static Collection<String> ENTITY_SUPPORTED_MEDIA_TYPE_INCL_HTML = new HashSet<String>(JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES);
    private static final String DEFAULT_FIND_FIELD;
    private static final int DEFAULT_FIND_RESULT_LIMIT = 5;
    private NamespacePrefixService nsPrefixService;

    public EntityhubRootResource(@Context ServletContext servletContext) {
        this.nsPrefixService = (NamespacePrefixService)ContextHelper.getServiceFromContext(NamespacePrefixService.class, (ServletContext)servletContext);
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Produces(value={"text/html"})
    public Response get(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("index", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="entity")
    @Produces(value={"application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt", "text/html"})
    public Response getSymbol(@QueryParam(value="id") String symbolId, @Context HttpHeaders headers) throws WebApplicationException {
        Entity entity;
        log.info("GET /entity Request");
        log.info("  > id: " + symbolId);
        log.info("  > accept: " + headers.getAcceptableMediaTypes());
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, ENTITY_SUPPORTED_MEDIA_TYPE_INCL_HTML, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (acceptedMediaType.isCompatible(MediaType.TEXT_HTML_TYPE) && symbolId == null) {
            Response.ResponseBuilder rb = Response.ok((Object)new Viewable("entity", (Object)this));
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        if (symbolId == null || symbolId.isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Entityhub entityhub = (Entityhub)ContextHelper.getServiceFromContext(Entityhub.class, (ServletContext)this.servletContext);
        try {
            entity = entityhub.getEntity(symbolId);
        }
        catch (EntityhubException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (entity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Response.ResponseBuilder rb = Response.ok((Object)entity);
        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="lookup")
    @Produces(value={"application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt", "text/html"})
    public Response lookupSymbol(@QueryParam(value="id") String reference, @QueryParam(value="create") boolean create, @Context HttpHeaders headers) throws WebApplicationException {
        Entity entity;
        log.info("GET /lookup Request");
        log.info("  > id: " + reference);
        log.info("  > create   : " + create);
        log.info("  > accept: " + headers.getAcceptableMediaTypes());
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, ENTITY_SUPPORTED_MEDIA_TYPE_INCL_HTML, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (acceptedMediaType.isCompatible(MediaType.TEXT_HTML_TYPE) && reference == null) {
            Response.ResponseBuilder rb = Response.ok((Object)new Viewable("lookup", (Object)this));
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        if (reference == null || reference.isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Entityhub entityhub = (Entityhub)ContextHelper.getServiceFromContext(Entityhub.class, (ServletContext)this.servletContext);
        try {
            entity = entityhub.lookupLocalEntity(reference, create);
        }
        catch (EntityhubException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (entity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No symbol found for '" + reference + "'.")).header("Accept", (Object)acceptedMediaType).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)entity);
        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @OPTIONS
    @Path(value="entity/")
    public Response handleCorsPreflightEntity(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"GET", "POST", "PUT", "DELETE", "OPTIONS"});
        return res.build();
    }

    @POST
    @Path(value="entity/")
    @Consumes(value={"*/*"})
    public Response createEntity(@QueryParam(value="id") String id, @QueryParam(value="update") boolean allowUpdate, Map<String, Representation> parsed, @Context HttpHeaders headers) {
        log.info("Headers: " + headers.getRequestHeaders());
        log.info("Entity: " + id);
        log.info("Representations : " + parsed);
        return this.updateOrCreateEntity(id, parsed, "POST", true, allowUpdate, headers);
    }

    @PUT
    @Path(value="entity/")
    @Consumes(value={"*/*"})
    public Response updateEntity(@QueryParam(value="id") String id, @QueryParam(value="create") @DefaultValue(value="true") boolean allowCreate, Map<String, Representation> parsed, @Context HttpHeaders headers) {
        log.info("Headers: " + headers.getRequestHeaders());
        log.info("Entity: " + id);
        log.info("Representations : " + parsed);
        return this.updateOrCreateEntity(id, parsed, "PUT", allowCreate, true, headers);
    }

    @DELETE
    @Path(value="entity")
    public Response deleteEntity(@QueryParam(value="id") String id, @Context HttpHeaders headers) {
        Response.ResponseBuilder rb;
        MediaType accepted = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (id == null || id.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The Request doesnot provide the id of the Entity to delete (parameter 'id').").header("Accept", (Object)accepted).build();
        }
        Entityhub entityhub = (Entityhub)ContextHelper.getServiceFromContext(Entityhub.class, (ServletContext)this.servletContext);
        try {
            if (id.equals("*")) {
                log.info("Deleting all Entities form the Entityhub");
                entityhub.deleteAll();
                rb = Response.status((Response.Status)Response.Status.OK);
            } else {
                Entity entity = entityhub.delete(id);
                if (entity == null) {
                    rb = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("An Entity with theparsed id " + id + " is not managed by the Entityhub")).header("Accept", (Object)accepted);
                } else {
                    rb = Response.ok((Object)entity);
                    rb.header("Content-Type", (Object)(accepted + "; charset=utf-8")).header("Accept", (Object)accepted);
                }
            }
        }
        catch (EntityhubException e) {
            rb = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).header("Accept", (Object)accepted);
        }
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response updateOrCreateEntity(String id, Map<String, Representation> parsed, String method, boolean create, boolean update, HttpHeaders headers) {
        Response.ResponseBuilder rb;
        Entityhub entityhub = (Entityhub)ContextHelper.getServiceFromContext(Entityhub.class, (ServletContext)this.servletContext);
        MediaType accepted = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (entityhub == null) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"The Entityhub is currently unavailable.").header("Accept", (Object)accepted).build();
        }
        if (id != null && !"*".equals(id)) {
            Representation r = parsed.get(id);
            if (r == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Parsed RDF data do not contain any Information about the parsed id '%s'", id)).header("Accept", (Object)accepted).build();
            }
            parsed = Collections.singletonMap(id, r);
        }
        if (!create || !update) {
            long start = System.currentTimeMillis();
            log.debug("   ... validate parsed Representation state (create: {}| update: {})", (Object)create, (Object)update);
            for (Map.Entry<String, Representation> entry : parsed.entrySet()) {
                boolean exists;
                try {
                    exists = entityhub.isRepresentation(entry.getKey());
                }
                catch (EntityhubException e) {
                    log.error(String.format("Exception while checking the existance of an Entity with id  %s in the Entityhub.", entry.getKey()), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Unable to process Entity %s because ofan Error while checking the current version of thatEntity within the Entityhub (Message: %s)", entry.getKey(), e.getMessage())).header("Accept", (Object)accepted).build();
                }
                if ((!exists || update) && (exists || create)) continue;
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Unable to %s an Entity '%s' becuase it %s and request parameter '%s' is set.  To allow both creating and updating of Entities you need to set '%s=true' in the request", exists ? "update" : "create", entry.getKey(), exists ? "exists " : "does not exist", exists ? "update=false" : "create=false", exists ? "update" : "create")).header("Accept", (Object)accepted).build();
            }
            log.debug("      > checked {} entities in {}ms", (Object)parsed.size(), (Object)(System.currentTimeMillis() - start));
        }
        HashMap<String, Entity> updated = new HashMap<String, Entity>();
        for (Representation representation : parsed.values()) {
            try {
                Entity entity = entityhub.store(representation);
                updated.put(entity.getId(), entity);
            }
            catch (EntityhubException e) {
                log.error(String.format("Exception while storing Entity %sin the Entityhub.", representation), (Throwable)e);
            }
        }
        if (updated.isEmpty()) {
            Response.ResponseBuilder rb2 = Response.status((Response.Status)Response.Status.NOT_MODIFIED);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb2, (HttpHeaders)headers);
            return rb2.build();
        }
        Entity entity = (Entity)updated.values().iterator().next();
        if (method.equals("POST")) {
            rb = Response.created((URI)this.uriInfo.getAbsolutePathBuilder().queryParam("id", new Object[]{"{entityId}"}).build(new Object[]{entity.getId()}));
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        rb = Response.ok((Object)entity);
        rb.header("Content-Type", (Object)(accepted + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @OPTIONS
    @Path(value="/find")
    public Response handleCorsPreflightFind(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Path(value="/find")
    @Produces(value={"application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt", "text/html"})
    public Response findEntityByGet(@QueryParam(value="name") String name, @QueryParam(value="field") String field, @QueryParam(value="lang") String language, @QueryParam(value="limit") Integer limit, @QueryParam(value="offset") Integer offset, @QueryParam(value="select") String select, @QueryParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return this.findEntity(name, field, language, limit, offset, select, ldpath, headers);
    }

    @POST
    @Path(value="/find")
    @Produces(value={"application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt", "text/html"})
    public Response findEntity(@FormParam(value="name") String name, @FormParam(value="field") String parsedField, @FormParam(value="lang") String language, @FormParam(value="limit") Integer limit, @FormParam(value="offset") Integer offset, @FormParam(value="select") String select, @FormParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        String property;
        log.debug("/find Request");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, ENTITY_SUPPORTED_MEDIA_TYPE_INCL_HTML, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (name == null || name.isEmpty()) {
            if (acceptedMediaType.isCompatible(MediaType.TEXT_HTML_TYPE)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("find", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The name must not be null nor empty for find requests. Missing parameter name.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        if (parsedField == null) {
            property = DEFAULT_FIND_FIELD;
        } else if ((parsedField = parsedField.trim()).isEmpty()) {
            property = DEFAULT_FIND_FIELD;
        } else {
            property = this.nsPrefixService.getFullName(parsedField);
            if (property == null) {
                String messsage = String.format("The prefix '%s' of the parsed field '%' is not mapped to any namespace. Please parse the full URI instead!\n", NamespaceMappingUtils.getPrefix((String)parsedField), parsedField);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messsage).header("Accept", (Object)acceptedMediaType).build();
            }
        }
        FieldQuery query = JerseyUtils.createFieldQueryForFindRequest(name, property, language, limit == null || limit < 1 ? 5 : limit, offset, ldpath);
        ArrayList<String> additionalSelectedFields = new ArrayList<String>();
        if (select != null && !select.isEmpty()) {
            for (String selected : select.trim().split(" ")) {
                if (selected == null || selected.isEmpty()) continue;
                additionalSelectedFields.add(selected);
            }
        }
        query.addSelectedFields(additionalSelectedFields);
        return this.executeQuery(query, headers, acceptedMediaType);
    }

    @OPTIONS
    @Path(value="/query")
    public Response handleCorsPreflightQuery(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Path(value="/query")
    public Response getQueryDocumentation(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("query", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/json"})
    public Response queryEntities(FieldQuery query, @Context HttpHeaders headers) {
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, JerseyUtils.QUERY_RESULT_SUPPORTED_MEDIA_TYPES, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (query == null && MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
            return this.getQueryDocumentation(headers);
        }
        return this.executeQuery(query, headers, acceptedMediaType);
    }

    private Response executeQuery(FieldQuery query, HttpHeaders headers, MediaType acceptedMediaType) throws WebApplicationException {
        QueryResultList result;
        Entityhub entityhub = (Entityhub)ContextHelper.getServiceFromContext(Entityhub.class, (ServletContext)this.servletContext);
        if (query instanceof LDPathSelect && ((LDPathSelect)query).getLDPathSelect() != null) {
            return this.executeLDPathQuery(entityhub, query, ((LDPathSelect)query).getLDPathSelect(), acceptedMediaType, headers);
        }
        try {
            result = entityhub.find(query);
        }
        catch (EntityhubException e) {
            String message = String.format("Exception while performing the FieldQuery on the EntityHub (message: %s)", e.getMessage());
            log.error(message, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).header("Accept", (Object)acceptedMediaType).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response executeLDPathQuery(Entityhub entityhub, FieldQuery query, String ldpathProgramString, MediaType mediaType, HttpHeaders headers) {
        Iterator resultIt;
        Program<Object> program;
        RdfValueFactory vf = new RdfValueFactory((MGraph)new IndexedMGraph());
        EntityhubBackend backend = new EntityhubBackend(entityhub);
        EntityhubLDPath ldPath = new EntityhubLDPath((RDFBackend)backend, (ValueFactory)vf);
        HashSet<String> selectedFields = new HashSet<String>(query.getSelectedFields());
        try {
            program = LDPathHelper.prepareQueryLDPathProgram(ldpathProgramString, selectedFields, (AbstractBackend)backend, ldPath);
        }
        catch (LDPathParseException e) {
            log.warn("Unable to parse LDPath program used as select for Query:");
            log.warn("FieldQuery: \n {}", (Object)query);
            log.warn("LDPath: \n {}", (Object)((LDPathSelect)query).getLDPathSelect());
            log.warn("Exception:", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unable to parse LDPath program (Messages: " + LDPathHelper.getLDPathParseExceptionMessage(e) + ")!\n")).header("Accept", (Object)mediaType).build();
        }
        catch (IllegalStateException e) {
            log.warn("parsed LDPath program is not compatible with parsed Query!", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).header("Accept", (Object)mediaType).build();
        }
        try {
            resultIt = entityhub.getYard().findRepresentation(query).iterator();
        }
        catch (EntityhubException e) {
            String message = String.format("Exception while performing the FieldQuery on the EntityHub (message: %s)", e.getMessage());
            log.error(message, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).header("Accept", (Object)mediaType).build();
        }
        Collection<Representation> transformedResults = LDPathHelper.transformQueryResults(resultIt, program, selectedFields, ldPath, (AbstractBackend)backend, (ValueFactory)vf);
        QueryResultListImpl result = new QueryResultListImpl(query, transformedResults, Representation.class);
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.header("Content-Type", (Object)(mediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @OPTIONS
    @Path(value="/mapping")
    public Response handleCorsPreflightMapping(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"GET", "OPTIONS"});
        return res.build();
    }

    @GET
    @Path(value="mapping")
    @Produces(value={"application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt", "text/html"})
    public Response getMapping(@QueryParam(value="id") String reference, @Context HttpHeaders headers) throws WebApplicationException {
        Entity mapping;
        log.debug("get mapping for request > id : {} > accept: {}", (Object)reference, (Object)headers.getAcceptableMediaTypes());
        HashSet<String> supported = new HashSet<String>(JerseyUtils.REPRESENTATION_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (reference == null || reference.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("mapping", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The mapping id (URI) is missing.\n").header("Accept", (Object)acceptedMediaType).build();
            }
        }
        Entityhub entityhub = (Entityhub)ContextHelper.getServiceFromContext(Entityhub.class, (ServletContext)this.servletContext);
        try {
            mapping = entityhub.getMappingById(reference);
        }
        catch (EntityhubException e) {
            log.error("error while getting the mapping for {}", (Object)reference, (Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        if (mapping == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No mapping found for '" + reference + "'.\n")).header("Accept", (Object)acceptedMediaType).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)mapping);
        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @OPTIONS
    @Path(value="/mapping/entity")
    public Response handleCorsPreflightMappingEntity(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"GET", "OPTIONS"});
        return res.build();
    }

    @GET
    @Path(value="mapping/entity")
    @Produces(value={"application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt", "text/html"})
    public Response getEntityMapping(@QueryParam(value="id") String entity, @Context HttpHeaders headers) throws WebApplicationException {
        Entity mapping;
        log.debug("getEntityMapping() POST Request > entity: {} > accept: {}", (Object)entity, (Object)headers.getAcceptableMediaTypes());
        HashSet<String> supported = new HashSet<String>(JerseyUtils.REPRESENTATION_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (entity == null || entity.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("mapping_entity", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No entity given. Missing parameter id.\n").header("Accept", (Object)acceptedMediaType).build();
            }
        }
        Entityhub entityhub = (Entityhub)ContextHelper.getServiceFromContext(Entityhub.class, (ServletContext)this.servletContext);
        try {
            mapping = entityhub.getMappingBySource(entity);
        }
        catch (EntityhubException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (mapping == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No mapping found for entity '" + entity + "'.\n")).header("Accept", (Object)acceptedMediaType).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)mapping);
        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @OPTIONS
    @Path(value="/mapping/symbol")
    public Response handleCorsPreflightMappingSymbol(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"GET", "OPTIONS"});
        return res.build();
    }

    @GET
    @Path(value="mapping/symbol")
    @Produces(value={"application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt", "text/html"})
    public Response getSymbolMappings(@QueryParam(value="id") String symbol, @Context HttpHeaders headers) throws WebApplicationException {
        Collection mappings;
        log.debug("getSymbolMappings() POST Request > symbol: {} > accept: {}", (Object)symbol, (Object)headers.getAcceptableMediaTypes());
        HashSet<String> supported = new HashSet<String>(JerseyUtils.REPRESENTATION_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (symbol == null || symbol.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("mapping_symbol", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No symbol given. Missing parameter id.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        Entityhub entityhub = (Entityhub)ContextHelper.getServiceFromContext(Entityhub.class, (ServletContext)this.servletContext);
        try {
            mappings = entityhub.getMappingsByTarget(symbol);
        }
        catch (EntityhubException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (mappings == null || mappings.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No mapping found for symbol '" + symbol + "'.\n")).header("Accept", (Object)acceptedMediaType).build();
        }
        QueryResultListImpl mappingResultList = new QueryResultListImpl(null, mappings, Entity.class);
        Response.ResponseBuilder rb = Response.ok((Object)mappingResultList);
        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @OPTIONS
    @Path(value="/ldpath")
    public Response handleCorsPreflightLDPath(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"OPTIONS", "GET", "POST"});
        return res.build();
    }

    @GET
    @Path(value="/ldpath")
    public Response handleLDPathGet(@QueryParam(value="context") Set<String> contexts, @QueryParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return this.handleLDPathPost(contexts, ldpath, headers);
    }

    @POST
    @Path(value="/ldpath")
    public Response handleLDPathPost(@FormParam(value="context") Set<String> contexts, @FormParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        Entityhub entityhub = (Entityhub)ContextHelper.getServiceFromContext(Entityhub.class, (ServletContext)this.servletContext);
        return LDPathHelper.handleLDPathRequest(this, (RDFBackend<Object>)new YardBackend(entityhub.getYard()), ldpath, contexts, headers, this.servletContext);
    }

    static {
        ENTITY_SUPPORTED_MEDIA_TYPE_INCL_HTML.add("text/html");
        DEFAULT_FIND_FIELD = RdfResourceEnum.label.getUri();
    }
}

