/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.resource;

import at.newmedialab.ldpath.api.backend.RDFBackend;
import at.newmedialab.ldpath.exception.LDPathParseException;
import at.newmedialab.ldpath.model.programs.Program;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.ontologies.RDFS;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.commons.namespaceprefix.NamespaceMappingUtils;
import org.apache.stanbol.commons.namespaceprefix.NamespacePrefixService;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.commons.web.base.utils.MediaTypeUtil;
import org.apache.stanbol.entityhub.core.query.QueryResultListImpl;
import org.apache.stanbol.entityhub.jersey.utils.JerseyUtils;
import org.apache.stanbol.entityhub.jersey.utils.LDPathHelper;
import org.apache.stanbol.entityhub.ldpath.EntityhubLDPath;
import org.apache.stanbol.entityhub.ldpath.backend.AbstractBackend;
import org.apache.stanbol.entityhub.ldpath.backend.SiteBackend;
import org.apache.stanbol.entityhub.ldpath.query.LDPathSelect;
import org.apache.stanbol.entityhub.model.clerezza.RdfRepresentation;
import org.apache.stanbol.entityhub.model.clerezza.RdfValueFactory;
import org.apache.stanbol.entityhub.servicesapi.defaults.NamespaceEnum;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.ValueFactory;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.site.License;
import org.apache.stanbol.entityhub.servicesapi.site.ManagedSite;
import org.apache.stanbol.entityhub.servicesapi.site.ManagedSiteException;
import org.apache.stanbol.entityhub.servicesapi.site.ReferencedSiteConfiguration;
import org.apache.stanbol.entityhub.servicesapi.site.Site;
import org.apache.stanbol.entityhub.servicesapi.site.SiteConfiguration;
import org.apache.stanbol.entityhub.servicesapi.site.SiteException;
import org.apache.stanbol.entityhub.servicesapi.site.SiteManager;
import org.apache.stanbol.entityhub.servicesapi.util.AdaptingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/entityhub/site/{site}")
public class ReferencedSiteRootResource
extends BaseStanbolResource {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final Set<String> RDF_MEDIA_TYPES = new TreeSet<String>(Arrays.asList("text/rdf+n3", "text/rdf+nt", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/rdf+json"));
    public static final String LICENSE_PATH = "license";
    private static final String LICENSE_NAME = "LICENSE";
    private static final String DEFAULT_FIND_FIELD = RDFS.label.getUnicodeString();
    private static final int DEFAULT_FIND_RESULT_LIMIT = 5;
    private Site site;
    private NamespacePrefixService nsPrefixService;

    public ReferencedSiteRootResource(@PathParam(value="site") String siteId, @Context ServletContext servletContext) {
        this.log.debug("<init> with site {}", (Object)siteId);
        SiteManager referencedSiteManager = (SiteManager)ContextHelper.getServiceFromContext(SiteManager.class, (ServletContext)servletContext);
        if (siteId == null || siteId.isEmpty()) {
            this.log.error("Missing path parameter site={}", (Object)siteId);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.site = referencedSiteManager.getSite(siteId);
        if (this.site == null) {
            this.log.error("Site {} not found (no referenced site with that ID is present within the Entityhub", (Object)siteId);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (this.site instanceof ManagedSite) {
            this.log.debug("   ... init ManagedSite");
        }
        this.nsPrefixService = (NamespacePrefixService)ContextHelper.getServiceFromContext(NamespacePrefixService.class, (ServletContext)servletContext);
    }

    @OPTIONS
    public Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Produces(value={"text/html"})
    public Response getHtmlInfo(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("index", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Produces(value={"application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt"})
    public Response getInfo(@Context HttpHeaders headers, @Context UriInfo uriInfo) {
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, JerseyUtils.REPRESENTATION_SUPPORTED_MEDIA_TYPES, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        Response.ResponseBuilder rb = Response.ok((Object)this.site2Representation(uriInfo.getAbsolutePath().toString()));
        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @GET
    @Path(value="license/{name}")
    public Response getLicenseInfo(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="name") String name) {
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (name != null && !name.isEmpty() && name.startsWith(LICENSE_NAME)) {
            try {
                String numberString = name.substring(LICENSE_NAME.length());
                if (numberString.isEmpty()) {
                    numberString = "0";
                }
                int count = -1;
                if (this.site.getConfiguration().getLicenses() != null) {
                    for (License license : this.site.getConfiguration().getLicenses()) {
                        if (license.getUrl() == null) {
                            ++count;
                        }
                        if (!Integer.toString(count).equals(numberString)) continue;
                        Response.ResponseBuilder rb = Response.ok((Object)this.license2Representation(uriInfo.getAbsolutePath().toString(), license));
                        rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
                        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                        return rb.build();
                    }
                }
            }
            catch (NumberFormatException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No License found.\n").header("Accept", (Object)acceptedMediaType).build();
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @OPTIONS
    @Path(value="/entity")
    public Response handleCorsPreflightEntity(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        if (this.site instanceof ManagedSite) {
            CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"OPTIONS", "GET", "POST", "PUT", "DELETE"});
        } else {
            CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"OPTIONS", "GET"});
        }
        return res.build();
    }

    @GET
    @Path(value="/entity")
    public Response getEntityById(@QueryParam(value="id") String id, @Context HttpHeaders headers) {
        Entity entity;
        this.log.debug("site/{}/entity Request", (Object)this.site.getId());
        this.log.debug("  > id       : " + id);
        this.log.debug("  > accept   : " + headers.getAcceptableMediaTypes());
        this.log.debug("  > mediaType: " + headers.getMediaType());
        HashSet<String> supported = new HashSet<String>(JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (id == null || id.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("entity", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No or empty ID was parsed. Missing parameter id.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        this.log.debug("handle Request for Entity {} of Site {}", (Object)id, (Object)this.site.getId());
        try {
            entity = this.site.getEntity(id);
        }
        catch (SiteException e) {
            this.log.error("ReferencedSiteException while accessing Site " + this.site.getConfiguration().getName() + " (id=" + this.site.getId() + ")", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (entity != null) {
            Response.ResponseBuilder rb = Response.ok((Object)entity);
            rb.header("Content-Type", (Object)(acceptedMediaType + "; charset=utf-8"));
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
            return rb.build();
        }
        this.log.debug(" ... Entity {} not found on referenced site {}", (Object)id, (Object)this.site.getId());
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Entity '" + id + "' not found on referenced site '" + this.site.getId() + "'\n")).header("Accept", (Object)acceptedMediaType).build();
    }

    @POST
    @Path(value="entity/")
    @Consumes(value={"*/*"})
    public Response createEntity(@QueryParam(value="id") String id, @QueryParam(value="update") boolean allowUpdate, Map<String, Representation> parsed, @Context HttpHeaders headers) {
        this.log.info("Headers: " + headers.getRequestHeaders());
        this.log.info("Entity: " + id);
        this.log.info("Representations : {} parsed", (Object)parsed.size());
        return this.updateOrCreateEntity(id, parsed, "POST", true, allowUpdate, headers);
    }

    @PUT
    @Path(value="entity/")
    @Consumes(value={"*/*"})
    public Response updateEntity(@QueryParam(value="id") String id, @QueryParam(value="create") @DefaultValue(value="true") boolean allowCreate, Map<String, Representation> parsed, @Context HttpHeaders headers) {
        this.log.info("Headers: " + headers.getRequestHeaders());
        this.log.info("Entity: " + id);
        this.log.info("Representations : {} parsed", (Object)parsed.size());
        return this.updateOrCreateEntity(id, parsed, "PUT", allowCreate, true, headers);
    }

    private Response updateOrCreateEntity(String id, Map<String, Representation> parsed, String requestMethod, boolean create, boolean update, HttpHeaders headers) {
        Response.ResponseBuilder builder;
        long start = System.currentTimeMillis();
        MediaType accepted = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (!(this.site instanceof ManagedSite)) {
            Response.ResponseBuilder builder2 = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("The Site '%s' is not managed and does not support create/update nor delete operations", this.site.getId())).header("Accept", (Object)accepted);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)builder2, (HttpHeaders)headers);
            return builder2.build();
        }
        ManagedSite managedSite = (ManagedSite)this.site;
        if (id != null && !"*".equals(id)) {
            Representation r = parsed.get(id);
            if (r == null) {
                Response.ResponseBuilder builder3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Parsed RDF data do not contain any Information about the parsed id '%s'", id)).header("Accept", (Object)accepted);
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)builder3, (HttpHeaders)headers);
                return builder3.build();
            }
            parsed = Collections.singletonMap(id, r);
        }
        if (!create || !update) {
            this.log.debug("   ... validate parsed Representation state (create: {}| update: {})", (Object)create, (Object)update);
            for (Map.Entry<String, Representation> entry : parsed.entrySet()) {
                boolean exists;
                try {
                    exists = managedSite.getEntity(entry.getKey()) != null;
                }
                catch (SiteException e) {
                    this.log.error(String.format("Exception while checking the existance of an Entity with id  %s in the Entityhub.", entry.getKey()), (Throwable)e);
                    Response.ResponseBuilder builder4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Unable to process Entity %s because ofan Error while checking the current version of thatEntity within the Entityhub (Message: %s)", entry.getKey(), e.getMessage())).header("Accept", (Object)accepted);
                    CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)builder4, (HttpHeaders)headers);
                    return builder4.build();
                }
                if ((!exists || update) && (exists || create)) continue;
                Response.ResponseBuilder builder5 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Unable to %s an Entity %s becuase it %s and %s is deactivated.  You might want to set the '%s' parameter to TRUE in your Request", exists ? "update" : "create", entry.getKey(), exists ? "does already exists " : "does not", exists ? "updateing existing" : "creating new", exists ? "does already" : "does not exists", exists ? "update" : "create")).header("Accept", (Object)accepted);
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)builder5, (HttpHeaders)headers);
                return builder5.build();
            }
        }
        long validateCompleted = System.currentTimeMillis();
        this.log.info("   ... validate request data {}ms", (Object)(validateCompleted - start));
        try {
            managedSite.store(parsed.values());
        }
        catch (ManagedSiteException e) {
            this.log.error(String.format("Exception while storing parsed Representations in the ManagedSite %s", managedSite.getId()), (Throwable)e);
            Response.ResponseBuilder builder6 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unable to store parsed Entities to ManagedSite " + managedSite.getId() + " because of an error (Message: " + e.getMessage() + ")")).header("Accept", (Object)accepted);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)builder6, (HttpHeaders)headers);
            return builder6.build();
        }
        if (create && parsed.size() == 1) {
            String createdId = parsed.keySet().iterator().next();
            URI created = this.uriInfo.getRequestUriBuilder().queryParam("id", new Object[]{createdId}).build(new Object[0]);
            builder = Response.created((URI)created);
            builder.header("Accept", (Object)accepted);
        } else {
            builder = Response.noContent();
        }
        this.log.info("   ... create/update {} entities in {}ms", (Object)parsed.size(), (Object)(System.currentTimeMillis() - validateCompleted));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)builder, (HttpHeaders)headers);
        return builder.build();
    }

    @DELETE
    @Path(value="entity/")
    public Response deleteEntity(@QueryParam(value="id") String id, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        MediaType accepted = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (!(this.site instanceof ManagedSite)) {
            Response.ResponseBuilder builder2 = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("The Site '%s' is not managed and does not support create/update nor delete operations", this.site.getId())).header("Accept", (Object)accepted);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)builder2, (HttpHeaders)headers);
            return builder2.build();
        }
        ManagedSite managedSite = (ManagedSite)this.site;
        if (id == null || id.isEmpty()) {
            Response.ResponseBuilder builder3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The Request doesnot provide the id of the Entity to delete (parameter 'id').").header("Accept", (Object)accepted);
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)builder3, (HttpHeaders)headers);
            return builder3.build();
        }
        try {
            if ("*".equals(id)) {
                managedSite.deleteAll();
                builder = Response.noContent();
            } else if (managedSite.getEntity(id) != null) {
                managedSite.delete(id);
                builder = Response.noContent();
            } else {
                builder = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No Entity with the parsed Id '" + id + "' is present on the ManagedSite '" + managedSite.getId() + "'!")).header("Accept", (Object)accepted);
            }
        }
        catch (SiteException e) {
            String message = "Exception while deleting '" + id + "' from ManagedSite '" + managedSite.getId() + "'!";
            this.log.error(message, (Throwable)e);
            builder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(message + ' ' + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getMessage())).header("Accept", (Object)accepted);
        }
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)builder, (HttpHeaders)headers);
        return builder.build();
    }

    @OPTIONS
    @Path(value="/find")
    public Response handleCorsPreflightFind(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @GET
    @Path(value="/find")
    public Response findEntitybyGet(@QueryParam(value="name") String name, @QueryParam(value="field") String field, @QueryParam(value="lang") String language, @QueryParam(value="limit") @DefaultValue(value="-1") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return this.findEntity(name, field, language, limit, offset, ldpath, headers);
    }

    @POST
    @Path(value="/find")
    public Response findEntity(@FormParam(value="name") String name, @FormParam(value="field") String parsedField, @FormParam(value="lang") String language, @FormParam(value="limit") Integer limit, @FormParam(value="offset") Integer offset, @FormParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        String property;
        this.log.debug("site/{}/find Request", (Object)this.site.getId());
        HashSet<String> supported = new HashSet<String>(JerseyUtils.QUERY_RESULT_SUPPORTED_MEDIA_TYPES);
        supported.add("text/html");
        MediaType acceptedMediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, supported, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (name == null || name.isEmpty()) {
            if (MediaType.TEXT_HTML_TYPE.isCompatible(acceptedMediaType)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("find", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
                return rb.build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The name must not be null nor empty for find requests. Missing parameter name.\n").header("Accept", (Object)acceptedMediaType).build();
        }
        if (parsedField == null) {
            property = DEFAULT_FIND_FIELD;
        } else if ((parsedField = parsedField.trim()).isEmpty()) {
            property = DEFAULT_FIND_FIELD;
        } else {
            property = this.nsPrefixService.getFullName(parsedField);
            if (property == null) {
                String messsage = String.format("The prefix '%s' of the parsed field '%' is not mapped to any namespace. Please parse the full URI instead!\n", NamespaceMappingUtils.getPrefix((String)parsedField), parsedField);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)messsage).header("Accept", (Object)acceptedMediaType).build();
            }
        }
        return this.executeQuery(JerseyUtils.createFieldQueryForFindRequest(name, property, language, limit == null || limit < 1 ? 5 : limit, offset, ldpath), headers);
    }

    @OPTIONS
    @Path(value="/query")
    public Response handleCorsPreflightQuery(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/json"})
    public Response queryEntities(FieldQuery query, @Context HttpHeaders headers) {
        return this.executeQuery(query, headers);
    }

    @GET
    @Path(value="/query")
    @Produces(value={"text/html"})
    public Response getQueryDocumentation(@Context HttpHeaders headers) {
        Response.ResponseBuilder rb = Response.ok((Object)new Viewable("query", (Object)this));
        rb.header("Content-Type", (Object)"text/html; charset=utf-8");
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response executeQuery(FieldQuery query, HttpHeaders headers) throws WebApplicationException {
        QueryResultList result;
        MediaType mediaType = MediaTypeUtil.getAcceptableMediaType((HttpHeaders)headers, JerseyUtils.ENTITY_SUPPORTED_MEDIA_TYPES, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        if (query instanceof LDPathSelect && ((LDPathSelect)query).getLDPathSelect() != null) {
            return this.executeLDPathQuery(query, ((LDPathSelect)query).getLDPathSelect(), mediaType, headers);
        }
        try {
            result = this.site.find(query);
        }
        catch (SiteException e) {
            String message = String.format("Unable to Query Site '%s' (message: %s)", this.site.getId(), e.getMessage());
            this.log.error(message, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).header("Accept", (Object)mediaType).build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.header("Content-Type", (Object)(mediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    private Response executeLDPathQuery(FieldQuery query, String ldpathProgramString, MediaType mediaType, HttpHeaders headers) {
        AdaptingIterator resultIt;
        Program<Object> program;
        RdfValueFactory vf = new RdfValueFactory((MGraph)new IndexedMGraph());
        SiteBackend backend = new SiteBackend(this.site, (ValueFactory)vf);
        EntityhubLDPath ldPath = new EntityhubLDPath((RDFBackend)backend, (ValueFactory)vf);
        HashSet<String> selectedFields = new HashSet<String>(query.getSelectedFields());
        try {
            program = LDPathHelper.prepareQueryLDPathProgram(ldpathProgramString, selectedFields, (AbstractBackend)backend, ldPath);
        }
        catch (LDPathParseException e) {
            this.log.warn("Unable to parse LDPath program used as select for Query:");
            this.log.warn("FieldQuery: \n {}", (Object)query);
            this.log.warn("LDPath: \n {}", (Object)((LDPathSelect)query).getLDPathSelect());
            this.log.warn("Exception:", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unable to parse LDPath program (Messages: " + LDPathHelper.getLDPathParseExceptionMessage(e) + ")!\n")).header("Accept", (Object)mediaType).build();
        }
        catch (IllegalStateException e) {
            this.log.warn("parsed LDPath program is not compatible with parsed Query!", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).header("Accept", (Object)mediaType).build();
        }
        try {
            resultIt = new AdaptingIterator(this.site.findEntities(query).iterator(), (AdaptingIterator.Adapter)new AdaptingIterator.Adapter<Entity, Representation>(){

                public Representation adapt(Entity value, Class<Representation> type) {
                    return value.getRepresentation();
                }
            }, Representation.class);
        }
        catch (SiteException e) {
            String message = String.format("Unable to Query Site '%s' (message: %s)", this.site.getId(), e.getMessage());
            this.log.error(message, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).header("Accept", (Object)mediaType).build();
        }
        Collection<Representation> transformedResults = LDPathHelper.transformQueryResults((Iterator<Representation>)resultIt, program, selectedFields, ldPath, (AbstractBackend)backend, (ValueFactory)vf);
        QueryResultListImpl result = new QueryResultListImpl(query, transformedResults, Representation.class);
        Response.ResponseBuilder rb = Response.ok((Object)result);
        rb.header("Content-Type", (Object)(mediaType + "; charset=utf-8"));
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)headers);
        return rb.build();
    }

    @OPTIONS
    @Path(value="/ldpath")
    public Response handleCorsPreflightLDPath(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[]{"OPTIONS", "GET", "POST"});
        return res.build();
    }

    @GET
    @Path(value="/ldpath")
    public Response handleLDPathGet(@QueryParam(value="context") Set<String> contexts, @QueryParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return this.handleLDPathPost(contexts, ldpath, headers);
    }

    @POST
    @Path(value="/ldpath")
    public Response handleLDPathPost(@FormParam(value="context") Set<String> contexts, @FormParam(value="ldpath") String ldpath, @Context HttpHeaders headers) {
        return LDPathHelper.handleLDPathRequest(this, (RDFBackend<Object>)new SiteBackend(this.site), ldpath, contexts, headers, this.servletContext);
    }

    private Representation site2Representation(String id) {
        RdfValueFactory valueFactory = RdfValueFactory.getInstance();
        RdfRepresentation rep = valueFactory.createRepresentation(id);
        String namespace = NamespaceEnum.entityhub.getNamespace();
        rep.add(namespace + "localMode", (Object)this.site.supportsLocalMode());
        rep.add(namespace + "supportsSearch", (Object)this.site.supportsSearch());
        SiteConfiguration config = this.site.getConfiguration();
        rep.add("http://www.w3.org/2000/01/rdf-schema#label", (Object)config.getName());
        rep.add("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", (Object)valueFactory.createReference((Object)(namespace + "ReferencedSite")));
        if (config.getDescription() != null) {
            rep.add("http://www.w3.org/2000/01/rdf-schema#description", (Object)config.getDescription());
        }
        if (config.getAttribution() != null) {
            rep.add("http://creativecommons.org/ns#attributionName", (Object)config.getAttribution());
        }
        if (config.getAttributionUrl() != null) {
            rep.add("http://creativecommons.org/ns#attributionURL", (Object)config.getAttributionUrl());
        }
        if (config.getLicenses() != null) {
            int count = 0;
            for (License license : config.getLicenses()) {
                String licenseUrl;
                if (license.getUrl() != null) {
                    licenseUrl = license.getUrl();
                } else {
                    licenseUrl = id + (!id.endsWith("/") ? "/" : "") + LICENSE_PATH + '/' + LICENSE_NAME + (count > 0 ? Integer.valueOf(count) : "");
                    ++count;
                }
                if (license.getName() != null) {
                    rep.add("http://purl.org/dc/terms/license", (Object)licenseUrl);
                }
                rep.add("http://creativecommons.org/ns#license", (Object)licenseUrl);
            }
        }
        if (config.getEntityPrefixes() != null) {
            for (String prefix : config.getEntityPrefixes()) {
                rep.add(namespace + "entityPrefix", (Object)prefix);
            }
        } else {
            rep.add(namespace + "entityPrefix", (Object)"*");
        }
        if (config instanceof ReferencedSiteConfiguration) {
            ReferencedSiteConfiguration refConfig = (ReferencedSiteConfiguration)config;
            if (refConfig.getCacheStrategy() != null) {
                rep.add(namespace + "cacheStrategy", (Object)valueFactory.createReference((Object)(namespace + "cacheStrategy-" + refConfig.getCacheStrategy().name())));
            }
            if (refConfig.getAccessUri() != null) {
                rep.add(namespace + "accessUri", (Object)valueFactory.createReference((Object)refConfig.getAccessUri()));
            }
            if (refConfig.getQueryUri() != null) {
                rep.add(namespace + "queryUri", (Object)valueFactory.createReference((Object)refConfig.getQueryUri()));
            }
        }
        return rep;
    }

    private Representation license2Representation(String id, License license) {
        RdfValueFactory valueFactory = RdfValueFactory.getInstance();
        RdfRepresentation rep = valueFactory.createRepresentation(id);
        if (license.getName() != null) {
            rep.add("http://purl.org/dc/terms/license", (Object)license.getName());
            rep.add("http://www.w3.org/2000/01/rdf-schema#label", (Object)license.getName());
            rep.add("http://purl.org/dc/terms/title", (Object)license.getName());
        }
        if (license.getText() != null) {
            rep.add("http://www.w3.org/2000/01/rdf-schema#description", (Object)license.getText());
        }
        rep.add("http://creativecommons.org/ns#licenseUrl", (Object)(license.getUrl() == null ? id : license.getUrl()));
        return rep;
    }

    public boolean isManagedSite() {
        return this.site instanceof ManagedSite;
    }

    public Site getSite() {
        return this.site;
    }
}

