/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.resource.reconcile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.stanbol.commons.namespaceprefix.NamespaceMappingUtils;
import org.apache.stanbol.commons.namespaceprefix.NamespacePrefixService;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.commons.web.base.utils.MediaTypeUtil;
import org.apache.stanbol.entityhub.jersey.grefine.ReconcileProperty;
import org.apache.stanbol.entityhub.jersey.grefine.ReconcileQuery;
import org.apache.stanbol.entityhub.jersey.grefine.ReconcileValue;
import org.apache.stanbol.entityhub.jersey.grefine.Utils;
import org.apache.stanbol.entityhub.servicesapi.EntityhubException;
import org.apache.stanbol.entityhub.servicesapi.defaults.SpecialFieldEnum;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.Text;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.query.ReferenceConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.SimilarityConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.TextConstraint;
import org.apache.stanbol.entityhub.servicesapi.query.ValueConstraint;
import org.apache.stanbol.entityhub.servicesapi.site.SiteException;
import org.apache.stanbol.entityhub.servicesapi.util.ModelUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGoogleRefineReconcileResource
extends BaseStanbolResource {
    private final Logger log = LoggerFactory.getLogger(BaseGoogleRefineReconcileResource.class);
    private static final String NAME_FIELD = "http://www.w3.org/2000/01/rdf-schema#label";
    private static final String TYPE_FIELD = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private static final Collection<String> SELECTED_FIELDS = Collections.unmodifiableList(Arrays.asList("http://www.w3.org/2000/01/rdf-schema#label", "http://www.w3.org/1999/02/22-rdf-syntax-ns#type"));
    private static final Comparator<JSONObject> resultScoreComparator = new Comparator<JSONObject>(){

        @Override
        public int compare(JSONObject o1, JSONObject o2) {
            try {
                return Double.compare(o2.getDouble("score"), o1.getDouble("score"));
            }
            catch (JSONException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    protected final NamespacePrefixService nsPrefixService;

    protected BaseGoogleRefineReconcileResource(ServletContext context) {
        this.nsPrefixService = (NamespacePrefixService)ContextHelper.getServiceFromContext(NamespacePrefixService.class, (ServletContext)context);
    }

    @OPTIONS
    public final Response handleCorsPreflight(@Context HttpHeaders headers) {
        Response.ResponseBuilder res = Response.ok();
        CorsHelper.enableCORS((ServletContext)this.servletContext, (Response.ResponseBuilder)res, (HttpHeaders)headers, (String[])new String[0]);
        return res.build();
    }

    @POST
    public final Response queryPOST(@FormParam(value="query") String query, @FormParam(value="queries") String queries, @FormParam(value="callback") String callback, @Context HttpHeaders header) throws WebApplicationException {
        return this.query(query, queries, callback, header);
    }

    @GET
    public final Response query(@QueryParam(value="query") String query, @QueryParam(value="queries") String queries, @QueryParam(value="callback") String callback, @Context HttpHeaders header) throws WebApplicationException {
        JSONObject jResult;
        if (callback != null) {
            this.log.info("callback: {}", (Object)callback);
            try {
                return this.sendMetadata(callback, header);
            }
            catch (JSONException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        if (query != null) {
            this.log.debug("query: {}", (Object)query);
            try {
                jResult = this.reconcile(ReconcileQuery.parseQuery(query, this.nsPrefixService));
            }
            catch (JSONException e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Error while writing Reconcilation results (%s: %s)", JSONException.class.getSimpleName(), e.getMessage())).build());
            }
            catch (EntityhubException e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Error while searching on %s (%s: %s)", this.getSiteName(), SiteException.class.getSimpleName(), e.getMessage())).build());
            }
        } else if (queries != null) {
            this.log.debug("multi-query: {}", (Object)queries);
            try {
                jResult = this.reoncile(ReconcileQuery.parseQueries(queries, this.nsPrefixService));
            }
            catch (JSONException e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Error while writing Reconcilation results (%s: %s)", JSONException.class.getSimpleName(), e.getMessage())).build());
            }
            catch (EntityhubException e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Error while searching on %s (%s: %s)", this.getSiteName(), SiteException.class.getSimpleName(), e.getMessage())).build());
            }
        } else {
            if (MediaTypeUtil.isAcceptableMediaType((HttpHeaders)header, (MediaType)MediaType.TEXT_HTML_TYPE)) {
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("index", (Object)this));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)header);
                return rb.build();
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"One of the 'query' or 'querues' or 'callback=jsonp' parameter MUST BE present!").build());
        }
        Response.ResponseBuilder rb = Response.ok((Object)jResult.toString()).type(MediaType.APPLICATION_JSON_TYPE);
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)header);
        return rb.build();
    }

    private JSONObject reoncile(Map<String, ReconcileQuery> parsedQueries) throws JSONException, EntityhubException {
        JSONObject container = new JSONObject();
        for (Map.Entry<String, ReconcileQuery> query : parsedQueries.entrySet()) {
            container.put(query.getKey(), (Object)this.reconcile(query.getValue()));
        }
        return container;
    }

    private JSONObject reconcile(ReconcileQuery rQuery) throws JSONException, EntityhubException {
        FieldQuery query = this.createFieldQuery();
        query.addSelectedFields(SELECTED_FIELDS);
        this.addNameConstraint(rQuery, query);
        this.addTypeConstraint(rQuery, query);
        this.addPropertyConstraints(rQuery, query);
        query.setLimit(query.getLimit());
        QueryResultList<Representation> results = this.performQuery(query);
        ArrayList<JSONObject> jResultList = new ArrayList<JSONObject>(results.size());
        double maxQueryScore = -1.0;
        if (!results.isEmpty()) {
            for (Representation r : results) {
                if (maxQueryScore < 0.0) {
                    maxQueryScore = ((Number)r.getFirst(RdfResourceEnum.resultScore.getUri(), Number.class)).doubleValue();
                }
                JSONObject jResult = new JSONObject();
                jResult.put("id", (Object)r.getId());
                double similarity = 0.0;
                String name = null;
                Iterator labels = r.getText(NAME_FIELD);
                while (labels.hasNext()) {
                    Text label = (Text)labels.next();
                    if (label.getText().equalsIgnoreCase(rQuery.getQuery())) {
                        name = label.getText();
                        similarity = 1.0;
                        break;
                    }
                    double curSimilarity = Utils.levenshtein(rQuery.getQuery(), label.getText());
                    if (!(similarity < curSimilarity)) continue;
                    name = label.getText();
                    similarity = curSimilarity;
                }
                jResult.put("name", name);
                Iterator types = r.getReferences(TYPE_FIELD);
                if (types != null && types.hasNext()) {
                    jResult.put("type", (Object)new JSONArray(ModelUtils.asCollection((Iterator)types)));
                }
                double normalisedScore = ((Number)r.getFirst(RdfResourceEnum.resultScore.getUri(), Number.class)).doubleValue();
                normalisedScore = normalisedScore * similarity / maxQueryScore;
                jResult.put("score", normalisedScore);
                jResult.put("match", similarity >= 0.0);
                jResultList.add(jResult);
            }
        }
        Collections.sort(jResultList, resultScoreComparator);
        JSONObject jResultContainer = new JSONObject();
        jResultContainer.put("result", (Object)new JSONArray(jResultList));
        return jResultContainer;
    }

    protected abstract QueryResultList<Representation> performQuery(FieldQuery var1) throws EntityhubException;

    protected abstract String getSiteName();

    protected abstract FieldQuery createFieldQuery();

    private void addPropertyConstraints(ReconcileQuery rQuery, FieldQuery query) {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<String> texts = new ArrayList<String>();
        HashSet<Object> values = new HashSet<Object>();
        HashSet<String> references = new HashSet<String>();
        ArrayList<String> fullText = new ArrayList<String>();
        StringBuilder similarityContext = new StringBuilder();
        LinkedHashSet<String> similarityFields = new LinkedHashSet<String>();
        for (Map.Entry<ReconcileProperty, Collection<ReconcileValue>> propertyEntry : rQuery.getProperties()) {
            ReconcileProperty property = propertyEntry.getKey();
            for (ReconcileValue value : propertyEntry.getValue()) {
                if (value.getId() != null) {
                    ids.add(value.getId());
                }
                if (value.getValue() instanceof String) {
                    texts.add((String)value.getValue());
                    continue;
                }
                values.add(value.getValue());
            }
            if (property.isSpecial()) {
                if (property.getName().equalsIgnoreCase("references")) {
                    if (property.getParameter() != null) {
                        this.log.warn("parameters are not supported for @references -> ignore '{}'", (Object)property.getParameter());
                    }
                    if (ids.isEmpty()) {
                        this.log.warn("No URI values present for parsed @references property! (values: " + propertyEntry.getValue());
                    }
                    for (String id : ids) {
                        references.add(id);
                    }
                } else if (property.getName().equalsIgnoreCase("fulltext")) {
                    if (property.getParameter() != null) {
                        this.log.warn("parameters are not supported for @fullText -> ignore '{}'", (Object)property.getParameter());
                    }
                    for (String text : texts) {
                        fullText.add(text);
                    }
                } else if (property.getName().equalsIgnoreCase("similarity")) {
                    String propUri;
                    String string = propUri = property.getParameter() != null ? this.nsPrefixService.getFullName(property.getParameter()) : SpecialFieldEnum.fullText.getUri();
                    if (propUri != null) {
                        similarityFields.add(propUri);
                    } else {
                        this.log.warn("Unknown prefix '{}' used by Google Refine query parameter of property '{}'! Will use the full text field as fallback", (Object)NamespaceMappingUtils.getPrefix((String)property.getParameter()), (Object)property);
                        similarityFields.add(SpecialFieldEnum.fullText.getUri());
                    }
                    for (String text : texts) {
                        similarityContext.append(text).append(' ');
                    }
                } else {
                    this.log.warn("ignore unsupported special property {}", (Object)property);
                }
            } else if (!ids.isEmpty()) {
                query.setConstraint(property.getName(), (Constraint)new ReferenceConstraint(ids));
                if (ids.size() != propertyEntry.getValue().size()) {
                    this.log.info("Only some of the parsed values of the field {} containreferences -> will ignore values with missing references");
                }
            } else if (!texts.isEmpty()) {
                query.setConstraint(property.getName(), (Constraint)new TextConstraint(texts, new String[0]));
                if (ids.size() != propertyEntry.getValue().size()) {
                    this.log.info("Only some of the parsed values of the field {} areof type String -> will ignore non-string values");
                }
            } else if (!values.isEmpty()) {
                query.setConstraint(property.getName(), (Constraint)new ValueConstraint(values));
            }
            ids.clear();
            texts.clear();
            values.clear();
        }
        if (!references.isEmpty()) {
            ReferenceConstraint refConstraint = new ReferenceConstraint(references, ValueConstraint.MODE.all);
            query.setConstraint(SpecialFieldEnum.references.getUri(), (Constraint)refConstraint);
        }
        if (!fullText.isEmpty()) {
            TextConstraint textConstraint = new TextConstraint(fullText, new String[0]);
            query.setConstraint(SpecialFieldEnum.fullText.getUri(), (Constraint)textConstraint);
        }
        if (similarityContext.length() > 0 && !similarityFields.isEmpty()) {
            SimilarityConstraint simConstraint;
            Iterator fieldIt = similarityFields.iterator();
            String field = (String)fieldIt.next();
            if (fieldIt.hasNext()) {
                ArrayList addFields = new ArrayList(similarityFields.size() - 1);
                while (fieldIt.hasNext()) {
                    addFields.add(fieldIt.next());
                }
                simConstraint = new SimilarityConstraint(similarityContext.toString(), addFields);
            } else {
                simConstraint = new SimilarityConstraint(similarityContext.toString());
            }
            query.setConstraint(field, (Constraint)simConstraint);
        }
    }

    private void addTypeConstraint(ReconcileQuery rQuery, FieldQuery query) {
        Collection<ReconcileValue> additionalTypes = rQuery.removeProperty(TYPE_FIELD);
        Set<String> queryTypes = rQuery.getTypes();
        Set<String> types = null;
        if (additionalTypes == null) {
            if (queryTypes != null) {
                types = queryTypes;
            }
        } else {
            types = new HashSet<String>();
            if (queryTypes != null) {
                types.add(rQuery.getQuery());
            }
            for (ReconcileValue value : additionalTypes) {
                if (value == null) continue;
                if (value.getId() != null) {
                    types.add(value.getId());
                    continue;
                }
                if (!(value.getValue() instanceof String)) continue;
                types.add((String)value.getValue());
            }
        }
        if (!types.isEmpty()) {
            query.setConstraint(TYPE_FIELD, (Constraint)new ReferenceConstraint(types));
        }
    }

    private void addNameConstraint(ReconcileQuery rQuery, FieldQuery query) {
        List<String> values;
        Collection<ReconcileValue> additionalValues = rQuery.removeProperty(NAME_FIELD);
        if (additionalValues == null) {
            values = Collections.singletonList(rQuery.getQuery());
        } else {
            values = new ArrayList<String>(additionalValues.size() + 1);
            values.add(rQuery.getQuery());
            for (ReconcileValue value : additionalValues) {
                if (value == null || !(value.getValue() instanceof String)) continue;
                values.add((String)value.getValue());
            }
        }
        query.setConstraint(NAME_FIELD, (Constraint)new TextConstraint(values, new String[0]));
    }

    protected Response sendMetadata(String callback, HttpHeaders header) throws JSONException {
        JSONObject jMetadata = new JSONObject();
        jMetadata.put("name", (Object)("Stanbol Entityhub: " + this.getSiteName()));
        StringBuilder callbackString = new StringBuilder(callback);
        callbackString.append('(');
        callbackString.append(jMetadata.toString());
        callbackString.append(')');
        Response.ResponseBuilder rb = Response.ok((Object)callbackString.toString()).type(MediaType.APPLICATION_JSON_TYPE);
        CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)header);
        return rb.build();
    }
}

