/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.grefine;

import org.apache.commons.lang.StringUtils;
import org.apache.stanbol.commons.namespaceprefix.NamespaceMappingUtils;
import org.apache.stanbol.commons.namespaceprefix.NamespacePrefixService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconcileProperty {
    private static final Logger log = LoggerFactory.getLogger(ReconcileProperty.class);
    public static final char SPECIAL_PROPERTY_PREFIX = '@';
    public static final char SPECAIL_PROPERTY_VALUE_SEPARATOR = ':';
    private final boolean special;
    private final String name;
    private final String parameter;

    private ReconcileProperty(boolean special, String name, String parameter) {
        this.special = special;
        this.name = name;
        this.parameter = parameter;
    }

    public static boolean isSpecialProperty(String propertyString) {
        return (propertyString = StringUtils.trimToNull((String)propertyString)) != null && propertyString.length() > 1 && propertyString.charAt(0) == '@';
    }

    public static ReconcileProperty parseProperty(String propertyString, NamespacePrefixService nxPrefixService) {
        if ((propertyString = StringUtils.trimToNull((String)propertyString)) != null) {
            boolean special;
            if ((propertyString = StringUtils.trimToNull((String)propertyString)) == null) {
                log.warn("Unable to parse Reconcile Property: The parsed propertyString MUST contain some none trimable chars!");
                return null;
            }
            String propertyUri = nxPrefixService.getFullName(propertyString);
            if (propertyUri == null) {
                log.warn("The property '{}' uses the unknown prefix '{}' -> ignored", (Object)propertyString, (Object)NamespaceMappingUtils.getPrefix((String)propertyString));
                return null;
            }
            boolean bl = special = propertyUri.charAt(0) == '@';
            if (!special) {
                return new ReconcileProperty(special, propertyUri, null);
            }
            if (propertyUri.length() < 1) {
                log.warn("Unable to parse Reconcile Property: The parsed propertyString MUST NOT contain only the special property prefix '{}'!", (Object)Character.valueOf('@'));
                return null;
            }
            int valueSeparatorIndex = propertyUri.indexOf(58);
            String name = StringUtils.trimToNull((String)propertyUri.substring(1, valueSeparatorIndex > 0 ? valueSeparatorIndex : propertyUri.length()));
            if (name == null) {
                log.warn("Unable to parse Reconcile Property: The parsed special property '{}' has an empty property name!", (Object)propertyUri);
                return null;
            }
            return new ReconcileProperty(special, name, valueSeparatorIndex > 0 && valueSeparatorIndex < propertyUri.length() ? StringUtils.trimToNull((String)propertyUri.substring(valueSeparatorIndex + 1)) : null);
        }
        log.warn("Unable to parse Reconcile Property from NULL or an empty String!");
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getParameter() {
        return this.parameter;
    }

    public boolean hasParameter() {
        return this.parameter != null;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public int hashCode() {
        return this.name.hashCode() + (this.parameter != null ? this.parameter.hashCode() : 0) + (this.special ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (o instanceof ReconcileProperty && this.name.equals(((ReconcileProperty)o).name) && this.special == ((ReconcileProperty)o).special) {
            return this.parameter == null && ((ReconcileProperty)o).parameter == null || this.parameter != null && this.parameter.equals(((ReconcileProperty)o).parameter);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.special) {
            sb.append('@');
        }
        sb.append(this.name);
        if (this.parameter != null) {
            sb.append(':').append(this.parameter);
        }
        return sb.toString();
    }
}

