/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.serializedform.Parser;
import org.apache.clerezza.rdf.core.serializedform.UnsupportedParsingFormatException;
import org.apache.stanbol.commons.indexedgraph.IndexedMGraph;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.entityhub.jersey.utils.JerseyUtils;
import org.apache.stanbol.entityhub.jersey.utils.MessageBodyReaderUtils;
import org.apache.stanbol.entityhub.model.clerezza.RdfValueFactory;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/json", "text/rdf+n3", "text/rdf+nt", "application/rdf+xml", "text/turtle", "application/x-turtle", "application/rdf+json", "application/x-www-form-urlencoded", "multipart/form-data"})
public class RepresentationReader
implements MessageBodyReader<Map<String, Representation>> {
    private static final Logger log = LoggerFactory.getLogger(RepresentationReader.class);
    @Context
    protected ServletContext servletContext;
    public static final Set<String> supportedMediaTypes;
    private static final MediaType DEFAULT_ACCEPTED_MEDIA_TYPE;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        String mediaTypeWithoutParameter = mediaType.getType().toLowerCase() + '/' + mediaType.getSubtype().toLowerCase();
        log.debug("isreadable: [genericType: {}| mediaType {}]", (Object)genericType, (Object)mediaTypeWithoutParameter);
        boolean mediaTypeOK = supportedMediaTypes.contains(mediaTypeWithoutParameter) || "application/x-www-form-urlencoded".equals(mediaTypeWithoutParameter) || "multipart/form-data".equals(mediaTypeWithoutParameter);
        boolean typeOk = JerseyUtils.testParameterizedType(Map.class, new Class[]{String.class, Representation.class}, genericType);
        log.debug("type is {} for {} against Map<String,Representation>", (Object)(typeOk ? "compatible" : "incompatible"), (Object)genericType);
        return typeOk && mediaTypeOK;
    }

    public Map<String, Representation> readFrom(Class<Map<String, Representation>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MessageBodyReaderUtils.RequestData content;
        log.info("Read Representations from Request Data");
        long start = System.currentTimeMillis();
        String charset = "UTF-8";
        if (mediaType.getParameters().containsKey("charset")) {
            charset = (String)mediaType.getParameters().get("charset");
        }
        MediaType acceptedMediaType = RepresentationReader.getAcceptedMediaType(httpHeaders);
        log.info("readFrom: mediaType {} | accepted {} | charset {}", new Object[]{mediaType, acceptedMediaType, charset});
        if (mediaType.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            try {
                content = MessageBodyReaderUtils.formForm(entityStream, charset, "encoding", Arrays.asList("entity", "content"));
            }
            catch (IllegalArgumentException e) {
                log.info("Bad Request: {}", (Throwable)e);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.toString()).header("Accept", (Object)acceptedMediaType).build());
            }
            if (content.getMediaType() == null) {
                String message = String.format("Missing parameter %s used to specify the media type(supported values: %s", "encoding", supportedMediaTypes);
                log.info("Bad Request: {}", (Object)message);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).header("Accept", (Object)acceptedMediaType).build());
            }
            if (!this.isSupported(content.getMediaType())) {
                String message = String.format("Unsupported Content-Type specified by parameter encoding=%s (supported: %s)", content.getMediaType().toString(), supportedMediaTypes);
                log.info("Bad Request: {}", (Object)message);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).header("Accept", (Object)acceptedMediaType).build());
            }
        } else if (mediaType.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE)) {
            List<MessageBodyReaderUtils.RequestData> contents;
            log.info("read from MimeMultipart");
            try {
                contents = MessageBodyReaderUtils.fromMultipart(entityStream, mediaType);
            }
            catch (IllegalArgumentException e) {
                log.info("Bad Request: {}", (Object)e.toString());
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.toString()).header("Accept", (Object)acceptedMediaType).build());
            }
            if (contents.isEmpty()) {
                String message = "Request does not contain any Mime BodyParts.";
                log.info("Bad Request: {}", (Object)message);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).header("Accept", (Object)acceptedMediaType).build());
            }
            if (contents.size() > 1) {
                log.warn("{} Request contains more than one Parts: others than the first will be ignored", (Object)MediaType.MULTIPART_FORM_DATA_TYPE);
                for (int i = 1; i < contents.size(); ++i) {
                    MessageBodyReaderUtils.RequestData ignored = contents.get(i);
                    log.warn("  ignore Content {}: Name {}| MediaType {}", new Object[]{i + 1, ignored.getName(), ignored.getMediaType()});
                }
            }
            if ((content = contents.get(0)).getMediaType() == null) {
                String message = String.format("MediaType not specified for mime body part for file %s. The media type must be one of the supported values: %s", content.getName(), supportedMediaTypes);
                log.info("Bad Request: {}", (Object)message);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).header("Accept", (Object)acceptedMediaType).build());
            }
            if (!this.isSupported(content.getMediaType())) {
                String message = String.format("Unsupported Content-Type %s specified for mime body part for file %s (supported: %s)", content.getMediaType(), content.getName(), supportedMediaTypes);
                log.info("Bad Request: {}", (Object)message);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).header("Accept", (Object)acceptedMediaType).build());
            }
        } else {
            content = new MessageBodyReaderUtils.RequestData(mediaType, null, entityStream);
        }
        long readingCompleted = System.currentTimeMillis();
        log.info("   ... reading request data {}ms", (Object)(readingCompleted - start));
        Map<String, Representation> parsed = this.parseFromContent(content, acceptedMediaType);
        long parsingCompleted = System.currentTimeMillis();
        log.info("   ... parsing data {}ms", (Object)(parsingCompleted - readingCompleted));
        return parsed;
    }

    public Map<String, Representation> parseFromContent(MessageBodyReaderUtils.RequestData content, MediaType acceptedMediaType) {
        if (content.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            throw new UnsupportedOperationException("Parsing of JSON not yet implemented :(");
        }
        if (this.isSupported(content.getMediaType())) {
            RdfValueFactory valueFactory = RdfValueFactory.getInstance();
            HashMap<String, Representation> representations = new HashMap<String, Representation>();
            HashSet<NonLiteral> processed = new HashSet<NonLiteral>();
            Parser parser = (Parser)ContextHelper.getServiceFromContext(Parser.class, (ServletContext)this.servletContext);
            IndexedMGraph graph = new IndexedMGraph();
            try {
                parser.parse((MGraph)graph, content.getEntityStream(), content.getMediaType().toString());
            }
            catch (UnsupportedParsingFormatException e) {
                String message = "Unable to create the Parser for the supported format" + content.getMediaType() + " (" + (Object)((Object)e) + ")";
                log.error(message, (Throwable)e);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).header("Accept", (Object)acceptedMediaType).build());
            }
            catch (Exception e) {
                String message = "Unable to create the Parser for the supported format " + content.getMediaType() + " (" + e + ")";
                log.error(message, (Throwable)e);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).header("Accept", (Object)acceptedMediaType).build());
            }
            Iterator st = graph.iterator();
            while (st.hasNext()) {
                NonLiteral resource = ((Triple)st.next()).getSubject();
                if (!(resource instanceof UriRef) || !processed.add(resource)) continue;
                representations.put(((UriRef)resource).getUnicodeString(), (Representation)valueFactory.createRdfRepresentation((UriRef)resource, (TripleCollection)graph));
            }
            return representations;
        }
        String message = String.format("Parsed Content-Type '%s' is not one of the supported %s", content.getMediaType(), supportedMediaTypes);
        log.info("Bad Request: {}", (Object)message);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).header("Accept", (Object)acceptedMediaType).build());
    }

    private static MediaType getAcceptedMediaType(MultivaluedMap<String, String> httpHeaders) {
        MediaType acceptedMediaType;
        String acceptedMediaTypeString = (String)httpHeaders.getFirst((Object)"Accept");
        if (acceptedMediaTypeString != null) {
            try {
                acceptedMediaType = MediaType.valueOf((String)acceptedMediaTypeString);
                if (acceptedMediaType.isWildcardType()) {
                    acceptedMediaType = DEFAULT_ACCEPTED_MEDIA_TYPE;
                }
            }
            catch (IllegalArgumentException e) {
                acceptedMediaType = DEFAULT_ACCEPTED_MEDIA_TYPE;
            }
        } else {
            acceptedMediaType = DEFAULT_ACCEPTED_MEDIA_TYPE;
        }
        return acceptedMediaType;
    }

    private boolean isSupported(MediaType mediaType) {
        return mediaType == null ? false : supportedMediaTypes.contains(mediaType.getType().toLowerCase() + '/' + mediaType.getSubtype().toLowerCase());
    }

    static {
        DEFAULT_ACCEPTED_MEDIA_TYPE = MediaType.TEXT_PLAIN_TYPE;
        HashSet<String> types = new HashSet<String>();
        types.add("application/json".toLowerCase());
        types.add("text/rdf+n3".toLowerCase());
        types.add("text/rdf+nt".toLowerCase());
        types.add("application/rdf+json".toLowerCase());
        types.add("application/rdf+xml".toLowerCase());
        types.add("text/turtle".toLowerCase());
        types.add("application/x-turtle".toLowerCase());
        supportedMediaTypes = Collections.unmodifiableSet(types);
    }
}

