/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.jersey.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URLDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.stanbol.entityhub.core.query.DefaultQueryFactory;
import org.apache.stanbol.entityhub.ldpath.query.LDPathFieldQueryImpl;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQueryFactory;
import org.apache.stanbol.entityhub.servicesapi.query.TextConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JerseyUtils {
    private static Logger log = LoggerFactory.getLogger(JerseyUtils.class);
    public static final Set<String> REPRESENTATION_SUPPORTED_MEDIA_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/json", "application/rdf+xml", "text/rdf+n3", "text/turtle", "application/x-turtle", "application/rdf+json", "text/rdf+nt")));
    public static final Set<String> ENTITY_SUPPORTED_MEDIA_TYPES = REPRESENTATION_SUPPORTED_MEDIA_TYPES;
    public static final Set<String> QUERY_RESULT_SUPPORTED_MEDIA_TYPES = REPRESENTATION_SUPPORTED_MEDIA_TYPES;
    private static FieldQueryFactory queryFactory = DefaultQueryFactory.getInstance();

    private JerseyUtils() {
    }

    public static FieldQuery createFieldQueryForFindRequest(String name, String field, String language, Integer limit, Integer offset, String ldpath) throws WebApplicationException, IllegalArgumentException {
        FieldQuery query;
        if (name == null || name.trim().isEmpty()) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("The parsed \"name\" pattern to search entities for MUST NOT be NULL nor EMPTY"), Response.Status.BAD_REQUEST);
        }
        name = name.trim();
        if (field == null || field.trim().isEmpty()) {
            new IllegalArgumentException("The parsed search \"field\" MUST NOT be NULL nor EMPTY");
        } else {
            field = field.trim();
        }
        log.debug("Process Find Request:");
        log.debug("  > name  : " + name);
        log.debug("  > field  : " + field);
        log.debug("  > lang  : " + language);
        log.debug("  > limit : " + limit);
        log.debug("  > offset: " + offset);
        log.debug("  > ldpath: " + ldpath);
        if (ldpath != null && !ldpath.isEmpty()) {
            query = new LDPathFieldQueryImpl();
            ((LDPathFieldQueryImpl)query).setLDPathSelect(ldpath);
        } else {
            query = queryFactory.createFieldQuery();
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.add(field);
            query.addSelectedFields(selectedFields);
        }
        if (language == null || language.trim().isEmpty()) {
            query.setConstraint(field, (Constraint)new TextConstraint(name, TextConstraint.PatternType.wildcard, false, new String[0]));
        } else {
            query.setConstraint(field, (Constraint)new TextConstraint(name, TextConstraint.PatternType.wildcard, false, new String[]{language}));
        }
        if (limit != null && limit > 0) {
            query.setLimit(limit);
        }
        if (offset != null && offset > 0) {
            query.setOffset(offset.intValue());
        }
        return query;
    }

    public static boolean testType(Class<?> required, Type genericType) {
        boolean typeOK;
        if (genericType instanceof Class) {
            typeOK = ((Class)genericType).isAssignableFrom(required);
        } else if (genericType instanceof WildcardType) {
            Type upperBound;
            Type lowerBound;
            WildcardType wildcardSetType = (WildcardType)genericType;
            typeOK = wildcardSetType.getLowerBounds().length > 0 ? (lowerBound = wildcardSetType.getLowerBounds()[0]) instanceof Class && required.isAssignableFrom((Class)lowerBound) : (wildcardSetType.getUpperBounds().length > 0 ? (upperBound = wildcardSetType.getUpperBounds()[0]) instanceof Class && ((Class)upperBound).isAssignableFrom(required) : true);
        } else if (required.isArray() && genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            typeOK = JerseyUtils.testType(required.getComponentType(), arrayType.getGenericComponentType());
        } else {
            typeOK = false;
        }
        return typeOK;
    }

    public static Map<String, String> parseForm(InputStream entityStream, String charset) throws IOException {
        String data;
        if (charset == null || charset.isEmpty()) {
            charset = "UTF-8";
        }
        try {
            data = IOUtils.toString((InputStream)entityStream, (String)charset);
        }
        catch (UnsupportedCharsetException e) {
            throw new IOException(e.getMessage(), e);
        }
        HashMap<String, String> form = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(data, "&");
        try {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int index = token.indexOf(61);
                if (index < 0) {
                    form.put(URLDecoder.decode(token, charset), null);
                    continue;
                }
                if (index <= 0) continue;
                form.put(URLDecoder.decode(token.substring(0, index), charset), URLDecoder.decode(token.substring(index + 1), charset));
            }
        }
        catch (UnsupportedCharsetException e) {
            throw new IOException(e.getMessage(), e);
        }
        return form;
    }
}

