/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.model.sesame;

import org.apache.commons.collections.Transformer;
import org.apache.stanbol.entityhub.model.sesame.RdfBNode;
import org.apache.stanbol.entityhub.model.sesame.RdfReference;
import org.apache.stanbol.entityhub.model.sesame.RdfText;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;

public class ModelUtils {
    protected static Transformer STRING_LITERAL_TO_TEXT_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            if (input instanceof Literal && XMLSchema.STRING.equals((Object)((Literal)input).getDatatype())) {
                return new RdfText((Literal)input);
            }
            return input;
        }
    };
    public static Transformer VALUE_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            if (input instanceof Value) {
                Value sesameValue = (Value)input;
                if (sesameValue instanceof URI) {
                    return new RdfReference((URI)sesameValue);
                }
                if (sesameValue instanceof Literal) {
                    Literal literal = (Literal)sesameValue;
                    if (literal.getDatatype() == null) {
                        return new RdfText(literal);
                    }
                    return ModelUtils.transformTypedLiteral(literal);
                }
                return new RdfBNode((BNode)sesameValue);
            }
            return input;
        }
    };
    public static Transformer VALUR_TO_STRING_TRANSFORMER = new Transformer(){

        public String transform(Object input) {
            return ((Value)input).stringValue();
        }
    };

    private static Object transformTypedLiteral(Literal literal) {
        URI dataType = literal.getDatatype();
        if (XMLSchema.INT.equals((Object)dataType)) {
            return literal.intValue();
        }
        if (XMLSchema.LONG.equals((Object)dataType)) {
            return literal.longValue();
        }
        if (XMLSchema.FLOAT.equals((Object)dataType)) {
            return Float.valueOf(literal.floatValue());
        }
        if (XMLSchema.DOUBLE.equals((Object)dataType)) {
            return literal.doubleValue();
        }
        if (XMLSchema.BOOLEAN.equals((Object)dataType)) {
            return literal.booleanValue();
        }
        if (XMLSchema.INTEGER.equals((Object)dataType)) {
            return literal.integerValue();
        }
        if (XMLSchema.DECIMAL.equals((Object)dataType)) {
            return literal.decimalValue();
        }
        if (XMLSchema.STRING.equals((Object)dataType)) {
            return literal.stringValue();
        }
        if (XMLDatatypeUtil.isCalendarDatatype((URI)dataType)) {
            return literal.calendarValue().toGregorianCalendar().getTime();
        }
        if (XMLSchema.BYTE.equals((Object)dataType)) {
            return literal.byteValue();
        }
        if (XMLSchema.SHORT.equals((Object)dataType)) {
            return literal.shortValue();
        }
        if (XMLSchema.NON_NEGATIVE_INTEGER.equals((Object)dataType) || XMLSchema.NON_POSITIVE_INTEGER.equals((Object)dataType) || XMLSchema.NEGATIVE_INTEGER.equals((Object)dataType) || XMLSchema.POSITIVE_INTEGER.equals((Object)dataType)) {
            return literal.longValue();
        }
        if (XMLSchema.GDAY.equals((Object)dataType) || XMLSchema.GMONTH.equals((Object)dataType) || XMLSchema.GMONTHDAY.equals((Object)dataType) || XMLSchema.GYEAR.equals((Object)dataType) || XMLSchema.GYEARMONTH.equals((Object)dataType)) {
            return literal.calendarValue().toGregorianCalendar().getTime();
        }
        if (XMLSchema.UNSIGNED_BYTE.equals((Object)dataType)) {
            return literal.shortValue();
        }
        if (XMLSchema.UNSIGNED_SHORT.equals((Object)dataType)) {
            return literal.intValue();
        }
        if (XMLSchema.UNSIGNED_INT.equals((Object)dataType)) {
            return literal.longValue();
        }
        return literal.stringValue();
    }
}

