/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.util;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.stanbol.entityhub.servicesapi.defaults.NamespaceEnum;
import org.apache.stanbol.entityhub.servicesapi.model.Reference;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.model.ValueFactory;
import org.apache.stanbol.entityhub.servicesapi.model.rdf.RdfResourceEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelUtils {
    private static final Logger log = LoggerFactory.getLogger(ModelUtils.class);
    private static Random rng = new Random();
    public static final Comparator<Representation> RESULT_SCORE_COMPARATOR = new Comparator<Representation>(){

        @Override
        public int compare(Representation r1, Representation r2) {
            Object score1 = r1.getFirst(RdfResourceEnum.resultScore.getUri());
            Object score2 = r2.getFirst(RdfResourceEnum.resultScore.getUri());
            return score1 == null && score2 == null ? 0 : (score2 == null ? -1 : (score1 == null ? 1 : ((Comparable)score2).compareTo((Comparable)score1)));
        }
    };

    private ModelUtils() {
    }

    public static UUID randomUUID() {
        return new UUID(rng.nextLong(), rng.nextLong());
    }

    public static void setSeed(long seed) {
        rng.setSeed(seed);
    }

    public static void checkValues(ValueFactory valueFactory, Object value, Collection<Object> results) {
        if (value == null) {
            return;
        }
        if (value instanceof Iterable) {
            for (Object current : (Iterable)value) {
                ModelUtils.checkValues(valueFactory, current, results);
            }
        } else if (value instanceof Iterator) {
            while (((Iterator)value).hasNext()) {
                ModelUtils.checkValues(valueFactory, ((Iterator)value).next(), results);
            }
        } else if (value instanceof Enumeration) {
            while (((Enumeration)value).hasMoreElements()) {
                ModelUtils.checkValues(valueFactory, ((Enumeration)value).nextElement(), results);
            }
        } else if (value instanceof URI || value instanceof URL) {
            results.add(valueFactory.createReference(value.toString()));
        } else if (value instanceof String[]) {
            if (((String[])value).length > 0 && ((String[])value)[0] != null) {
                results.add(valueFactory.createText(((String[])value)[0], ((String[])value).length > 1 ? ((String[])value)[1] : null));
            } else {
                log.warn("String[] " + Arrays.toString((String[])value) + " is not a valied natural language array! -> ignore value");
            }
        } else {
            results.add(value);
        }
    }

    public static String getRepresentationInfo(Representation rep) {
        StringBuilder info = new StringBuilder();
        info.append("Representation id=");
        info.append(rep.getId());
        info.append(" | impl=");
        info.append(rep.getClass());
        info.append('\n');
        Iterator<String> fields = rep.getFieldNames();
        while (fields.hasNext()) {
            String field = fields.next();
            info.append(" o ");
            info.append(field);
            info.append(':');
            ArrayList<Object> values = new ArrayList<Object>();
            Iterator<Object> valueIt = rep.get(field);
            while (valueIt.hasNext()) {
                values.add(valueIt.next());
            }
            info.append(values);
            info.append('\n');
        }
        return info.toString();
    }

    public static <T> Collection<T> asCollection(Iterator<? extends T> it) {
        return ModelUtils.addToCollection(it, new ArrayList());
    }

    public static <T> Collection<T> addToCollection(Iterator<? extends T> it, Collection<T> c) {
        if (it == null) {
            return c;
        }
        if (c == null) {
            throw new IllegalArgumentException("The parsed Collection MUST NOT be NULL!");
        }
        while (it.hasNext()) {
            c.add(it.next());
        }
        return c;
    }

    public static <T> Set<T> asSet(Iterator<? extends T> it) {
        if (it == null) {
            throw new IllegalArgumentException("The parsed Iterator MUST NOT be NULL!");
        }
        return ModelUtils.addToSet(it, new HashSet());
    }

    public static <T> Set<T> addToSet(Iterator<? extends T> it, Set<T> set) {
        if (it == null) {
            return set;
        }
        if (set == null) {
            throw new IllegalArgumentException("The parsed Set MUST NOT be NULL!");
        }
        while (it.hasNext()) {
            set.add(it.next());
        }
        return set;
    }

    public static String[] getNamespaceLocalName(String uri) {
        String[] parts = new String[2];
        if (uri.startsWith("urn:")) {
            if (uri.lastIndexOf(58) > 3) {
                parts[1] = uri.substring(uri.lastIndexOf(58) + 1);
                parts[0] = uri.substring(0, uri.lastIndexOf(58) + 1);
            } else {
                parts[1] = uri;
                parts[0] = null;
            }
        } else if (uri.lastIndexOf(35) >= 0) {
            parts[1] = uri.substring(uri.lastIndexOf(35) + 1);
            parts[0] = uri.substring(0, uri.lastIndexOf(35) + 1);
        } else if (uri.lastIndexOf(47) >= 0) {
            parts[1] = uri.substring(uri.lastIndexOf(47) + 1);
            parts[0] = uri.substring(0, uri.lastIndexOf(47) + 1);
        } else {
            parts[0] = null;
            parts[1] = uri;
        }
        return parts;
    }

    public static QName getQName(String uri) {
        String[] nsln = ModelUtils.getNamespaceLocalName(uri);
        if (nsln[0] != null) {
            NamespaceEnum entry = NamespaceEnum.forNamespace(nsln[0]);
            if (entry != null) {
                return new QName(nsln[0], nsln[1], entry.getPrefix());
            }
            return new QName(nsln[0], nsln[1]);
        }
        return new QName(nsln[1]);
    }

    public static String getAboutRepresentation(Representation metadata) throws IllegalStateException {
        if (metadata == null) {
            return null;
        }
        Iterator<Reference> refs = metadata.getReferences(RdfResourceEnum.aboutRepresentation.getUri());
        if (refs.hasNext()) {
            Reference about = refs.next();
            if (refs.hasNext()) {
                log.warn("The parsed Representation {} claims to be the metadata ofmultiple Entities (entities: {})", (Object)metadata.getId(), ModelUtils.asCollection(metadata.getReferences(RdfResourceEnum.aboutRepresentation.getUri())));
            }
            return about.getReference();
        }
        return null;
    }
}

