/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.util;

import java.util.regex.Pattern;

public final class PatternUtils {
    public static final Pattern PREFIX_REGEX_PATTERN = Pattern.compile("[\\?\\*]");

    private PatternUtils() {
    }

    public static String wildcardToRegex(String wildcard, boolean strict) {
        StringBuilder regex = new StringBuilder();
        if (strict) {
            regex.append('^');
        }
        block5: for (char c : wildcard.toCharArray()) {
            switch (c) {
                case '*': {
                    regex.append(".*");
                    continue block5;
                }
                case '?': {
                    regex.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    regex.append("\\");
                }
                default: {
                    regex.append(c);
                }
            }
        }
        if (strict) {
            regex.append('$');
        }
        return regex.toString();
    }

    public static String value2Regex(String value) {
        return '^' + PatternUtils.escapeRegex(value) + '$';
    }

    public static String escapeRegex(String wildcard) {
        StringBuilder escaped = new StringBuilder();
        for (char c : wildcard.toCharArray()) {
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    escaped.append("\\");
                }
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    public static boolean usesWildCard(String value) {
        return value == null ? false : PREFIX_REGEX_PATTERN.matcher(value).find();
    }
}

