/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.mapping;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;
import org.apache.stanbol.entityhub.servicesapi.util.PatternUtils;

public class FieldMapping {
    public static final char COMMENT_CHAR = '#';
    private final String pattern;
    private final Pattern regex;
    private final boolean usesWildcard;
    private Set<String> mappings;
    private Constraint filter;
    private final boolean inverse;
    private final boolean global;

    public final boolean ignoreField() {
        return this.inverse && this.filter == null;
    }

    public FieldMapping(Constraint globalFilter) throws IllegalArgumentException {
        this(null, false, globalFilter, new String[0]);
    }

    public FieldMapping(String fieldPattern, String ... mappedTo) throws IllegalArgumentException {
        this(fieldPattern, (Constraint)null, mappedTo);
    }

    public FieldMapping(String fieldPattern, boolean ignoreField, String ... mappedTo) throws IllegalArgumentException {
        this(fieldPattern, ignoreField, (Constraint)null, mappedTo);
    }

    public FieldMapping(String fieldPattern, Constraint filter, String ... mappedTo) throws IllegalArgumentException {
        this(fieldPattern, false, filter, mappedTo);
    }

    private FieldMapping(String fieldPattern, boolean ignore, Constraint filter, String ... mappedTo) {
        if (fieldPattern == null || fieldPattern.length() < 1) {
            if (filter == null) {
                throw new IllegalArgumentException("The Filter MUST NOT be NULL for the global Fieldmapping!");
            }
            this.global = true;
            fieldPattern = "*";
        } else {
            this.global = false;
        }
        this.pattern = fieldPattern;
        this.inverse = ignore;
        if (PatternUtils.usesWildCard(fieldPattern)) {
            this.regex = Pattern.compile(PatternUtils.wildcardToRegex(fieldPattern, true));
            this.usesWildcard = true;
        } else {
            this.regex = null;
            this.usesWildcard = false;
        }
        this.filter = filter;
        if (this.global) {
            mappedTo = new String[]{};
        } else if (this.usesWildcard) {
            mappedTo = new String[]{null};
        } else if (mappedTo == null || mappedTo.length < 1) {
            mappedTo = new String[]{null};
        }
        this.mappings = new HashSet<String>(Arrays.asList(mappedTo));
    }

    public final boolean isGlobal() {
        return this.global;
    }

    public final Pattern getRegexPattern() {
        return this.regex;
    }

    public final boolean usesWildcard() {
        return this.usesWildcard;
    }

    public String getFieldPattern() {
        return this.pattern;
    }

    public Set<String> getMappings() {
        return this.mappings;
    }

    public Constraint getFilter() {
        return this.filter;
    }

    public void setFilter(Constraint constraint) {
        this.filter = constraint;
    }

    public void removeFilter() {
        this.setFilter(null);
    }

    public void addMapping(String mapping) {
        this.mappings.add(mapping);
    }

    public void removeMapping(String mapping) {
        if (this.mappings.remove(mapping) && this.mappings.isEmpty()) {
            this.mappings.add(null);
        }
    }

    public String toString() {
        return this.inverse ? "!" : "" + this.pattern + (this.filter != null ? " | " + this.filter : "") + " > " + this.mappings;
    }

    public int hashCode() {
        return this.pattern.hashCode() + ((Object)this.mappings).hashCode() + (this.inverse ? 1 : 0) + (this.filter != null ? this.filter.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        return obj instanceof FieldMapping && ((FieldMapping)obj).pattern.equals(this.pattern) && ((FieldMapping)obj).inverse == this.inverse && ((Object)((FieldMapping)obj).mappings).equals(this.mappings) && (((FieldMapping)obj).filter == null && this.filter == null || ((FieldMapping)obj).filter != null && ((FieldMapping)obj).filter.equals(this.filter));
    }
}

