/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.defaults;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.stanbol.entityhub.servicesapi.defaults.NamespaceEnum;

public enum SpecialFieldEnum {
    fullText,
    references;

    private final String uri = NamespaceEnum.entityhubQuery.getNamespace() + this.name();
    private final String qname = NamespaceEnum.entityhubQuery.getPrefix() + this.name();
    private static final Map<String, SpecialFieldEnum> name2field;

    public String getUri() {
        return this.uri;
    }

    public String getQName() {
        return this.qname;
    }

    public NamespaceEnum getNamespace() {
        return NamespaceEnum.entityhubQuery;
    }

    public static final boolean isSpecialField(String name) {
        return SpecialFieldEnum.getSpecialField(name) != null;
    }

    public static SpecialFieldEnum getSpecialField(String name) {
        return name2field.get(name);
    }

    static {
        TreeMap<String, SpecialFieldEnum> map = new TreeMap<String, SpecialFieldEnum>();
        for (SpecialFieldEnum specialField : SpecialFieldEnum.values()) {
            map.put(specialField.getUri(), specialField);
            map.put(specialField.getUri(), specialField);
            map.put(specialField.name(), specialField);
        }
        name2field = Collections.unmodifiableMap(map);
    }
}

