/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.query;

public abstract class Constraint {
    private static Double ONE = 1.0;
    private Double boost = ONE;
    private final ConstraintType type;

    protected Constraint(ConstraintType type) {
        if (type == null) {
            throw new IllegalArgumentException("The ConstraintType MUST NOT be NULL");
        }
        this.type = type;
    }

    public final ConstraintType getType() {
        return this.type;
    }

    public final Double getBoost() {
        return this.boost;
    }

    public final void setBoost(Double boost) {
        if (boost == null) {
            this.boost = null;
        } else {
            if (boost <= 0.0) {
                throw new IllegalArgumentException("The parsed Boost '{}' MUST NOT be <= zero!");
            }
            this.boost = boost;
        }
    }

    public String toString() {
        return String.format("Constraint [type :: %s][class :: %s]", new Object[]{this.type, this.getClass().toString()});
    }

    public static enum ConstraintType {
        value,
        range,
        text,
        similarity;

    }
}

