/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.stanbol.entityhub.servicesapi.defaults.DataTypeEnum;
import org.apache.stanbol.entityhub.servicesapi.query.Constraint;

public class SimilarityConstraint
extends Constraint {
    protected final String context;
    protected final DataTypeEnum contextType;
    protected final List<String> additionalFields;
    private final Collection<String> languages;

    public SimilarityConstraint(String context) {
        this(context, DataTypeEnum.Text, null, null);
    }

    public SimilarityConstraint(String context, List<String> additionalFields) {
        this(context, DataTypeEnum.Text, null, null);
    }

    public SimilarityConstraint(Collection<String> context, Collection<String> languages) {
        this(SimilarityConstraint.getCollectionContext(context), DataTypeEnum.Text, languages, null);
    }

    public SimilarityConstraint(Collection<String> context, DataTypeEnum contextType) {
        this(SimilarityConstraint.getCollectionContext(context), contextType, null, null);
    }

    public SimilarityConstraint(Collection<String> context, Collection<String> languages, List<String> additionalFields) {
        this(SimilarityConstraint.getCollectionContext(context), DataTypeEnum.Text, languages, additionalFields);
    }

    public SimilarityConstraint(Collection<String> context, DataTypeEnum contextType, List<String> additionalFields) {
        this(SimilarityConstraint.getCollectionContext(context), contextType, null, additionalFields);
    }

    private SimilarityConstraint(String context, DataTypeEnum contextType, Collection<String> languages, List<String> additionalFields) {
        super(Constraint.ConstraintType.similarity);
        if (context == null) {
            throw new IllegalArgumentException("The parsed Context MUST NOT be NULL nor empty");
        }
        this.context = context;
        this.contextType = contextType;
        this.languages = languages;
        if (additionalFields == null || additionalFields.isEmpty()) {
            this.additionalFields = Collections.emptyList();
        } else {
            ArrayList<String> fields = new ArrayList<String>(additionalFields.size());
            for (String field : additionalFields) {
                if (field == null || field.isEmpty()) continue;
                fields.add(field);
            }
            this.additionalFields = Collections.unmodifiableList(fields);
        }
    }

    public List<String> getAdditionalFields() {
        return this.additionalFields;
    }

    public Collection<String> getLanguages() {
        return this.languages;
    }

    public String getContext() {
        return this.context;
    }

    public DataTypeEnum getContextType() {
        return this.contextType;
    }

    private static String getCollectionContext(Collection<String> context) {
        if (context == null || context.isEmpty()) {
            return null;
        }
        StringBuilder refContext = new StringBuilder();
        boolean first = true;
        for (String string : context) {
            if (!first) {
                refContext.append(' ');
            } else {
                first = false;
            }
            refContext.append(string);
        }
        return refContext.toString();
    }
}

