/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.stanbol.entityhub.servicesapi.EntityhubConfiguration;
import org.apache.stanbol.entityhub.servicesapi.EntityhubException;
import org.apache.stanbol.entityhub.servicesapi.mapping.FieldMapper;
import org.apache.stanbol.entityhub.servicesapi.model.Entity;
import org.apache.stanbol.entityhub.servicesapi.model.ManagedEntityState;
import org.apache.stanbol.entityhub.servicesapi.model.Representation;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQuery;
import org.apache.stanbol.entityhub.servicesapi.query.FieldQueryFactory;
import org.apache.stanbol.entityhub.servicesapi.query.QueryResultList;
import org.apache.stanbol.entityhub.servicesapi.yard.Yard;

public interface Entityhub {
    public static final String DEFAUTL_ENTITYHUB_PREFIX = "urn:org.apache.stanbol:entityhub";
    public static final Set<String> ENTITYHUB_IDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("local", "entityhub")));

    public Yard getYard();

    public Entity lookupLocalEntity(String var1) throws EntityhubException;

    public Entity lookupLocalEntity(String var1, boolean var2) throws IllegalArgumentException, EntityhubException;

    public Entity getEntity(String var1) throws IllegalArgumentException, EntityhubException;

    public Entity importEntity(String var1) throws IllegalStateException, IllegalArgumentException, EntityhubException;

    public Entity getMappingById(String var1) throws EntityhubException, IllegalArgumentException;

    public Entity getMappingBySource(String var1) throws EntityhubException;

    public FieldQueryFactory getQueryFactory();

    public FieldMapper getFieldMappings();

    public Collection<Entity> getMappingsByTarget(String var1) throws EntityhubException;

    public QueryResultList<String> findEntityReferences(FieldQuery var1) throws EntityhubException;

    public QueryResultList<Representation> find(FieldQuery var1) throws EntityhubException;

    public QueryResultList<Entity> findEntities(FieldQuery var1) throws EntityhubException;

    public boolean isRepresentation(String var1) throws EntityhubException, IllegalArgumentException;

    public Entity store(Representation var1) throws EntityhubException, IllegalArgumentException;

    public Entity delete(String var1) throws EntityhubException, IllegalArgumentException;

    public Entity setState(String var1, ManagedEntityState var2) throws EntityhubException, IllegalArgumentException;

    public EntityhubConfiguration getConfig();
}

