/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.entityhub.servicesapi.query;

import org.apache.stanbol.entityhub.servicesapi.query.Constraint;

public class RangeConstraint
extends Constraint {
    private final Object lowerBound;
    private final Object upperBound;
    private final boolean inclusive;

    public RangeConstraint(Object lowerBound, Object upperBound, boolean inclusive) {
        super(Constraint.ConstraintType.range);
        if (lowerBound == null && upperBound == null) {
            throw new IllegalArgumentException(" At least one of \"lower bound\" and \"upper bound\" MUST BE defined");
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.inclusive = inclusive;
    }

    public Object getLowerBound() {
        return this.lowerBound;
    }

    public Object getUpperBound() {
        return this.upperBound;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public String toString() {
        return String.format("RangeConstraint[lower=%s|upper=%s|%sclusive]", this.lowerBound != null ? this.lowerBound : "*", this.upperBound != null ? this.upperBound : "*", this.inclusive ? "in" : "ex");
    }
}

