/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.stanbol.reasoners.owlapi.OWLApiReasoningService;
import org.apache.stanbol.reasoners.servicesapi.InconsistentInputException;
import org.apache.stanbol.reasoners.servicesapi.ReasoningService;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceException;
import org.apache.stanbol.reasoners.servicesapi.UnsupportedTaskException;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;
import org.semanticweb.owlapi.util.InferredClassAssertionAxiomGenerator;
import org.semanticweb.owlapi.util.InferredDataPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredDisjointClassesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentDataPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredInverseObjectPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredObjectPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredOntologyGenerator;
import org.semanticweb.owlapi.util.InferredPropertyAssertionGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubDataPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubObjectPropertyAxiomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLApiReasoningService
implements OWLApiReasoningService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected OWLOntologyManager createOWLOntologyManager() {
        this.log.info("createOWLOntologyManager()");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        this.log.info("manager: {}", (Object)manager);
        manager.setSilentMissingImportsHandling(true);
        manager.addMissingImportListener(new MissingImportListener(){

            public void importMissing(MissingImportEvent arg0) {
                AbstractOWLApiReasoningService.this.log.warn("Missing import {} ", (Object)arg0.getImportedOntologyURI());
            }
        });
        manager.addOntologyLoaderListener(new OWLOntologyLoaderListener(){

            public void finishedLoadingOntology(OWLOntologyLoaderListener.LoadingFinishedEvent arg0) {
                AbstractOWLApiReasoningService.this.log.info("Finished loading {} (imported: {})", (Object)arg0.getOntologyID(), (Object)arg0.isImported());
            }

            public void startedLoadingOntology(OWLOntologyLoaderListener.LoadingStartedEvent arg0) {
                AbstractOWLApiReasoningService.this.log.info("Started loading {} (imported: {}) ...", (Object)arg0.getOntologyID(), (Object)arg0.isImported());
                AbstractOWLApiReasoningService.this.log.info(" ... from {}", (Object)arg0.getDocumentIRI().toString());
            }
        });
        return manager;
    }

    protected abstract OWLReasoner getReasoner(OWLOntology var1);

    @Override
    public Set<OWLAxiom> run(OWLOntology input, List<InferredAxiomGenerator<? extends OWLAxiom>> generators) throws ReasoningServiceException, InconsistentInputException {
        this.log.debug("run(OWLOntology input, List<InferredAxiomGenerator<? extends OWLAxiom>> generators)");
        try {
            OWLOntologyManager manager = this.createOWLOntologyManager();
            OWLReasoner reasoner = this.getReasoner(input);
            this.log.info("Running {} reasoner on {} ", reasoner.getClass(), (Object)input.getOntologyID());
            InferredOntologyGenerator inferred = new InferredOntologyGenerator(reasoner, generators);
            HashSet<OWLAxiom> axioms = new HashSet();
            try {
                OWLOntology output = manager.createOntology();
                this.log.debug("Created output ontology: {}", (Object)output);
                try {
                    inferred.fillOntology(manager, output);
                }
                catch (InconsistentOntologyException i) {
                    throw i;
                }
                catch (Throwable t) {
                    this.log.error("Some problem occurred:\n {}", (Object[])t.getStackTrace());
                    throw new ReasoningServiceException();
                }
                this.log.debug("Filled ontology: {}", (Object)output);
                this.log.debug("Temporary ID is {}", (Object)output.getOntologyID());
                axioms = manager.getOntology(output.getOntologyID()).getAxioms();
                manager.removeOntology(output);
            }
            catch (OWLOntologyCreationException e) {
                this.log.error("An exception have been thrown when instantiating the ontology");
                throw new ReasoningServiceException();
            }
            return axioms;
        }
        catch (InconsistentOntologyException inconsistent) {
            throw new InconsistentInputException();
        }
        catch (Exception exception) {
            this.log.error("An exception have been thrown while executing method run()", (Throwable)exception);
            throw new ReasoningServiceException();
        }
    }

    @Override
    public Set<OWLAxiom> run(OWLOntology ontology, List<SWRLRule> rules, List<InferredAxiomGenerator<? extends OWLAxiom>> generators) throws ReasoningServiceException, InconsistentInputException {
        this.log.debug("Called method run(OWLOntology,List<SWRLRule>,List)");
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        this.log.debug("Adding SWRL rules to the input ontology.");
        HashSet<SWRLRule> ruleSet = new HashSet<SWRLRule>();
        ruleSet.addAll(rules);
        manager.addAxioms(ontology, ruleSet);
        if (this.log.isDebugEnabled()) {
            for (OWLAxiom a : ontology.getAxioms()) {
                this.log.debug("Axiom {}", (Object)a);
            }
        }
        this.log.debug("Calling the run method.");
        return this.run(ontology, generators);
    }

    public Set<OWLAxiom> runTask(String taskID, OWLOntology data) throws UnsupportedTaskException, ReasoningServiceException, InconsistentInputException {
        if (taskID.equals("classify")) {
            return this.classify(data);
        }
        if (taskID.equals("enrich")) {
            return this.enrich(data);
        }
        throw new UnsupportedTaskException();
    }

    public Set<OWLAxiom> runTask(String taskID, OWLOntology data, List<SWRLRule> rules, boolean filtered, Map<String, List<String>> parameters) throws UnsupportedTaskException, ReasoningServiceException, InconsistentInputException {
        this.log.info("Called task {} with data {}", (Object)taskID, (Object)data);
        if (taskID.equals("classify")) {
            if (rules != null) {
                return this.classify(data, rules);
            }
            this.log.warn("No rules attached");
            return this.classify(data);
        }
        if (taskID.equals("enrich")) {
            if (rules != null) {
                return this.enrich(data, rules, filtered);
            }
            return this.enrich(data, filtered);
        }
        throw new UnsupportedTaskException();
    }

    protected List<InferredAxiomGenerator<? extends OWLAxiom>> getClassifyAxiomGenerators() {
        ArrayList<InferredAxiomGenerator<? extends OWLAxiom>> gens = new ArrayList<InferredAxiomGenerator<? extends OWLAxiom>>();
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredClassAssertionAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubClassAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentClassAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredDisjointClassesAxiomGenerator());
        return gens;
    }

    protected List<InferredAxiomGenerator<? extends OWLAxiom>> getEnrichAxiomGenerators() {
        ArrayList<InferredAxiomGenerator<? extends OWLAxiom>> gens = new ArrayList<InferredAxiomGenerator<? extends OWLAxiom>>();
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredClassAssertionAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubClassAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentClassAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredDisjointClassesAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredDataPropertyCharacteristicAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentDataPropertiesAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubDataPropertyAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredEquivalentObjectPropertyAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredInverseObjectPropertiesAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredObjectPropertyCharacteristicAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredSubObjectPropertyAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredClassAssertionAxiomGenerator());
        gens.add((InferredAxiomGenerator<? extends OWLAxiom>)new InferredPropertyAssertionGenerator());
        return gens;
    }

    protected Set<OWLAxiom> classify(OWLOntology ontology) throws ReasoningServiceException, InconsistentInputException {
        this.log.info("classify(OWLOntology ontology)");
        return this.run(ontology, this.getClassifyAxiomGenerators());
    }

    protected Set<OWLAxiom> classify(OWLOntology ontology, List<SWRLRule> rules) throws ReasoningServiceException, InconsistentInputException {
        this.log.debug("Calling classify(OWLOntology ontology, List<SWRLRule> rules) ");
        return this.run(ontology, rules, this.getClassifyAxiomGenerators());
    }

    protected Set<OWLAxiom> enrich(OWLOntology ontology) throws ReasoningServiceException, InconsistentInputException {
        return this.run(ontology, this.getEnrichAxiomGenerators());
    }

    protected Set<OWLAxiom> enrich(OWLOntology ontology, boolean filtered) throws ReasoningServiceException, InconsistentInputException {
        this.log.debug("Calling enrich(OWLOntology ontology, filtered) ");
        if (filtered) {
            return this.run(ontology, this.getEnrichAxiomGenerators());
        }
        Set output = ontology.getAxioms();
        output.addAll(this.run(ontology, this.getEnrichAxiomGenerators()));
        return output;
    }

    protected Set<OWLAxiom> enrich(OWLOntology ontology, List<SWRLRule> rules) throws ReasoningServiceException, InconsistentInputException {
        this.log.debug("Calling enrich(OWLOntology ontology, List<SWRLRule> rules) ");
        return this.run(ontology, rules, this.getEnrichAxiomGenerators());
    }

    protected Set<OWLAxiom> enrich(OWLOntology ontology, List<SWRLRule> rules, boolean filtered) throws ReasoningServiceException, InconsistentInputException {
        this.log.debug("Calling enrich(OWLOntology ontology, List<SWRLRule> rules) ");
        if (filtered) {
            return this.run(ontology, rules, this.getEnrichAxiomGenerators());
        }
        Set output = ontology.getAxioms();
        output.addAll(this.run(ontology, rules, this.getEnrichAxiomGenerators()));
        return output;
    }

    public boolean isConsistent(OWLOntology ontology) throws ReasoningServiceException {
        try {
            return this.getReasoner(ontology).isConsistent();
        }
        catch (Exception e) {
            this.log.error("An error have been thrown while attempting to check consistency. Message was: {}", (Object)e.getLocalizedMessage());
            throw new ReasoningServiceException();
        }
    }

    public boolean isConsistent(OWLOntology ontology, List<SWRLRule> rules) throws ReasoningServiceException {
        this.log.debug("Create a input ontology to merge rules in.");
        try {
            OWLOntologyManager manager = this.createOWLOntologyManager();
            OWLOntology input = manager.createOntology();
            HashSet<SWRLRule> ruleSet = new HashSet<SWRLRule>();
            ruleSet.addAll(rules);
            manager.addAxioms(input, ruleSet);
            input = manager.getOntology(input.getOntologyID());
            this.log.debug("Created ontology: {}", (Object)input);
            return this.getReasoner(ontology).isConsistent();
        }
        catch (OWLOntologyCreationException e) {
            this.log.error("An error have been thrown while attempting to create ontology. Message was: {}", (Object)e.getLocalizedMessage());
            throw new ReasoningServiceException();
        }
    }

    public List<String> getSupportedTasks() {
        return ReasoningService.Tasks.DEFAULT_TASKS;
    }

    public boolean supportsTask(String taskID) {
        return this.getSupportedTasks().contains(taskID);
    }

    public Class<OWLOntology> getModelType() {
        return OWLOntology.class;
    }

    public Class<SWRLRule> getRuleType() {
        return SWRLRule.class;
    }

    public Class<OWLAxiom> getStatementType() {
        return OWLAxiom.class;
    }
}

