/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.input.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputManager;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInputManager
implements ReasoningServiceInputManager {
    private Logger logger = LoggerFactory.getLogger(SimpleInputManager.class);
    private List<ReasoningServiceInputProvider> providers = new ArrayList<ReasoningServiceInputProvider>();

    public void addInputProvider(ReasoningServiceInputProvider provider) {
        this.providers.add(provider);
    }

    public void removeInputProvider(ReasoningServiceInputProvider provider) {
        this.providers.remove(provider);
    }

    public <T> Iterator<T> getInputData(final Class<T> type) {
        final List<ReasoningServiceInputProvider> fProviders = this.getProviders();
        return new Iterator<T>(){
            private Iterator<T> current = null;
            private Iterator<ReasoningServiceInputProvider> pIterator = fProviders.iterator();

            private boolean nextProvider() {
                if (this.pIterator.hasNext()) {
                    ReasoningServiceInputProvider provider = this.pIterator.next();
                    if (provider.adaptTo(type)) {
                        try {
                            this.current = provider.getInput(type);
                        }
                        catch (IOException e) {
                            SimpleInputManager.this.logger.error("Cannot get input from provider", (Throwable)e);
                            return this.nextProvider();
                        }
                        if (!this.current.hasNext()) {
                            return this.nextProvider();
                        }
                        return true;
                    }
                    return this.nextProvider();
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    if (this.nextProvider()) {
                        return this.current.hasNext();
                    }
                    return false;
                }
                if (this.current.hasNext()) {
                    return true;
                }
                return this.nextProvider();
            }

            @Override
            public T next() {
                if (this.current == null) {
                    if (this.nextProvider()) {
                        return this.current.next();
                    }
                    throw new IllegalStateException("Iterator has no more items");
                }
                if (this.current.hasNext()) {
                    return this.current.next();
                }
                if (this.nextProvider()) {
                    return this.current.next();
                }
                throw new IllegalStateException("Iterator has no more items");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List<ReasoningServiceInputProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }
}

