/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.input.provider.impl;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.stanbol.commons.owl.transformation.JenaToOwlConvert;
import org.apache.stanbol.ontologymanager.ontonet.api.ONManager;
import org.apache.stanbol.ontologymanager.servicesapi.scope.Scope;
import org.apache.stanbol.ontologymanager.servicesapi.session.Session;
import org.apache.stanbol.ontologymanager.servicesapi.session.SessionManager;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.UrlInputProvider;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.util.OWLOntologyMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyManagerInputProvider
implements ReasoningServiceInputProvider {
    private final Logger log = LoggerFactory.getLogger(UrlInputProvider.class);
    private String scopeId;
    private String sessionId;
    private ONManager onManager;
    private SessionManager sessionManager;

    public OntologyManagerInputProvider(ONManager onManager, String scopeId) {
        this(onManager, null, scopeId, null);
    }

    public OntologyManagerInputProvider(ONManager onManager, SessionManager sessionManager, String scopeId, String sessionId) {
        this.onManager = onManager;
        this.scopeId = scopeId;
        this.sessionManager = sessionManager;
        this.sessionId = sessionId;
    }

    public <T> Iterator<T> getInput(Class<T> type) throws IOException {
        OWLOntology o = this.getFromOntoMgr();
        if (type.isAssignableFrom(OWLAxiom.class)) {
            final Iterator iterator = o.getAxioms().iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public T next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove statements from the iterator");
                }
            };
        }
        if (type.isAssignableFrom(Statement.class)) {
            OntModel input = new JenaToOwlConvert().ModelOwlToJenaConvert(o, "RDF/XML");
            final StmtIterator iterator = input.listStatements();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public T next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove statements from the iterator");
                }
            };
        }
        throw new UnsupportedOperationException("This provider does not adapt to the given type");
    }

    public <T> boolean adaptTo(Class<T> type) {
        return type.isAssignableFrom(OWLAxiom.class) || type.isAssignableFrom(Statement.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OWLOntology getFromOntoMgr() throws IOException {
        try {
            Scope scope = null;
            ONManager oNManager = this.onManager;
            synchronized (oNManager) {
                scope = this.onManager.getScope(this.scopeId);
            }
            if (scope == null) {
                this.log.error("Scope {} cannot be retrieved", (Object)this.scopeId);
                throw new IOException("Scope " + this.scopeId + " cannot be retrieved");
            }
            Session session = null;
            if (this.sessionManager != null) {
                SessionManager sessionManager = this.sessionManager;
                synchronized (sessionManager) {
                    session = this.sessionManager.getSession(this.sessionId);
                }
            }
            if (session == null) {
                this.log.warn("Session {} cannot be retrieved. Ignoring.", (Object)this.sessionId);
            }
            final HashSet<Object> set = new HashSet<Object>();
            set.add(scope.export(OWLOntology.class, true));
            if (session != null) {
                set.add(session.export(OWLOntology.class, true));
            }
            if (set.size() == 1) {
                return (OWLOntology)set.iterator().next();
            }
            OWLOntologyMerger merger = new OWLOntologyMerger(new OWLOntologySetProvider(){

                public Set<OWLOntology> getOntologies() {
                    return set;
                }
            });
            return merger.createMergedOntology(this.createOWLOntologyManager(), IRI.create((String)("reasoners:input-" + System.currentTimeMillis())));
        }
        catch (OWLOntologyCreationException e) {
            String message = "The network for scope/session cannot be retrieved";
            this.log.error(message + ":", (Throwable)e);
            throw new IllegalArgumentException(message);
        }
    }

    private OWLOntologyManager createOWLOntologyManager() {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        manager.setSilentMissingImportsHandling(true);
        manager.addMissingImportListener(new MissingImportListener(){

            public void importMissing(MissingImportEvent arg0) {
                OntologyManagerInputProvider.this.log.warn("Missing import {} ", (Object)arg0.getImportedOntologyURI());
            }
        });
        manager.addOntologyLoaderListener(new OWLOntologyLoaderListener(){

            public void finishedLoadingOntology(OWLOntologyLoaderListener.LoadingFinishedEvent arg0) {
                OntologyManagerInputProvider.this.log.info("Finished loading {} (imported: {})", (Object)arg0.getOntologyID(), (Object)arg0.isImported());
            }

            public void startedLoadingOntology(OWLOntologyLoaderListener.LoadingStartedEvent arg0) {
                OntologyManagerInputProvider.this.log.info("Started loading {} (imported: {}) ...", (Object)arg0.getOntologyID(), (Object)arg0.isImported());
                OntologyManagerInputProvider.this.log.info(" ... from {}", (Object)arg0.getDocumentIRI().toString());
            }
        });
        return manager;
    }
}

