/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.resources;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.clerezza.rdf.core.access.TcManager;
import org.apache.stanbol.commons.jobs.api.Job;
import org.apache.stanbol.commons.jobs.api.JobManager;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.ContextHelper;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.commons.web.base.resource.BaseStanbolResource;
import org.apache.stanbol.ontologymanager.ontonet.api.ONManager;
import org.apache.stanbol.ontologymanager.servicesapi.session.SessionManager;
import org.apache.stanbol.reasoners.jena.JenaReasoningService;
import org.apache.stanbol.reasoners.owlapi.OWLApiReasoningService;
import org.apache.stanbol.reasoners.servicesapi.ReasoningService;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServiceInputManager;
import org.apache.stanbol.reasoners.servicesapi.ReasoningServicesManager;
import org.apache.stanbol.reasoners.servicesapi.UnboundReasoningServiceException;
import org.apache.stanbol.reasoners.servicesapi.annotations.Documentation;
import org.apache.stanbol.reasoners.web.input.impl.SimpleInputManager;
import org.apache.stanbol.reasoners.web.input.provider.impl.FileInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.OntologyManagerInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.RecipeInputProvider;
import org.apache.stanbol.reasoners.web.input.provider.impl.UrlInputProvider;
import org.apache.stanbol.reasoners.web.utils.ReasoningServiceExecutor;
import org.apache.stanbol.reasoners.web.utils.ReasoningServiceResult;
import org.apache.stanbol.reasoners.web.utils.ResponseTaskBuilder;
import org.apache.stanbol.rules.base.api.RuleAdapterManager;
import org.apache.stanbol.rules.base.api.RuleStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/reasoners/{service}/{task: [^/]+}{job: (/job)?}")
public class ReasoningServiceTaskResource
extends BaseStanbolResource {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServletContext context;
    private ReasoningService<?, ?, ?> service;
    private String taskID;
    private HttpContext httpContext;
    private Map<String, List<String>> parameters;
    private TcManager tcManager;
    private HttpHeaders headers;
    private ONManager onm;
    private SessionManager sessionManager;
    private RuleStore ruleStore;
    private RuleAdapterManager adapterManager;
    private boolean job = false;
    private String jobLocation = "";

    public ReasoningServiceTaskResource(@PathParam(value="service") String serviceID, @PathParam(value="task") String taskID, @PathParam(value="job") String job, @Context ServletContext servletContext, @Context HttpHeaders headers, @Context HttpContext httpContext) {
        this.log.debug("Called service {} to perform task {}", (Object)serviceID, (Object)taskID);
        this.context = servletContext;
        this.httpContext = httpContext;
        this.headers = headers;
        this.parameters = this.prepareParameters();
        this.tcManager = (TcManager)ContextHelper.getServiceFromContext(TcManager.class, (ServletContext)servletContext);
        this.onm = (ONManager)ContextHelper.getServiceFromContext(ONManager.class, (ServletContext)servletContext);
        this.sessionManager = (SessionManager)ContextHelper.getServiceFromContext(SessionManager.class, (ServletContext)servletContext);
        this.ruleStore = (RuleStore)ContextHelper.getServiceFromContext(RuleStore.class, (ServletContext)servletContext);
        this.adapterManager = (RuleAdapterManager)ContextHelper.getServiceFromContext(RuleAdapterManager.class, (ServletContext)servletContext);
        String[] supported = new String[]{"GET", "POST"};
        if (!Arrays.asList(supported).contains(this.httpContext.getRequest().getMethod())) {
            throw new WebApplicationException(405);
        }
        try {
            this.service = this.getService(serviceID);
        }
        catch (UnboundReasoningServiceException e) {
            this.log.error("Service not found: {}", (Object)serviceID);
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        this.log.debug("Service retrieved");
        if (!this.service.supportsTask(taskID) && !taskID.equals(ReasoningServiceExecutor.TASK_CHECK)) {
            this.log.error("Unsupported task (not found): {}", (Object)taskID);
            throw new WebApplicationException((Throwable)new Exception("Unsupported task (not found): " + taskID), Response.Status.NOT_FOUND);
        }
        this.taskID = taskID;
        if (!job.equals("")) {
            this.log.debug("Job param is {}", (Object)job);
            if (job.equals("/job")) {
                this.log.debug("Ask for background job");
                this.job = true;
            } else {
                this.log.error("Malformed request");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
        if (!(this.getCurrentService() instanceof JenaReasoningService) && !(this.getCurrentService() instanceof OWLApiReasoningService)) {
            this.log.error("This implementation of ReasoningService is not supported: {}", this.getCurrentService().getClass());
            throw new WebApplicationException((Throwable)new Exception("This implementation of ReasoningService is not supported: " + this.getCurrentService().getClass()), Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.log.debug("Implementation is supported");
    }

    private Map<String, List<String>> prepareParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        this.log.debug("Preparing parameters...");
        HttpRequestContext request = this.httpContext.getRequest();
        MultivaluedMap queryParameters = request.getQueryParameters();
        this.log.debug("... {} query parameters found", (Object)queryParameters.size());
        for (Map.Entry e : queryParameters.entrySet()) {
            parameters.put((String)e.getKey(), (List<String>)e.getValue());
        }
        Form formParameters = request.getFormParameters();
        this.log.debug("... {} form urlencoded parameters found", (Object)formParameters.size());
        for (Map.Entry e : formParameters.entrySet()) {
            parameters.put((String)e.getKey(), (List<String>)e.getValue());
        }
        this.log.debug("Parameters prepared");
        return parameters;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html", "text/plain", "application/rdf+xml", "text/turtle", "text/turtle", "text/n3"})
    public Response post() {
        return this.processRequest();
    }

    private Response processRequest() {
        if (this.job) {
            return this.processBackgroundRequest();
        }
        return this.processRealTimeRequest();
    }

    @GET
    @Produces(value={"text/html", "text/plain", "application/rdf+xml", "text/turtle", "text/turtle", "text/n3"})
    public Response get(@QueryParam(value="target") String targetGraphID) {
        this.log.debug("Called {} with parameters: {} ", (Object)this.httpContext.getRequest().getMethod(), (Object)this.parameters.keySet().toArray(new String[this.parameters.keySet().size()]));
        return this.processRequest();
    }

    private Response processBackgroundRequest() {
        if (this.parameters.isEmpty()) {
            this.log.error("Cannot start job without input parameters... sending BAD REQUEST");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String target = this.getTarget();
        ReasoningServiceInputManager imngr = this.prepareInput();
        ReasoningServiceExecutor executor = new ReasoningServiceExecutor(this.tcManager, imngr, this.getCurrentService(), this.getCurrentTask(), target, this.parameters);
        String jid = this.getJobManager().execute((Job)executor);
        URI location = URI.create(this.getPublicBaseUri() + "jobs/" + jid);
        this.jobLocation = location.toString();
        Viewable view = new Viewable("created", (Object)this);
        return Response.created((URI)location).entity((Object)view).build();
    }

    private Response processRealTimeRequest() {
        if (this.parameters.isEmpty()) {
            Response.ResponseBuilder rb = Response.ok((Object)new Viewable("index", (Object)this));
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            CorsHelper.addCORSOrigin((ServletContext)this.servletContext, (Response.ResponseBuilder)rb, (HttpHeaders)this.headers);
            return rb.build();
        }
        try {
            String target = this.getTarget();
            ReasoningServiceInputManager imngr = this.prepareInput();
            ReasoningServiceExecutor executor = new ReasoningServiceExecutor(this.tcManager, imngr, this.getCurrentService(), this.getCurrentTask(), target, this.parameters);
            Object result = executor.call();
            return new ResponseTaskBuilder(this.uriInfo, this.context, this.headers).build((ReasoningServiceResult<? extends Object>)result);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getTarget() {
        String target = null;
        if (this.parameters.get("target") != null) {
            if (!this.parameters.get("target").isEmpty()) {
                target = this.parameters.get("target").iterator().next();
                if (target.equals("")) {
                    this.log.error("Parameter 'target' must have a value!");
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            } else {
                this.log.error("Parameter 'target' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
        return target;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html", "text/plain", "application/rdf+xml", "text/turtle", "text/turtle", "text/n3"})
    public Response post(FormDataMultiPart data) {
        this.log.debug(" post(FormDataMultiPart data)");
        File file = null;
        for (BodyPart bpart : data.getBodyParts()) {
            this.log.debug("is a {}", bpart.getClass());
            if (!(bpart instanceof FormDataBodyPart)) continue;
            FormDataBodyPart dbp = (FormDataBodyPart)bpart;
            if (dbp.getName().equals("file")) {
                file = (File)bpart.getEntityAs(File.class);
            }
            if (!dbp.isSimple()) continue;
            if (this.parameters.containsKey(dbp.getName())) {
                this.parameters.get(dbp.getName()).add(dbp.getValue());
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(dbp.getValue());
            this.parameters.put(dbp.getName(), values);
        }
        if (file != null) {
            ArrayList<String> values = new ArrayList<String>();
            try {
                if (!file.canRead() || !file.exists()) {
                    this.log.error("Bad request");
                    this.log.error(" file is: {}", (Object)file);
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
                values.add(file.toURI().toURL().toString());
            }
            catch (MalformedURLException e) {
                throw new WebApplicationException();
            }
            this.parameters.put("file", values);
        }
        return this.processRequest();
    }

    private ReasoningServiceInputManager prepareInput() {
        SimpleInputManager inmgr = new SimpleInputManager();
        String scope = null;
        String session = null;
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            if (entry.getKey().equals("url")) {
                if (!entry.getValue().isEmpty()) {
                    inmgr.addInputProvider(new UrlInputProvider(entry.getValue().iterator().next()));
                    this.parameters.remove("url");
                    continue;
                }
                this.log.error("Parameter 'url' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (entry.getKey().equals("file")) {
                if (!entry.getValue().isEmpty()) {
                    String fv = entry.getValue().iterator().next();
                    this.log.debug("File value is: {}", (Object)fv);
                    inmgr.addInputProvider(new FileInputProvider(new File(URI.create(fv))));
                    this.parameters.remove("url");
                    continue;
                }
                this.log.error("Parameter 'url' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (entry.getKey().equals("scope")) {
                if (!entry.getValue().isEmpty()) {
                    scope = entry.getValue().iterator().next();
                    continue;
                }
                this.log.error("Parameter 'scope' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (entry.getKey().equals("session")) {
                if (!entry.getValue().isEmpty()) {
                    session = entry.getValue().iterator().next();
                    continue;
                }
                this.log.error("Parameter 'session' must have a value!");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (!entry.getKey().equals("recipe")) continue;
            if (!entry.getValue().isEmpty()) {
                inmgr.addInputProvider(new RecipeInputProvider(this.ruleStore, this.adapterManager, entry.getValue().iterator().next()));
                this.parameters.remove("url");
                continue;
            }
            this.log.error("Parameter 'recipe' must have a value!");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (scope != null) {
            inmgr.addInputProvider(new OntologyManagerInputProvider(this.onm, this.sessionManager, scope, session));
            this.parameters.remove("scope");
            this.parameters.remove("session");
        }
        return inmgr;
    }

    public String getCurrentPath() {
        return this.uriInfo.getPath().replaceAll("[\\/]*$", "");
    }

    public ReasoningService<?, ?, ?> getCurrentService() {
        return this.service;
    }

    public String getCurrentTask() {
        return this.taskID;
    }

    public String getJobLocation() {
        return this.jobLocation;
    }

    public List<String> getSupportedTasks() {
        ArrayList<String> supported = new ArrayList<String>();
        supported.add(ReasoningServiceExecutor.TASK_CHECK);
        supported.addAll(this.getCurrentService().getSupportedTasks());
        return supported;
    }

    private ReasoningService<?, ?, ?> getService(String servicePath) throws UnboundReasoningServiceException {
        return this.getServicesManager().get(servicePath);
    }

    private ReasoningServicesManager getServicesManager() {
        this.log.debug("(getServicesManager()) ");
        return (ReasoningServicesManager)ContextHelper.getServiceFromContext(ReasoningServicesManager.class, (ServletContext)this.context);
    }

    public Set<ReasoningService<?, ?, ?>> getActiveServices() {
        this.log.debug("(getActiveServices()) There are {} reasoning services", (Object)this.getServicesManager().size());
        return this.getServicesManager().asUnmodifiableSet();
    }

    private JobManager getJobManager() {
        this.log.debug("(getJobManager()) ");
        return (JobManager)ContextHelper.getServiceFromContext(JobManager.class, (ServletContext)this.context);
    }

    public Map<String, String> getServiceDescription() {
        return this.getServiceDescription(this.service);
    }

    public Map<String, String> getServiceDescription(ReasoningService<?, ?, ?> service) {
        String description;
        String name;
        Class<?> serviceC = service.getClass();
        try {
            name = serviceC.getAnnotation(Documentation.class).name();
        }
        catch (NullPointerException e) {
            this.log.warn("The service {} is not documented: missing name", serviceC);
            name = "";
        }
        try {
            description = serviceC.getAnnotation(Documentation.class).description();
        }
        catch (NullPointerException e) {
            this.log.warn("The service {} is not documented: missing description", serviceC);
            description = "";
        }
        HashMap<String, String> serviceProperties = new HashMap<String, String>();
        serviceProperties.put("name", name);
        serviceProperties.put("description", description);
        serviceProperties.put("path", service.getPath());
        return serviceProperties;
    }
}

