/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stanbol.reasoners.web.utils;

import com.hp.hpl.jena.rdf.model.Model;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.stanbol.commons.viewable.Viewable;
import org.apache.stanbol.commons.web.base.CorsHelper;
import org.apache.stanbol.reasoners.web.utils.ReasoningPrettyResultResource;
import org.apache.stanbol.reasoners.web.utils.ReasoningServiceExecutor;
import org.apache.stanbol.reasoners.web.utils.ReasoningServiceResult;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.ManchesterOWLSyntaxOntologyStorer;

public class ResponseTaskBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private UriInfo info;
    private ServletContext context;
    private HttpHeaders headers;

    public ResponseTaskBuilder(UriInfo info, ServletContext context, HttpHeaders headers) {
        this.info = info;
        this.context = context;
        this.headers = headers;
    }

    private Response build(boolean result) {
        return this.buildCheckResponse(result);
    }

    private Response build() {
        Response.ResponseBuilder rb = Response.ok();
        CorsHelper.addCORSOrigin((ServletContext)this.context, (Response.ResponseBuilder)rb, (HttpHeaders)this.headers);
        return rb.build();
    }

    private Response build(Object object) {
        if (this.isHTML()) {
            OutputStream out = this.stream(object);
            Response.ResponseBuilder rb = Response.ok((Object)new Viewable("result", (Object)new ReasoningPrettyResultResource(this.context, this.info, out)));
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            CorsHelper.addCORSOrigin((ServletContext)this.context, (Response.ResponseBuilder)rb, (HttpHeaders)this.headers);
            return rb.build();
        }
        Response.ResponseBuilder rb = Response.ok((Object)object);
        CorsHelper.addCORSOrigin((ServletContext)this.context, (Response.ResponseBuilder)rb, (HttpHeaders)this.headers);
        return rb.build();
    }

    private OutputStream stream(Object object) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (object instanceof OWLOntology) {
            OWLOntology o = (OWLOntology)object;
            ManchesterOWLSyntaxOntologyStorer mosos = new ManchesterOWLSyntaxOntologyStorer();
            try {
                mosos.storeOntology(o.getOWLOntologyManager(), o, (OWLOntologyDocumentTarget)new StreamDocumentTarget((OutputStream)out), (OWLOntologyFormat)new ManchesterOWLSyntaxOntologyFormat());
            }
            catch (OWLOntologyStorageException e) {
                this.log.error("Cannot stream the ontology", (Throwable)e);
                throw new RuntimeException(e);
            }
        } else if (object instanceof Model) {
            Model m = (Model)object;
            m.write((OutputStream)out, "TURTLE");
        }
        return out;
    }

    private boolean isHTML() {
        HashSet<String> htmlformats = new HashSet<String>();
        htmlformats.add("text/html");
        HashSet<String> rdfformats = new HashSet<String>();
        String[] formats = new String[]{"text/html", "text/plain", "application/rdf+xml", "text/turtle", "text/turtle", "text/n3"};
        rdfformats.addAll(Arrays.asList(formats));
        List mediaTypes = this.headers.getAcceptableMediaTypes();
        for (MediaType t : mediaTypes) {
            String strty = t.toString();
            this.log.debug("Acceptable is {}", (Object)t);
            if (htmlformats.contains(strty)) {
                this.log.debug("Requested format is HTML {}", (Object)t);
                return true;
            }
            if (!rdfformats.contains(strty)) continue;
            this.log.debug("Requested format is RDF {}", (Object)t);
            return false;
        }
        return true;
    }

    private Response buildCheckResponse(boolean isConsistent) {
        if (this.isHTML()) {
            if (isConsistent) {
                this.log.debug("The input is consistent");
                Response.ResponseBuilder rb = Response.ok((Object)new Viewable("result", (Object)new ReasoningPrettyResultResource(this.context, this.info, "The input is consistent :)")));
                rb.header("Content-Type", (Object)"text/html; charset=utf-8");
                CorsHelper.addCORSOrigin((ServletContext)this.context, (Response.ResponseBuilder)rb, (HttpHeaders)this.headers);
                return rb.build();
            }
            this.log.debug("The input is not consistent");
            Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.CONFLICT);
            rb.header("Content-Type", (Object)"text/html; charset=utf-8");
            CorsHelper.addCORSOrigin((ServletContext)this.context, (Response.ResponseBuilder)rb, (HttpHeaders)this.headers);
            rb.entity((Object)new Viewable("result", (Object)new ReasoningPrettyResultResource(this.context, this.info, "The input is NOT consistent :(")));
            return rb.build();
        }
        if (isConsistent) {
            this.log.debug("The input is consistent");
            Response.ResponseBuilder rb = Response.ok((Object)"The input is consistent :)");
            CorsHelper.addCORSOrigin((ServletContext)this.context, (Response.ResponseBuilder)rb, (HttpHeaders)this.headers);
            return rb.build();
        }
        this.log.debug("The input is not consistent");
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.CONFLICT);
        CorsHelper.addCORSOrigin((ServletContext)this.context, (Response.ResponseBuilder)rb, (HttpHeaders)this.headers);
        return rb.build();
    }

    public Response build(ReasoningServiceResult<? extends Object> result) {
        if (result.getTask().equals(ReasoningServiceExecutor.TASK_CHECK)) {
            return this.build(result.isSuccess());
        }
        if (result.get() != null) {
            return this.build(result.get());
        }
        return this.build();
    }
}

