/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.StatisticsLog;

public class StatisticsRecord {
    private String id;
    private final List<StatisticsLog> statisticsLogs = new CopyOnWriteArrayList<StatisticsLog>();
    private String clientIP;
    private String clientHost;
    private ComponentType owner;
    private boolean isEndReported = false;

    public StatisticsRecord(String id, String clientIP, String clientHost) {
        this.id = id;
        this.clientIP = clientIP;
        this.clientHost = clientHost;
    }

    public String getId() {
        return this.id;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void collect(StatisticsLog log) {
        if (log != null) {
            this.statisticsLogs.add(log);
        }
    }

    public List<StatisticsLog> getAllStatisticsLogs() {
        ArrayList<StatisticsLog> logs = new ArrayList<StatisticsLog>();
        logs.addAll(this.statisticsLogs);
        return logs;
    }

    public Iterator<String> getAllLogIds(ComponentType componentType) {
        ArrayList<String> logIds = new ArrayList<String>();
        for (StatisticsLog startLog : this.statisticsLogs) {
            String id;
            if (startLog == null || startLog.getComponentType() != componentType || (id = startLog.getId()) == null || "".equals(id) || logIds.contains(id)) continue;
            logIds.add(id);
        }
        return logIds.iterator();
    }

    public void clearLogs() {
        this.statisticsLogs.clear();
    }

    public ComponentType getOwner() {
        return this.owner;
    }

    public void setOwner(ComponentType owner) {
        this.owner = owner;
    }

    public boolean isEndReported() {
        return this.isEndReported;
    }

    public void setEndReported(boolean endReported) {
        this.isEndReported = endReported;
    }

    public String toString() {
        return new StringBuffer().append("[Message id : ").append(this.id).append(" ]").append("[Remote  IP : ").append(this.clientIP).append(" ]").append("[Remote host : ").append(this.clientHost).append(" ]").toString();
    }
}

