/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.ConfigurationFactory;
import org.apache.synapse.config.xml.ConfigurationSerializer;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import sun.misc.Service;

public class ConfigurationFactoryAndSerializerFinder
implements XMLToObjectMapper {
    private static final Log log = LogFactory.getLog(ConfigurationFactoryAndSerializerFinder.class);
    private static final Class[] configurationFactories = new Class[]{SynapseXMLConfigurationFactory.class};
    private static final ConfigurationFactoryAndSerializerFinder instance = new ConfigurationFactoryAndSerializerFinder();
    private static final Map<QName, Class> factoryMap = new HashMap<QName, Class>();
    private static final Map<QName, Class> serializerMap = new HashMap<QName, Class>();
    private static boolean initialized = false;

    public static synchronized ConfigurationFactoryAndSerializerFinder getInstance() {
        if (!initialized) {
            ConfigurationFactoryAndSerializerFinder.loadConfigurationFatoriesAndSerializers();
        }
        return instance;
    }

    public static synchronized void reset() {
        factoryMap.clear();
        serializerMap.clear();
        initialized = false;
    }

    private ConfigurationFactoryAndSerializerFinder() {
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void loadConfigurationFatoriesAndSerializers() {
        for (Class c : configurationFactories) {
            if (c == null) continue;
            try {
                ConfigurationFactory fac = (ConfigurationFactory)c.newInstance();
                factoryMap.put(fac.getTagQName(), c);
                serializerMap.put(fac.getTagQName(), fac.getSerializerClass());
            }
            catch (Exception e) {
                throw new SynapseException("Error instantiating " + c.getName(), e);
            }
        }
        ConfigurationFactoryAndSerializerFinder.registerExtensions();
        initialized = true;
    }

    private static void registerExtensions() {
        Iterator it = Service.providers(ConfigurationFactory.class);
        while (it.hasNext()) {
            ConfigurationFactory cf = (ConfigurationFactory)it.next();
            QName tag = cf.getTagQName();
            factoryMap.put(tag, cf.getClass());
            serializerMap.put(tag, cf.getSerializerClass());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added MediatorFactory " + cf.getClass() + " to handle " + tag));
        }
    }

    public SynapseConfiguration getConfiguration(OMElement element, Properties properties) {
        Class cls;
        String localName = element.getLocalName();
        QName qName = element.getNamespace() != null ? new QName(element.getNamespace().getNamespaceURI(), localName) : new QName(localName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getConfiguration(" + qName + ")"));
        }
        if ((cls = factoryMap.get(qName)) == null) {
            String msg = "Unknown Configuration type referenced by configuration element : " + qName;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            ConfigurationFactory cf = (ConfigurationFactory)cls.newInstance();
            return cf.getConfiguration(element, properties);
        }
        catch (InstantiationException e) {
            String msg = "Error initializing configuration factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Error initializing configuration factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
    }

    public static OMElement serializeConfiguration(SynapseConfiguration synCfg) {
        if (synCfg.getDefaultQName() == null) {
            return ConfigurationFactoryAndSerializerFinder.serializeConfiguration(synCfg, XMLConfigConstants.DEFINITIONS_ELT);
        }
        return ConfigurationFactoryAndSerializerFinder.serializeConfiguration(synCfg, synCfg.getDefaultQName());
    }

    public static OMElement serializeConfiguration(SynapseConfiguration synCfg, QName qName) {
        Class cls = serializerMap.get(qName);
        if (cls == null) {
            String msg = "Unknown Configuration type referenced by configuration element : " + qName;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            ConfigurationSerializer cs = (ConfigurationSerializer)cls.newInstance();
            return cs.serializeConfiguration(synCfg);
        }
        catch (InstantiationException e) {
            String msg = "Error initializing configuration factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Error initializing configuration factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
    }

    public Map getFactoryMap() {
        return factoryMap;
    }

    public static Map getSerializerMap() {
        return serializerMap;
    }

    @Override
    public Object getObjectFromOMNode(OMNode om, Properties properties) {
        if (om instanceof OMElement) {
            return this.getConfiguration((OMElement)om, properties);
        }
        this.handleException("Invalid configuration XML : " + om);
        return null;
    }
}

