/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.bean.BeanUtils;
import org.apache.synapse.mediators.bean.Target;
import org.apache.synapse.mediators.bean.enterprise.EJBMediator;

public class EJBMediatorFactory
extends AbstractMediatorFactory {
    private static final QName EJB_Q = new QName("http://ws.apache.org/ns/synapse", "ejb");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMElement argumentsElem;
        boolean remove;
        EJBMediator mediator = new EJBMediator();
        String attributeValue = elem.getAttributeValue(new QName("beanstalk"));
        if (attributeValue != null) {
            mediator.setBeanstalkName(attributeValue.trim());
        } else {
            this.handleException("'beanstalk' attribute of callEjb mediator is required");
        }
        attributeValue = elem.getAttributeValue(new QName("class"));
        if (attributeValue != null) {
            mediator.setClassName(attributeValue.trim());
        } else {
            this.handleException("'class' attribute of callEjb mediator is required");
        }
        attributeValue = elem.getAttributeValue(new QName("stateful"));
        if (Boolean.valueOf(attributeValue).booleanValue()) {
            attributeValue = elem.getAttributeValue(new QName("id"));
            if (attributeValue != null) {
                mediator.setBeanId(new ValueFactory().createValue("id", elem));
            } else {
                this.handleException("'id' attribute is required for stateful session bean invocations.");
            }
        }
        if (remove = Boolean.valueOf(attributeValue = elem.getAttributeValue(new QName("remove"))).booleanValue()) {
            mediator.setRemove(true);
        }
        if (elem.getAttributeValue(new QName("target")) != null) {
            mediator.setTarget(new Target("target", elem));
        }
        if ((attributeValue = elem.getAttributeValue(new QName("jndiName"))) != null) {
            mediator.setJndiName(attributeValue);
        }
        if ((argumentsElem = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "args"))) != null) {
            Iterator itr = argumentsElem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "arg"));
            while (itr.hasNext()) {
                OMElement argElem = (OMElement)itr.next();
                if (argElem.getAttributeValue(ATT_VALUE) != null) {
                    mediator.addArgument(new ValueFactory().createValue("value", argElem));
                    continue;
                }
                this.handleException("'value' attribute of 'arg' element is required.");
            }
        }
        if ((attributeValue = elem.getAttributeValue(new QName("method"))) != null) {
            Method method = null;
            try {
                method = BeanUtils.resolveMethod(Class.forName(mediator.getClassName()), attributeValue, mediator.getArgumentList().size());
            }
            catch (ClassNotFoundException e) {
                this.handleException("Could not load '" + mediator.getClassName() + "' class.", e);
            }
            mediator.setMethod(method);
        } else if (!remove) {
            this.handleException("'method' attribute of EJB mediator is optional only when it's a bean removal.");
        }
        return mediator;
    }

    @Override
    public QName getTagQName() {
        return EJB_Q;
    }
}

