/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.bean.enterprise.EJBMediator;

public class EJBMediatorSerializer
extends AbstractMediatorSerializer {
    private static final String EJB = "ejb";

    @Override
    public OMElement serializeSpecificMediator(Mediator m) {
        List<Value> argList;
        if (!(m instanceof EJBMediator)) {
            this.handleException("An unsupported mediator was passed in for serialization : " + m.getType());
            return null;
        }
        EJBMediator mediator = (EJBMediator)m;
        OMElement mediatorElem = fac.createOMElement(EJB, synNS);
        EJBMediatorSerializer.saveTracingState(mediatorElem, mediator);
        if (mediator.getBeanstalkName() != null) {
            mediatorElem.addAttribute(fac.createOMAttribute("beanstalk", nullNS, mediator.getBeanstalkName()));
        } else {
            this.handleException();
        }
        if (mediator.getClassName() != null) {
            mediatorElem.addAttribute(fac.createOMAttribute("class", nullNS, mediator.getClassName()));
        } else {
            this.handleException();
        }
        if (mediator.getBeanId() != null) {
            mediatorElem.addAttribute(fac.createOMAttribute("stateful", nullNS, Boolean.toString(true)));
            new ValueSerializer().serializeValue(mediator.getBeanId(), "id", mediatorElem);
        }
        if (mediator.getMethod() != null) {
            mediatorElem.addAttribute(fac.createOMAttribute("method", nullNS, mediator.getMethod().getName()));
        } else if (!mediator.isRemove()) {
            this.handleException();
        }
        if (mediator.getTarget() != null) {
            mediator.getTarget().serializeTarget("target", mediatorElem);
        }
        if (mediator.getJndiName() != null) {
            mediatorElem.addAttribute(fac.createOMAttribute("jndiName", nullNS, mediator.getJndiName()));
        }
        if (mediator.isRemove()) {
            mediatorElem.addAttribute(fac.createOMAttribute("remove", nullNS, Boolean.toString(true)));
        }
        if ((argList = mediator.getArgumentList()) != null && argList.size() > 0) {
            OMElement argumentsElem = fac.createOMElement("args", synNS);
            for (Value arg : argList) {
                OMElement argElem = fac.createOMElement("arg", synNS);
                new ValueSerializer().serializeValue(arg, "value", argElem);
                argumentsElem.addChild((OMNode)argElem);
            }
            mediatorElem.addChild((OMNode)argumentsElem);
        }
        return mediatorElem;
    }

    @Override
    public String getMediatorClassName() {
        return EJBMediator.class.getName();
    }

    private void handleException() {
        this.handleException("Invalid ejb mediator was passed in for serialization.");
    }
}

