/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.elementary.EnrichMediator;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;

public class EnrichMediatorSerializer
extends AbstractMediatorSerializer {
    @Override
    protected OMElement serializeSpecificMediator(Mediator m) {
        assert (m != null) : "mediator cannot be null";
        assert (m instanceof EnrichMediator) : "mediator should be of type EnrichMediator";
        EnrichMediator mediator = (EnrichMediator)m;
        OMElement enrichEle = fac.createOMElement("enrich", synNS);
        OMElement sourceEle = this.serializeSource(mediator.getSource());
        OMElement targetEle = this.serializeTarget(mediator.getTarget());
        enrichEle.addChild((OMNode)sourceEle);
        enrichEle.addChild((OMNode)targetEle);
        return enrichEle;
    }

    private OMElement serializeSource(Source source) {
        OMElement sourceEle = fac.createOMElement("source", synNS);
        if (source.getSourceType() != 0) {
            sourceEle.addAttribute(fac.createOMAttribute("type", nullNS, this.intTypeToString(source.getSourceType())));
        }
        if (source.isClone()) {
            sourceEle.addAttribute(fac.createOMAttribute("clone", nullNS, Boolean.toString(source.isClone())));
        }
        if (source.getSourceType() == 3) {
            sourceEle.addAttribute(fac.createOMAttribute("property", nullNS, source.getProperty()));
        } else if (source.getSourceType() == 0) {
            SynapseXPathSerializer.serializeXPath(source.getXpath(), sourceEle, "xpath");
        } else if (source.getSourceType() == 4) {
            if (source.getInlineOMNode() instanceof OMElement) {
                sourceEle.addChild((OMNode)((OMElement)source.getInlineOMNode()).cloneOMElement());
            } else if (source.getInlineOMNode() instanceof OMText) {
                sourceEle.setText(((OMText)source.getInlineOMNode()).getText());
            } else if (source.getInlineKey() != null) {
                sourceEle.addAttribute("key", source.getInlineKey(), null);
            }
        }
        return sourceEle;
    }

    private OMElement serializeTarget(Target target) {
        OMElement targetEle = fac.createOMElement("target", synNS);
        if (target.getTargetType() != 0) {
            targetEle.addAttribute(fac.createOMAttribute("type", nullNS, this.intTypeToString(target.getTargetType())));
        }
        if (!target.getAction().equals("replace")) {
            targetEle.addAttribute(fac.createOMAttribute("action", nullNS, target.getAction()));
        }
        if (target.getTargetType() == 3) {
            targetEle.addAttribute(fac.createOMAttribute("property", nullNS, target.getProperty()));
        } else if (target.getTargetType() == 0) {
            SynapseXPathSerializer.serializeXPath(target.getXpath(), targetEle, "xpath");
        }
        return targetEle;
    }

    private String intTypeToString(int type) {
        if (type == 0) {
            return "custom";
        }
        if (type == 2) {
            return "body";
        }
        if (type == 1) {
            return "envelope";
        }
        if (type == 3) {
            return "property";
        }
        if (type == 4) {
            return "inline";
        }
        return null;
    }

    @Override
    public String getMediatorClassName() {
        return EnrichMediator.class.getName();
    }
}

