/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.mediators.transform.FaultMediator;
import org.jaxen.JaxenException;

public class FaultMediatorFactory
extends AbstractMediatorFactory {
    private static final QName FAULT_Q = new QName("http://ws.apache.org/ns/synapse", "makefault");
    private static final QName ATT_VERSION_Q = new QName("", "version");
    private static final QName ATT_RESPONSE_Q = new QName("", "response");
    private static final QName CODE_Q = new QName("http://ws.apache.org/ns/synapse", "code");
    private static final QName REASON_Q = new QName("http://ws.apache.org/ns/synapse", "reason");
    private static final QName NODE_Q = new QName("http://ws.apache.org/ns/synapse", "node");
    private static final QName ROLE_Q = new QName("http://ws.apache.org/ns/synapse", "role");
    private static final QName DETAIL_Q = new QName("http://ws.apache.org/ns/synapse", "detail");
    private static final String SOAP11 = "soap11";
    private static final String SOAP12 = "soap12";
    private static final String POX = "pox";

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMElement detail;
        OMElement role;
        OMElement code;
        OMAttribute response;
        FaultMediator faultMediator = new FaultMediator();
        OMAttribute version = elem.getAttribute(ATT_VERSION_Q);
        if (version != null) {
            if (SOAP11.equals(version.getAttributeValue())) {
                faultMediator.setSoapVersion(1);
            } else if (SOAP12.equals(version.getAttributeValue())) {
                faultMediator.setSoapVersion(2);
            } else if (POX.equals(version.getAttributeValue())) {
                faultMediator.setSoapVersion(3);
            } else {
                this.handleException("Invalid SOAP version");
            }
        }
        if ((response = elem.getAttribute(ATT_RESPONSE_Q)) != null) {
            if ("true".equals(response.getAttributeValue())) {
                faultMediator.setMarkAsResponse(true);
            } else if ("false".equals(response.getAttributeValue())) {
                faultMediator.setMarkAsResponse(false);
            } else {
                this.handleException("Invalid value '" + response.getAttributeValue() + "' passed as response. Expected 'true' or 'false'");
            }
            faultMediator.setSerializeResponse(true);
        }
        if ((code = elem.getFirstChildWithName(CODE_Q)) != null) {
            OMAttribute value = code.getAttribute(ATT_VALUE);
            OMAttribute expression = code.getAttribute(ATT_EXPRN);
            if (value != null) {
                String strValue = value.getAttributeValue();
                String prefix = null;
                String name = null;
                if (strValue.indexOf(":") != -1) {
                    prefix = strValue.substring(0, strValue.indexOf(":"));
                    name = strValue.substring(strValue.indexOf(":") + 1);
                } else {
                    this.handleException("A QName is expected for fault code as prefix:name");
                }
                String namespaceURI = OMElementUtils.getNameSpaceWithPrefix(prefix, code);
                if (namespaceURI == null) {
                    this.handleException("Invalid namespace prefix '" + prefix + "' in code attribute");
                }
                faultMediator.setFaultCodeValue(new QName(namespaceURI, name, prefix));
            } else if (expression != null) {
                try {
                    faultMediator.setFaultCodeExpr(SynapseXPathFactory.getSynapseXPath(code, ATT_EXPRN));
                }
                catch (JaxenException je) {
                    this.handleException("Invalid fault code expression : " + je.getMessage(), (Exception)((Object)je));
                }
            } else {
                this.handleException("A 'value' or 'expression' attribute must specify the fault code");
            }
        } else if (faultMediator.getSoapVersion() != 3) {
            this.handleException("The fault code is a required attribute for the makefault mediator unless it is a pox fault");
        }
        OMElement reason = elem.getFirstChildWithName(REASON_Q);
        if (reason != null) {
            OMAttribute value = reason.getAttribute(ATT_VALUE);
            OMAttribute expression = reason.getAttribute(ATT_EXPRN);
            if (value != null) {
                faultMediator.setFaultReasonValue(value.getAttributeValue());
            } else if (expression != null) {
                try {
                    faultMediator.setFaultReasonExpr(SynapseXPathFactory.getSynapseXPath(reason, ATT_EXPRN));
                }
                catch (JaxenException je) {
                    this.handleException("Invalid fault reason expression : " + je.getMessage(), (Exception)((Object)je));
                }
            } else {
                this.handleException("A 'value' or 'expression' attribute must specify the fault code");
            }
        } else if (faultMediator.getSoapVersion() != 3) {
            this.handleException("The fault reason is a required attribute for the makefault mediator unless it is a pox fault");
        }
        this.processAuditStatus(faultMediator, elem);
        OMElement node = elem.getFirstChildWithName(NODE_Q);
        if (node != null && node.getText() != null && !SOAP11.equals(version.getAttributeValue())) {
            try {
                faultMediator.setFaultNode(new URI(node.getText()));
            }
            catch (URISyntaxException e) {
                this.handleException("Invalid URI specified for fault node : " + node.getText(), e);
            }
        }
        if ((role = elem.getFirstChildWithName(ROLE_Q)) != null && role.getText() != null) {
            try {
                faultMediator.setFaultRole(new URI(role.getText()));
            }
            catch (URISyntaxException e) {
                this.handleException("Invalid URI specified for fault role : " + role.getText(), e);
            }
        }
        if ((detail = elem.getFirstChildWithName(DETAIL_Q)) != null) {
            OMAttribute detailExpr = detail.getAttribute(ATT_EXPRN);
            if (detailExpr != null && detailExpr.getAttributeValue() != null) {
                try {
                    faultMediator.setFaultDetailExpr(SynapseXPathFactory.getSynapseXPath(detail, ATT_EXPRN));
                }
                catch (JaxenException e) {
                    this.handleException("Unable to build the XPath for fault detail from the expression : " + detailExpr.getAttributeValue(), (Exception)((Object)e));
                }
            } else if (detail.getChildElements().hasNext()) {
                Iterator it = detail.getChildElements();
                while (it.hasNext()) {
                    OMElement child = (OMElement)it.next();
                    if (child == null) continue;
                    faultMediator.addFaultDetailElement(child);
                }
            } else if (detail.getText() != null) {
                faultMediator.setFaultDetail(detail.getText());
            } else {
                faultMediator.setFaultDetail("");
            }
        }
        return faultMediator;
    }

    @Override
    public QName getTagQName() {
        return FAULT_Q;
    }
}

