/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.InvokeMediatorFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.template.InvokeMediator;

public class InvokeMediatorSerializer
extends AbstractMediatorSerializer {
    public static final String INVOKE_N = "call-template";

    @Override
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof InvokeMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        InvokeMediator mediator = (InvokeMediator)m;
        OMElement invokeElem = fac.createOMElement(INVOKE_N, synNS);
        if (mediator.getTargetTemplate() != null) {
            invokeElem.addAttribute(fac.createOMAttribute("target", nullNS, mediator.getTargetTemplate()));
            this.serializeParams(invokeElem, mediator);
            InvokeMediatorSerializer.saveTracingState(invokeElem, mediator);
        }
        return invokeElem;
    }

    private void serializeParams(OMElement invokeElem, InvokeMediator mediator) {
        Map<String, Value> paramsMap = mediator.getpName2ExpressionMap();
        for (String paramName : paramsMap.keySet()) {
            if ("".equals(paramName)) continue;
            OMElement paramEl = fac.createOMElement(InvokeMediatorFactory.WITH_PARAM_Q.getLocalPart(), synNS);
            paramEl.addAttribute(fac.createOMAttribute("name", nullNS, paramName));
            Value value = paramsMap.get(paramName);
            new ValueSerializer().serializeValue(value, "value", paramEl);
            invokeElem.addChild((OMNode)paramEl);
        }
    }

    @Override
    public String getMediatorClassName() {
        return InvokeMediator.class.getName();
    }
}

