/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.mediators.store.MessageStoreMediator;

public class MessageStoreMediatorFactory
extends AbstractMediatorFactory {
    private static final QName STORE_Q = new QName("http://ws.apache.org/ns/synapse", "store");
    private static final QName ATT_MESSAGE_STORE = new QName("messageStore");
    private static final QName ATT_SEQUENCE = new QName("sequence");

    @Override
    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMAttribute messageStoreNameAtt;
        MessageStoreMediator messageStoreMediator = new MessageStoreMediator();
        OMAttribute nameAtt = elem.getAttribute(ATT_NAME);
        if (nameAtt != null) {
            messageStoreMediator.setName(nameAtt.getAttributeValue());
        }
        if ((messageStoreNameAtt = elem.getAttribute(ATT_MESSAGE_STORE)) == null) {
            throw new SynapseException("Message Store mediator must have a Message store defined");
        }
        messageStoreMediator.setMessageStoreName(messageStoreNameAtt.getAttributeValue());
        OMAttribute sequenceAtt = elem.getAttribute(ATT_SEQUENCE);
        if (sequenceAtt != null) {
            messageStoreMediator.setOnStoreSequence(sequenceAtt.getAttributeValue());
        }
        return messageStoreMediator;
    }

    @Override
    public QName getTagQName() {
        return STORE_Q;
    }
}

