/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.transform.Argument;
import org.apache.synapse.mediators.transform.PayloadFactoryMediator;
import org.jaxen.JaxenException;

public class PayloadFactoryMediatorFactory
extends AbstractMediatorFactory {
    private static final QName PAYLOAD_FACTORY_Q = new QName("http://ws.apache.org/ns/synapse", "payloadFactory");
    private static final QName FORMAT_Q = new QName("http://ws.apache.org/ns/synapse", "format");
    private static final QName ARGS_Q = new QName("http://ws.apache.org/ns/synapse", "args");

    @Override
    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        PayloadFactoryMediator payloadFactoryMediator = new PayloadFactoryMediator();
        OMElement formatElem = elem.getFirstChildWithName(FORMAT_Q);
        if (formatElem != null) {
            OMAttribute n = formatElem.getAttribute(ATT_KEY);
            if (n == null) {
                OMElement copy = formatElem.getFirstElement().cloneOMElement();
                this.removeIndentations(copy);
                payloadFactoryMediator.setFormat(copy.toString());
            } else {
                ValueFactory keyFac = new ValueFactory();
                Value generatedKey = keyFac.createValue("key", formatElem);
                payloadFactoryMediator.setFormatKey(generatedKey);
                payloadFactoryMediator.setFormatDynamic(true);
            }
        } else {
            this.handleException("format element of payloadFactoryMediator is required");
        }
        OMElement argumentsElem = elem.getFirstChildWithName(ARGS_Q);
        if (argumentsElem != null) {
            Iterator itr = argumentsElem.getChildElements();
            while (itr.hasNext()) {
                OMElement argElem = (OMElement)itr.next();
                Argument arg = new Argument();
                String value = argElem.getAttributeValue(ATT_VALUE);
                if (value != null) {
                    arg.setValue(value);
                } else {
                    value = argElem.getAttributeValue(ATT_EXPRN);
                    if (value != null) {
                        if (value.trim().length() == 0) {
                            this.handleException("Attribute value for xpath cannot be empty");
                        } else {
                            try {
                                arg.setExpression(SynapseXPathFactory.getSynapseXPath(argElem, ATT_EXPRN));
                                arg.getExpression().setForceDisableStreamXpath(Boolean.TRUE);
                            }
                            catch (JaxenException e) {
                                this.handleException("Invalid XPath expression for attribute expression : " + value, (Exception)((Object)e));
                            }
                        }
                    } else {
                        this.handleException("Unsupported arg type. value or expression attribute required");
                    }
                }
                payloadFactoryMediator.addArgument(arg);
            }
        }
        return payloadFactoryMediator;
    }

    @Override
    public QName getTagQName() {
        return PAYLOAD_FACTORY_Q;
    }

    private void removeIndentations(OMElement element) {
        ArrayList<OMText> removables = new ArrayList<OMText>();
        this.removeIndentations(element, removables);
        for (OMText node : removables) {
            node.detach();
        }
    }

    private void removeIndentations(OMElement element, List<OMText> removables) {
        Iterator children = element.getChildren();
        while (children.hasNext()) {
            Object next = children.next();
            if (next instanceof OMText) {
                OMText text = (OMText)next;
                if (!text.getText().trim().equals("")) continue;
                removables.add(text);
                continue;
            }
            if (!(next instanceof OMElement)) continue;
            this.removeIndentations((OMElement)next, removables);
        }
    }
}

