/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.libraries.imports.SynapseImport;

public class SynapseImportFactory {
    private static final Log log = LogFactory.getLog(SynapseImportFactory.class);
    public static final QName NAME_Q = new QName("", "name");
    public static final QName PACKAGE_Q = new QName("", "package");
    public static final QName ARTIFACT_Q = new QName("http://ws.apache.org/ns/synapse", "artifact");

    public static SynapseImport createImport(OMElement elem, Properties properties) {
        OMAttribute pkgAtt = elem.getAttribute(PACKAGE_Q);
        SynapseImport synapseImport = new SynapseImport();
        OMAttribute nameAtt = elem.getAttribute(NAME_Q);
        if (nameAtt != null) {
            synapseImport.setLibName(nameAtt.getAttributeValue());
        } else {
            SynapseImportFactory.handleException("Synapse Import Target Library name is not specified");
        }
        if (pkgAtt != null) {
            synapseImport.setLibPackage(pkgAtt.getAttributeValue());
        } else {
            SynapseImportFactory.handleException("Synapse Import Target Library package is not specified");
        }
        log.info((Object)("Successfully created Synapse Import: " + nameAtt.getAttributeValue()));
        return synapseImport;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

