/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.jaxen.XPath;

public class SynapseXPathFactory {
    private static final Log log = LogFactory.getLog(SynapseXPathFactory.class);

    public static SynapseXPath getSynapseXPath(OMElement elem, QName attribName) throws JaxenException {
        SynapseXPath xpath = null;
        OMAttribute xpathAttrib = elem.getAttribute(attribName);
        if (xpathAttrib != null && xpathAttrib.getAttributeValue() != null) {
            xpath = new SynapseXPath(xpathAttrib.getAttributeValue());
            OMElementUtils.addNameSpaces((XPath)xpath, elem, log);
            xpath.addNamespacesForFallbackProcessing(elem);
        } else {
            SynapseXPathFactory.handleException("Couldn't find the XPath attribute with the QName : " + attribName.toString() + " in the element : " + elem.toString());
        }
        return xpath;
    }

    public static SynapseXPath getSynapseXPath(OMElement elem, String expression) throws JaxenException {
        if (expression == null) {
            SynapseXPathFactory.handleException("XPath expression cannot be null");
        }
        SynapseXPath xpath = new SynapseXPath(expression);
        OMElementUtils.addNameSpaces((XPath)xpath, elem, log);
        return xpath;
    }

    private static void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

