/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractListMediatorFactory;
import org.apache.synapse.mediators.template.TemplateMediator;

public class TemplateMediatorFactory
extends AbstractListMediatorFactory {
    private static final QName TEMPLATE_Q = new QName("http://ws.apache.org/ns/synapse", "template");
    private static final QName TEMPLATE_BODY_Q = new QName("http://ws.apache.org/ns/synapse", "sequence");
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");

    @Override
    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        TemplateMediator templateTemplateMediator = new TemplateMediator();
        OMAttribute nameAttr = elem.getAttribute(ATT_NAME);
        if (nameAttr == null) {
            String msg = "A EIP template should be a named mediator .";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        templateTemplateMediator.setName(nameAttr.getAttributeValue());
        this.processAuditStatus(templateTemplateMediator, elem);
        this.initParameters(elem, templateTemplateMediator);
        OMElement templateBodyElem = elem.getFirstChildWithName(TEMPLATE_BODY_Q);
        TemplateMediatorFactory.addChildren(templateBodyElem, templateTemplateMediator, properties);
        return templateTemplateMediator;
    }

    private void initParameters(OMElement templateElem, TemplateMediator templateMediator) {
        Iterator subElements = templateElem.getChildElements();
        ArrayList<String> paramNames = new ArrayList<String>();
        while (subElements.hasNext()) {
            OMAttribute paramNameAttr;
            OMElement child = (OMElement)subElements.next();
            if (!child.getQName().equals(PARAMETER_Q) || (paramNameAttr = child.getAttribute(ATT_NAME)) == null) continue;
            paramNames.add(paramNameAttr.getAttributeValue());
        }
        templateMediator.setParameters(paramNames);
    }

    @Override
    public QName getTagQName() {
        return TEMPLATE_Q;
    }
}

