/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Collection;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorSerializer;
import org.apache.synapse.mediators.template.TemplateMediator;

public class TemplateMediatorSerializer
extends AbstractListMediatorSerializer {
    @Override
    protected OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof TemplateMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        TemplateMediator mediator = (TemplateMediator)m;
        OMElement templateElem = fac.createOMElement("template", synNS);
        if (mediator.getName() != null) {
            templateElem.addAttribute(fac.createOMAttribute("name", nullNS, mediator.getName()));
            this.serializeParams(templateElem, mediator);
            this.serializeBody(templateElem, mediator.getList());
            TemplateMediatorSerializer.saveTracingState(templateElem, mediator);
        }
        return templateElem;
    }

    private void serializeParams(OMElement templateElem, TemplateMediator mediator) {
        Collection<String> params = mediator.getParameters();
        for (String param : params) {
            if (param == null || "".equals(param)) continue;
            OMElement paramEl = fac.createOMElement("parameter", synNS);
            paramEl.addAttribute(fac.createOMAttribute("name", nullNS, param));
            templateElem.addChild((OMNode)paramEl);
        }
    }

    private void serializeBody(OMElement templateElem, List<Mediator> childMediatorList) {
        OMElement seqEl = fac.createOMElement("sequence", synNS);
        templateElem.addChild((OMNode)seqEl);
        this.serializeChildren(seqEl, childMediatorList);
    }

    @Override
    public String getMediatorClassName() {
        return TemplateMediator.class.getName();
    }
}

