/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.ClassEndpoint;
import org.apache.synapse.endpoints.Endpoint;

public class ClassEndpointSerializer
extends EndpointSerializer {
    private static final QName PARAMETER_QNAME = new QName("parameter");

    @Override
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof ClassEndpoint)) {
            this.handleException("Invalid endpoint :" + endpoint.getName());
        }
        this.fac = OMAbstractFactory.getOMFactory();
        ClassEndpoint classEndpoint = (ClassEndpoint)endpoint;
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        this.serializeCommonAttributes(classEndpoint, endpointElement);
        OMElement clazzElement = this.fac.createOMElement("class", SynapseConstants.SYNAPSE_OMNAMESPACE);
        if (classEndpoint.getClassEndpoint() != null && classEndpoint.getClassEndpoint().getClass().getName() != null) {
            clazzElement.addAttribute(this.fac.createOMAttribute("name", SynapseConstants.NULL_NAMESPACE, classEndpoint.getClassEndpoint().getClass().getName()));
        } else {
            this.handleException("Invalid class endpoint. Class name is required");
        }
        this.serializeParameters(classEndpoint, clazzElement);
        endpointElement.addChild((OMNode)clazzElement);
        return endpointElement;
    }

    private void serializeParameters(ClassEndpoint clazzEndpoint, OMElement clazzElement) {
        for (String parameterName : clazzEndpoint.getParameters().keySet()) {
            String value = clazzEndpoint.getParameters().get(parameterName);
            OMElement paramEle = this.fac.createOMElement(PARAMETER_QNAME, (OMContainer)clazzElement);
            paramEle.addAttribute(this.fac.createOMAttribute("name", SynapseConstants.NULL_NAMESPACE, parameterName));
            paramEle.setText(value);
            clazzElement.addChild((OMNode)paramEle);
        }
    }
}

