/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.endpoints.EndpointDefinition;

public class EndpointDefinitionSerializer {
    private OMFactory fac = OMAbstractFactory.getOMFactory();

    public void serializeEndpointDefinition(EndpointDefinition endpointDefinition, OMElement element) {
        OMElement errorCodes;
        if (endpointDefinition.getTraceState() == 1) {
            element.addAttribute(this.fac.createOMAttribute("trace", null, "enable"));
        } else if (endpointDefinition.getTraceState() == 0) {
            element.addAttribute(this.fac.createOMAttribute("trace", null, "disable"));
        }
        AspectConfiguration statisticsConfigurable = endpointDefinition.getAspectConfiguration();
        if (statisticsConfigurable != null && statisticsConfigurable.isStatisticsEnable()) {
            element.addAttribute(this.fac.createOMAttribute("statistics", null, "enable"));
        }
        if (endpointDefinition.isUseSwa()) {
            element.addAttribute(this.fac.createOMAttribute("optimize", null, "swa"));
        } else if (endpointDefinition.isUseMTOM()) {
            element.addAttribute(this.fac.createOMAttribute("optimize", null, "mtom"));
        }
        if (endpointDefinition.getCharSetEncoding() != null) {
            element.addAttribute(this.fac.createOMAttribute("encoding", null, endpointDefinition.getCharSetEncoding()));
        }
        if (endpointDefinition.isAddressingOn()) {
            OMElement addressing = this.fac.createOMElement("enableAddressing", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getAddressingVersion() != null) {
                addressing.addAttribute(this.fac.createOMAttribute("version", null, endpointDefinition.getAddressingVersion()));
            }
            if (endpointDefinition.isUseSeparateListener()) {
                addressing.addAttribute(this.fac.createOMAttribute("separateListener", null, "true"));
            }
            element.addChild((OMNode)addressing);
        }
        if (endpointDefinition.isReliableMessagingOn()) {
            OMElement rm = this.fac.createOMElement("enableRM", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getWsRMPolicyKey() != null) {
                rm.addAttribute(this.fac.createOMAttribute("policy", null, endpointDefinition.getWsRMPolicyKey()));
            }
            element.addChild((OMNode)rm);
        }
        if (endpointDefinition.isSecurityOn()) {
            OMElement sec = this.fac.createOMElement("enableSec", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getWsSecPolicyKey() != null) {
                sec.addAttribute(this.fac.createOMAttribute("policy", null, endpointDefinition.getWsSecPolicyKey()));
            } else {
                if (endpointDefinition.getInboundWsSecPolicyKey() != null) {
                    sec.addAttribute(this.fac.createOMAttribute("inboundPolicy", null, endpointDefinition.getInboundWsSecPolicyKey()));
                }
                if (endpointDefinition.getOutboundWsSecPolicyKey() != null) {
                    sec.addAttribute(this.fac.createOMAttribute("outboundPolicy", null, endpointDefinition.getOutboundWsSecPolicyKey()));
                }
            }
            element.addChild((OMNode)sec);
        }
        if (endpointDefinition.getTimeoutAction() != 100 || endpointDefinition.getTimeoutDuration() > 0L) {
            OMElement timeout = this.fac.createOMElement("timeout", SynapseConstants.SYNAPSE_OMNAMESPACE);
            element.addChild((OMNode)timeout);
            OMElement duration = this.fac.createOMElement("duration", SynapseConstants.SYNAPSE_OMNAMESPACE);
            duration.setText(Long.toString(endpointDefinition.getTimeoutDuration()));
            timeout.addChild((OMNode)duration);
            if (endpointDefinition.getTimeoutAction() != 100) {
                OMElement action = this.fac.createOMElement("responseAction", SynapseConstants.SYNAPSE_OMNAMESPACE);
                if (endpointDefinition.getTimeoutAction() == 101) {
                    action.setText("discard");
                } else if (endpointDefinition.getTimeoutAction() == 102) {
                    action.setText("fault");
                }
                timeout.addChild((OMNode)action);
            }
        }
        if (endpointDefinition.getInitialSuspendDuration() != -1L || !endpointDefinition.getSuspendErrorCodes().isEmpty()) {
            OMElement suspendOnFailure = this.fac.createOMElement("suspendOnFailure", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (!endpointDefinition.getSuspendErrorCodes().isEmpty()) {
                errorCodes = this.fac.createOMElement("errorCodes", SynapseConstants.SYNAPSE_OMNAMESPACE);
                errorCodes.setText(endpointDefinition.getSuspendErrorCodes().toString().replaceAll("[\\[\\] ]", ""));
                suspendOnFailure.addChild((OMNode)errorCodes);
            }
            if (endpointDefinition.getInitialSuspendDuration() != -1L) {
                OMElement initialDuration = this.fac.createOMElement("initialDuration", SynapseConstants.SYNAPSE_OMNAMESPACE);
                initialDuration.setText(Long.toString(endpointDefinition.getInitialSuspendDuration()));
                suspendOnFailure.addChild((OMNode)initialDuration);
            }
            if (endpointDefinition.getSuspendProgressionFactor() != -1.0f) {
                OMElement progressionFactor = this.fac.createOMElement("progressionFactor", SynapseConstants.SYNAPSE_OMNAMESPACE);
                progressionFactor.setText(Float.toString(endpointDefinition.getSuspendProgressionFactor()));
                suspendOnFailure.addChild((OMNode)progressionFactor);
            }
            if (endpointDefinition.getSuspendMaximumDuration() != -1L && endpointDefinition.getSuspendMaximumDuration() != Long.MAX_VALUE) {
                OMElement suspendMaximum = this.fac.createOMElement("maximumDuration", SynapseConstants.SYNAPSE_OMNAMESPACE);
                suspendMaximum.setText(Long.toString(endpointDefinition.getSuspendMaximumDuration()));
                suspendOnFailure.addChild((OMNode)suspendMaximum);
            }
            element.addChild((OMNode)suspendOnFailure);
        }
        if (endpointDefinition.getRetryDurationOnTimeout() > 0 || !endpointDefinition.getTimeoutErrorCodes().isEmpty()) {
            OMElement markAsTimedout = this.fac.createOMElement("markForSuspension", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (!endpointDefinition.getTimeoutErrorCodes().isEmpty()) {
                errorCodes = this.fac.createOMElement("errorCodes", SynapseConstants.SYNAPSE_OMNAMESPACE);
                errorCodes.setText(endpointDefinition.getTimeoutErrorCodes().toString().replaceAll("[\\[\\] ]", ""));
                markAsTimedout.addChild((OMNode)errorCodes);
            }
            if (endpointDefinition.getRetriesOnTimeoutBeforeSuspend() > 0) {
                OMElement retries = this.fac.createOMElement("retriesBeforeSuspension", SynapseConstants.SYNAPSE_OMNAMESPACE);
                retries.setText(Long.toString(endpointDefinition.getRetriesOnTimeoutBeforeSuspend()));
                markAsTimedout.addChild((OMNode)retries);
            }
            if (endpointDefinition.getRetryDurationOnTimeout() > 0) {
                OMElement retryDelay = this.fac.createOMElement("retryDelay", SynapseConstants.SYNAPSE_OMNAMESPACE);
                retryDelay.setText(Long.toString(endpointDefinition.getRetryDurationOnTimeout()));
                markAsTimedout.addChild((OMNode)retryDelay);
            }
            element.addChild((OMNode)markAsTimedout);
        }
        if (!endpointDefinition.getRetryDisabledErrorCodes().isEmpty()) {
            OMElement retryConfig = this.fac.createOMElement("retryConfig", SynapseConstants.SYNAPSE_OMNAMESPACE);
            errorCodes = this.fac.createOMElement("disabledErrorCodes", SynapseConstants.SYNAPSE_OMNAMESPACE);
            errorCodes.setText(endpointDefinition.getRetryDisabledErrorCodes().toString().replaceAll("[\\[\\] ]", ""));
            retryConfig.addChild((OMNode)errorCodes);
            element.addChild((OMNode)retryConfig);
        }
    }
}

