/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.PropertyInclude;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.MediatorPropertySerializer;
import org.apache.synapse.config.xml.endpoints.AddressEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.ClassEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.DynamicLoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.FailoverEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.IndirectEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.LoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.RecipientListEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.ResolvingEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.SALoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.ServiceDynamicLoadbalanceEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.TemplateEndpointSerializer;
import org.apache.synapse.config.xml.endpoints.WSDLEndpointSerializer;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.ClassEndpoint;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.DynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.FailoverEndpoint;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.RecipientListEndpoint;
import org.apache.synapse.endpoints.ResolvingEndpoint;
import org.apache.synapse.endpoints.SALoadbalanceEndpoint;
import org.apache.synapse.endpoints.ServiceDynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.TemplateEndpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.mediators.MediatorProperty;

public abstract class EndpointSerializer {
    private Log log = LogFactory.getLog(this.getClass());
    protected OMFactory fac;

    protected EndpointSerializer() {
    }

    public static OMElement getElementFromEndpoint(Endpoint endpoint) {
        EndpointSerializer endpointSerializer = EndpointSerializer.getEndpointSerializer(endpoint);
        OMElement elem = endpointSerializer.serializeEndpoint(endpoint);
        OMElement descriptionElem = endpointSerializer.getSerializedDescription(endpoint);
        if (descriptionElem != null) {
            elem.addChild((OMNode)descriptionElem);
        }
        return elem;
    }

    protected abstract OMElement serializeEndpoint(Endpoint var1);

    private OMElement getSerializedDescription(Endpoint endpoint) {
        OMElement descriptionElem = this.fac.createOMElement("description", SynapseConstants.SYNAPSE_OMNAMESPACE);
        if (endpoint.getDescription() != null) {
            descriptionElem.setText(endpoint.getDescription());
            return descriptionElem;
        }
        return null;
    }

    protected void serializeSpecificEndpointProperties(EndpointDefinition endpointDefinition, OMElement element) {
    }

    protected void handleException(String message) {
        this.log.error((Object)message);
        throw new SynapseException(message);
    }

    public static EndpointSerializer getEndpointSerializer(Endpoint endpoint) {
        if (endpoint instanceof AddressEndpoint) {
            return new AddressEndpointSerializer();
        }
        if (endpoint instanceof DefaultEndpoint) {
            return new DefaultEndpointSerializer();
        }
        if (endpoint instanceof WSDLEndpoint) {
            return new WSDLEndpointSerializer();
        }
        if (endpoint instanceof IndirectEndpoint) {
            return new IndirectEndpointSerializer();
        }
        if (endpoint instanceof ResolvingEndpoint) {
            return new ResolvingEndpointSerializer();
        }
        if (endpoint instanceof SALoadbalanceEndpoint) {
            return new SALoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof ServiceDynamicLoadbalanceEndpoint) {
            return new ServiceDynamicLoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof DynamicLoadbalanceEndpoint) {
            return new DynamicLoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof LoadbalanceEndpoint) {
            return new LoadbalanceEndpointSerializer();
        }
        if (endpoint instanceof FailoverEndpoint) {
            return new FailoverEndpointSerializer();
        }
        if (endpoint instanceof TemplateEndpoint) {
            return new TemplateEndpointSerializer();
        }
        if (endpoint instanceof RecipientListEndpoint) {
            return new RecipientListEndpointSerializer();
        }
        if (endpoint instanceof ClassEndpoint) {
            return new ClassEndpointSerializer();
        }
        throw new SynapseException("Serializer for endpoint " + endpoint.getClass().toString() + " is not defined.");
    }

    protected void serializeCommonAttributes(Endpoint endpoint, OMElement element) {
        String messageStore;
        String name = endpoint.getName();
        boolean anon = ((AbstractEndpoint)endpoint).isAnonymous();
        if (name != null && !anon) {
            element.addAttribute("name", name, null);
        }
        if ((messageStore = endpoint.getErrorHandler()) != null) {
            element.addAttribute(EndpointFactory.ON_FAULT_Q.getLocalPart(), messageStore, null);
        }
    }

    protected void serializeProperties(PropertyInclude endpoint, OMElement element) {
        Collection<MediatorProperty> properties = endpoint.getProperties();
        if (properties != null && properties.size() > 0) {
            MediatorPropertySerializer.serializeMediatorProperties(element, properties);
        }
    }
}

