/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.TemplateEndpoint;

public class TemplateEndpointFactory
extends EndpointFactory {
    @Override
    public Endpoint createEndpoint(OMElement endpointElement, boolean a, Properties properties) {
        OMAttribute endpointTemplateAttribute;
        OMAttribute endpointURIAttribute;
        TemplateEndpoint templateEndpoint = new TemplateEndpoint();
        OMAttribute endpointNameAttribute = endpointElement.getAttribute(new QName("", "name"));
        if (endpointNameAttribute != null) {
            templateEndpoint.addParameter("name", endpointNameAttribute.getAttributeValue());
            templateEndpoint.setName(endpointNameAttribute.getAttributeValue());
        }
        if ((endpointURIAttribute = endpointElement.getAttribute(new QName("", "uri"))) != null) {
            templateEndpoint.addParameter("uri", endpointURIAttribute.getAttributeValue());
        }
        if ((endpointTemplateAttribute = endpointElement.getAttribute(new QName("", "template"))) != null) {
            templateEndpoint.setTemplate(endpointTemplateAttribute.getAttributeValue());
        } else {
            TemplateEndpointFactory.handleException("Error loading the configuration from endpoint group, " + templateEndpoint.getName() + " template attribute is missing");
        }
        Iterator paramItr = endpointElement.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "parameter"));
        while (paramItr.hasNext()) {
            OMElement paramElement = (OMElement)paramItr.next();
            OMAttribute paramName = paramElement.getAttribute(new QName("name"));
            OMAttribute paramValue = paramElement.getAttribute(new QName("value"));
            if (paramName == null) {
                TemplateEndpointFactory.handleException("parameter name should be present");
            }
            if (paramValue == null) {
                TemplateEndpointFactory.handleException("parameter value should be present");
            }
            assert (paramName != null);
            assert (paramValue != null);
            templateEndpoint.addParameter(paramName.getAttributeValue(), paramValue.getAttributeValue());
        }
        return templateEndpoint;
    }
}

