/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.WSDL20ToAxisServiceBuilder;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.synapse.SynapseArtifact;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.ProxyServiceMessageReceiver;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.PolicyInfo;
import org.apache.synapse.util.resolver.CustomWSDLLocator;
import org.apache.synapse.util.resolver.CustomXmlSchemaURIResolver;
import org.apache.synapse.util.resolver.ResourceMap;
import org.apache.synapse.util.resolver.UserDefinedWSDLLocator;
import org.apache.synapse.util.resolver.UserDefinedXmlSchemaURIResolver;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class ProxyService
implements AspectConfigurable,
SynapseArtifact {
    private static final Log log = LogFactory.getLog(ProxyService.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private final Log serviceLog;
    public static final String ABSOLUTE_SCHEMA_URL_PARAM = "showAbsoluteSchemaURL";
    private String name;
    private String description;
    private ArrayList transports;
    private List pinnedServers = new ArrayList();
    private String targetEndpoint = null;
    private String targetInSequence = null;
    private String targetOutSequence = null;
    private String targetFaultSequence = null;
    private Endpoint targetInLineEndpoint = null;
    private SequenceMediator targetInLineInSequence = null;
    private SequenceMediator targetInLineOutSequence = null;
    private SequenceMediator targetInLineFaultSequence = null;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private String wsdlKey;
    private URI wsdlURI;
    private Object inLineWSDL;
    private ResourceMap resourceMap;
    private List<PolicyInfo> policies = new ArrayList<PolicyInfo>();
    private final List<String> serviceLevelPolicies = new ArrayList<String>();
    private List<String> inMessagePolicies = new ArrayList<String>();
    private List<String> outMessagePolicies = new ArrayList<String>();
    private boolean wsAddrEnabled = false;
    private boolean wsRMEnabled = false;
    private boolean wsSecEnabled = false;
    private boolean startOnLoad = true;
    private boolean running = false;
    public static final String ALL_TRANSPORTS = "all";
    private int traceState = 2;
    private AspectConfiguration aspectConfiguration;
    private String fileName;
    private String serviceGroup;
    private boolean moduleEngaged;
    private boolean wsdlPublished;

    public ProxyService(String name) {
        this.name = name;
        this.serviceLog = LogFactory.getLog((String)("SERVICE_LOGGER." + name));
    }

    public AxisService buildAxisService(SynapseConfiguration synCfg, AxisConfiguration axisCfg) {
        AxisOperation op;
        boolean wsdlFound;
        AxisService proxyService;
        block85: {
            String synapseHome;
            this.auditInfo("Building Axis service for Proxy service : " + this.name);
            proxyService = null;
            if (this.trace()) {
                trace.info((Object)("Loading the WSDL : " + (this.wsdlKey != null ? " key = " + this.wsdlKey : (this.wsdlURI != null ? " URI = " + this.wsdlURI : " <Inlined>"))));
            }
            ByteArrayInputStream wsdlInputStream = null;
            OMElement wsdlElement = null;
            wsdlFound = false;
            String publishWSDL = null;
            SynapseEnvironment synEnv = SynapseConfigUtils.getSynapseEnvironment(axisCfg);
            String string = synapseHome = synEnv != null ? synEnv.getServerContextInformation().getServerConfigurationInformation().getSynapseHome() : "";
            if (this.wsdlKey != null) {
                synCfg.getEntryDefinition(this.wsdlKey);
                Object keyObject = synCfg.getEntry(this.wsdlKey);
                if (keyObject instanceof OMElement) {
                    wsdlElement = (OMElement)keyObject;
                }
                wsdlFound = true;
            } else if (this.inLineWSDL != null) {
                wsdlElement = (OMElement)this.inLineWSDL;
                wsdlFound = true;
            } else if (this.wsdlURI != null) {
                try {
                    URL url = this.wsdlURI.toURL();
                    publishWSDL = url.toString();
                    OMNode node = SynapseConfigUtils.getOMElementFromURL(publishWSDL, synapseHome);
                    if (node instanceof OMElement) {
                        wsdlElement = (OMElement)node;
                    }
                    wsdlFound = true;
                }
                catch (MalformedURLException e) {
                    this.handleException("Malformed URI for wsdl", e);
                }
                catch (IOException e) {
                    boolean enablePublishWSDLSafeMode = false;
                    Map<String, Object> proxyParameters = this.getParameterMap();
                    if (!proxyParameters.isEmpty()) {
                        if (proxyParameters.containsKey("enablePublishWSDLSafeMode")) {
                            enablePublishWSDLSafeMode = Boolean.parseBoolean(proxyParameters.get("enablePublishWSDLSafeMode").toString().toLowerCase());
                        } else {
                            if (this.trace()) {
                                trace.info((Object)("WSDL was unable to load for: " + publishWSDL));
                                trace.info((Object)"Please add <syn:parameter name=\"enableURISafeMode\">true</syn:parameter> to proxy service.");
                            }
                            this.handleException("Error reading from wsdl URI", e);
                        }
                    }
                    if (enablePublishWSDLSafeMode) {
                        if (this.trace()) {
                            trace.info((Object)("WSDL was unable to load for: " + publishWSDL));
                            trace.info((Object)"enableURISafeMode: true");
                        }
                        log.warn((Object)("Unable to load the WSDL for : " + this.name), (Throwable)e);
                        return null;
                    }
                    if (this.trace()) {
                        trace.info((Object)("WSDL was unable to load for: " + publishWSDL));
                        trace.info((Object)"enableURISafeMode: false");
                    }
                    this.handleException("Error reading from wsdl URI", e);
                }
            } else {
                if (this.trace()) {
                    trace.info((Object)"Did not find a WSDL. Assuming a POX or Legacy service");
                }
                proxyService = new AxisService();
                InOutAxisOperation mediateOperation = new InOutAxisOperation(SynapseConstants.SYNAPSE_OPERATION_NAME);
                mediateOperation.getMessage("In").setName("in");
                mediateOperation.getMessage("Out").setName("out");
                proxyService.addOperation((AxisOperation)mediateOperation);
            }
            if (wsdlElement != null) {
                OMNamespace wsdlNamespace = wsdlElement.getNamespace();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    if (this.trace()) {
                        trace.info((Object)"Serializing wsdlElement found to build an Axis2 service");
                    }
                    wsdlElement.serialize((OutputStream)baos);
                    wsdlInputStream = new ByteArrayInputStream(baos.toByteArray());
                }
                catch (XMLStreamException e) {
                    this.handleException("Error converting to a StreamSource", e);
                }
                if (wsdlInputStream != null) {
                    try {
                        if (this.trace()) {
                            trace.info((Object)("WSDL Namespace is : " + wsdlNamespace.getNamespaceURI()));
                        }
                        if (wsdlNamespace != null) {
                            WSDL20ToAxisServiceBuilder wsdlToAxisServiceBuilder = null;
                            if ("http://www.w3.org/ns/wsdl".equals(wsdlNamespace.getNamespaceURI())) {
                                wsdlToAxisServiceBuilder = new WSDL20ToAxisServiceBuilder((InputStream)wsdlInputStream, null, null);
                            } else if ("http://schemas.xmlsoap.org/wsdl/".equals(wsdlNamespace.getNamespaceURI())) {
                                wsdlToAxisServiceBuilder = new WSDL11ToAxisServiceBuilder((InputStream)wsdlInputStream);
                            } else {
                                this.handleException("Unknown WSDL format.. not WSDL 1.1 or WSDL 2.0");
                            }
                            if (wsdlToAxisServiceBuilder == null) {
                                throw new SynapseException("Could not get the WSDL to Axis Service Builder");
                            }
                            wsdlToAxisServiceBuilder.setBaseUri(this.wsdlURI != null ? this.wsdlURI.toString() : synapseHome);
                            if (this.trace()) {
                                trace.info((Object)"Setting up custom resolvers");
                            }
                            if (synCfg.getProperty("synapse.wsdl.resolver") != null && synCfg.getProperty("synapse.schema.resolver") != null) {
                                this.setUserDefinedResourceResolvers(synCfg, wsdlInputStream, (WSDLToAxisServiceBuilder)wsdlToAxisServiceBuilder);
                            } else if (this.resourceMap != null) {
                                wsdlToAxisServiceBuilder.setCustomResolver((URIResolver)new CustomXmlSchemaURIResolver(this.resourceMap, synCfg));
                                if (wsdlToAxisServiceBuilder instanceof WSDL11ToAxisServiceBuilder) {
                                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setCustomWSDLResolver((WSDLLocator)new CustomWSDLLocator(new InputSource(wsdlInputStream), this.wsdlURI != null ? this.wsdlURI.toString() : "", this.resourceMap, synCfg));
                                }
                            } else {
                                wsdlToAxisServiceBuilder.setCustomResolver((URIResolver)new CustomXmlSchemaURIResolver());
                                if (wsdlToAxisServiceBuilder instanceof WSDL11ToAxisServiceBuilder) {
                                    ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setCustomWSDLResolver((WSDLLocator)new CustomWSDLLocator(new InputSource(wsdlInputStream), this.wsdlURI != null ? this.wsdlURI.toString() : ""));
                                }
                            }
                            if (this.trace()) {
                                trace.info((Object)"Populating Axis2 service using WSDL");
                                if (trace.isTraceEnabled()) {
                                    trace.trace((Object)("WSDL : " + wsdlElement.toString()));
                                }
                            }
                            proxyService = wsdlToAxisServiceBuilder.populateService();
                            proxyService.getEndpoints().clear();
                            break block85;
                        }
                        this.handleException("Unknown WSDL format.. not WSDL 1.1 or WSDL 2.0");
                    }
                    catch (AxisFault af) {
                        this.handleException("Error building service from WSDL", (Exception)((Object)af));
                    }
                    catch (IOException ioe) {
                        this.handleException("Error reading WSDL", ioe);
                    }
                }
            } else if (wsdlFound) {
                this.handleException("Couldn't build the proxy service : " + this.name + ". Unable to locate the specified WSDL to build the service");
            }
        }
        if (proxyService == null) {
            throw new SynapseException("Could not create a proxy service");
        }
        proxyService.setName(this.name);
        if (this.description != null) {
            proxyService.setDocumentation(this.description);
        }
        if (this.transports != null && this.transports.size() != 0) {
            if (this.trace()) {
                trace.info((Object)("Exposing transports : " + this.transports));
            }
            proxyService.setExposedTransports((List)this.transports);
        }
        if (this.trace() && this.parameters.size() > 0) {
            trace.info((Object)("Setting service parameters : " + this.parameters));
        }
        Iterator<Object> i$ = this.parameters.keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String name = o = i$.next();
            Object value = this.parameters.get(name);
            Parameter p = new Parameter();
            p.setName(name);
            p.setValue(value);
            try {
                proxyService.addParameter(p);
            }
            catch (AxisFault af) {
                this.handleException("Error setting parameter : " + name + "" + "to proxy service as a Parameter", (Exception)((Object)af));
            }
        }
        if (JavaUtils.isTrueExplicitly((Object)proxyService.getParameterValue(ABSOLUTE_SCHEMA_URL_PARAM))) {
            proxyService.setCustomSchemaNamePrefix("");
        }
        if (!this.policies.isEmpty()) {
            for (PolicyInfo pi : this.policies) {
                if (this.getPolicyFromKey(pi.getPolicyKey(), synCfg) == null) {
                    this.handleException("Cannot find Policy from the key");
                }
                if (pi.isServicePolicy()) {
                    proxyService.getPolicySubject().attachPolicy(this.getPolicyFromKey(pi.getPolicyKey(), synCfg));
                    continue;
                }
                if (pi.isOperationPolicy()) {
                    op = proxyService.getOperation(pi.getOperation());
                    if (op != null) {
                        op.getPolicySubject().attachPolicy(this.getPolicyFromKey(pi.getPolicyKey(), synCfg));
                        continue;
                    }
                    this.handleException("Couldn't find the operation specified by the QName : " + pi.getOperation());
                    continue;
                }
                if (pi.isMessagePolicy()) {
                    if (pi.getOperation() != null) {
                        op = proxyService.getOperation(pi.getOperation());
                        if (op != null) {
                            op.getMessage(pi.getMessageLable()).getPolicySubject().attachPolicy(this.getPolicyFromKey(pi.getPolicyKey(), synCfg));
                            continue;
                        }
                        this.handleException("Couldn't find the operation specified by the QName : " + pi.getOperation());
                        continue;
                    }
                    Iterator itr = proxyService.getOperations();
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        if (!(obj instanceof AxisOperation) || obj instanceof OutOnlyAxisOperation && pi.getType() == 1 || obj instanceof InOnlyAxisOperation && pi.getType() == 2) continue;
                        AxisMessage message = ((AxisOperation)obj).getMessage(pi.getMessageLable());
                        message.getPolicySubject().attachPolicy(this.getPolicyFromKey(pi.getPolicyKey(), synCfg));
                    }
                    continue;
                }
                this.handleException("Undefined Policy type");
            }
        }
        ProxyServiceMessageReceiver msgRcvr = new ProxyServiceMessageReceiver();
        msgRcvr.setName(this.name);
        msgRcvr.setProxy(this);
        Iterator iter = proxyService.getOperations();
        while (iter.hasNext()) {
            op = (AxisOperation)iter.next();
            op.setMessageReceiver((MessageReceiver)msgRcvr);
        }
        try {
            proxyService.addParameter("serviceType", (Object)"proxy");
            if (this.serviceGroup == null) {
                this.auditInfo("Adding service " + this.name + " to the Axis2 configuration");
                axisCfg.addService(proxyService);
            } else {
                this.auditInfo("Adding service " + this.name + " to the service group " + this.serviceGroup);
                if (axisCfg.getServiceGroup(this.serviceGroup) == null) {
                    AxisServiceGroup proxyServiceGroup = new AxisServiceGroup();
                    proxyServiceGroup.setServiceGroupName(this.serviceGroup);
                    proxyServiceGroup.setParent((AxisDescription)axisCfg);
                    proxyServiceGroup.addService(proxyService);
                    axisCfg.addServiceGroup(proxyServiceGroup);
                } else {
                    proxyService.setParent(axisCfg.getServiceGroup(this.serviceGroup));
                    axisCfg.addServiceToExistingServiceGroup(proxyService, this.serviceGroup);
                }
            }
            this.setRunning(true);
        }
        catch (AxisFault axisFault) {
            try {
                if (axisCfg.getService(proxyService.getName()) != null) {
                    if (this.trace()) {
                        trace.info((Object)("Removing service " + this.name + " due to error : " + axisFault.getMessage()));
                    }
                    axisCfg.removeService(proxyService.getName());
                }
            }
            catch (AxisFault ignore) {
                // empty catch block
            }
            this.handleException("Error adding Proxy service to the Axis2 engine", (Exception)((Object)axisFault));
        }
        if (this.wsAddrEnabled) {
            this.auditInfo("WS-Addressing is enabled for service : " + this.name);
            try {
                proxyService.engageModule(axisCfg.getModule("addressing"), (AxisDescription)axisCfg);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error loading WS Addressing module on proxy service : " + this.name, (Exception)((Object)axisFault));
            }
        }
        if (this.wsRMEnabled) {
            this.auditInfo("WS-Reliable messaging is enabled for service : " + this.name);
            try {
                proxyService.engageModule(axisCfg.getModule("sandesha2"), (AxisDescription)axisCfg);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error loading WS RM module on proxy service : " + this.name, (Exception)((Object)axisFault));
            }
        }
        if (this.wsSecEnabled) {
            this.auditInfo("WS-Security is enabled for service : " + this.name);
            try {
                proxyService.engageModule(axisCfg.getModule("rampart"), (AxisDescription)axisCfg);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error loading WS Sec module on proxy service : " + this.name, (Exception)((Object)axisFault));
            }
        }
        this.moduleEngaged = this.wsSecEnabled || this.wsRMEnabled || this.wsAddrEnabled;
        this.wsdlPublished = wsdlFound;
        this.auditInfo("Successfully created the Axis2 service for Proxy service : " + this.name);
        return proxyService;
    }

    private void setUserDefinedResourceResolvers(SynapseConfiguration synCfg, InputStream wsdlInputStream, WSDLToAxisServiceBuilder wsdlToAxisServiceBuilder) {
        Object schemaClazzObject;
        Object wsdlClzzObject;
        Class<?> schemaClazz;
        Class<?> wsdlClazz;
        String wsdlResolverName = synCfg.getProperty("synapse.wsdl.resolver");
        String schemaResolverName = synCfg.getProperty("synapse.schema.resolver");
        try {
            wsdlClazz = Class.forName(wsdlResolverName);
            schemaClazz = Class.forName(schemaResolverName);
        }
        catch (ClassNotFoundException e) {
            String msg = "System could not find the class defined for the specific properties \n WSDLResolverImplementation:" + wsdlResolverName + "\n SchemaResolverImplementation:" + schemaResolverName;
            this.handleException(msg, e);
            return;
        }
        try {
            wsdlClzzObject = wsdlClazz.newInstance();
            schemaClazzObject = schemaClazz.newInstance();
        }
        catch (Exception e) {
            String msg = "Could not create an instance from the class";
            this.handleException(msg, e);
            return;
        }
        UserDefinedXmlSchemaURIResolver userDefSchemaResolver = (UserDefinedXmlSchemaURIResolver)schemaClazzObject;
        userDefSchemaResolver.init(this.resourceMap, synCfg, this.wsdlKey);
        wsdlToAxisServiceBuilder.setCustomResolver((URIResolver)userDefSchemaResolver);
        if (wsdlToAxisServiceBuilder instanceof WSDL11ToAxisServiceBuilder) {
            UserDefinedWSDLLocator userDefWSDLLocator = (UserDefinedWSDLLocator)wsdlClzzObject;
            userDefWSDLLocator.init(new InputSource(wsdlInputStream), this.wsdlURI != null ? this.wsdlURI.toString() : "", this.resourceMap, synCfg, this.wsdlKey);
            ((WSDL11ToAxisServiceBuilder)wsdlToAxisServiceBuilder).setCustomWSDLResolver((WSDLLocator)userDefWSDLLocator);
        }
    }

    private Policy getPolicyFromKey(String key, SynapseConfiguration synCfg) {
        synCfg.getEntryDefinition(key);
        return PolicyEngine.getPolicy((InputStream)SynapseConfigUtils.getStreamSource(synCfg.getEntry(key)).getInputStream());
    }

    public void start(SynapseConfiguration synCfg) {
        AxisConfiguration axisConfig = synCfg.getAxisConfiguration();
        if (axisConfig != null) {
            Parameter param = axisConfig.getParameter("synapse.env");
            if (param != null && param.getValue() instanceof SynapseEnvironment) {
                SynapseEnvironment env = (SynapseEnvironment)param.getValue();
                if (this.targetInLineInSequence != null) {
                    this.targetInLineInSequence.init(env);
                }
                if (this.targetInLineOutSequence != null) {
                    this.targetInLineOutSequence.init(env);
                }
                if (this.targetInLineFaultSequence != null) {
                    this.targetInLineFaultSequence.init(env);
                }
            } else {
                this.auditWarn("Unable to find the SynapseEnvironment. Components of the proxy service may not be initialized");
            }
            AxisService as = axisConfig.getServiceForActivation(this.getName());
            as.setActive(true);
            axisConfig.notifyObservers(new AxisEvent(3, (AxisDescription)as), as);
            this.setRunning(true);
            this.auditInfo("Started the proxy service : " + this.name);
        } else {
            this.auditWarn("Unable to start proxy service : " + this.name + ". Couldn't access Axis configuration");
        }
    }

    public void stop(SynapseConfiguration synCfg) {
        AxisConfiguration axisConfig = synCfg.getAxisConfiguration();
        if (axisConfig != null) {
            AxisService as;
            if (this.targetInLineInSequence != null) {
                this.targetInLineInSequence.destroy();
            }
            if (this.targetInLineOutSequence != null) {
                this.targetInLineOutSequence.destroy();
            }
            if (this.targetInLineFaultSequence != null) {
                this.targetInLineFaultSequence.destroy();
            }
            if ((as = axisConfig.getServiceForActivation(this.getName())) != null && as.isActive()) {
                as.setActive(false);
                axisConfig.notifyObservers(new AxisEvent(2, (AxisDescription)as), as);
            }
            this.setRunning(false);
            this.auditInfo("Stopped the proxy service : " + this.name);
        } else {
            this.auditWarn("Unable to stop proxy service : " + this.name + ". Couldn't access Axis configuration");
        }
    }

    private void handleException(String msg) {
        this.serviceLog.error((Object)msg);
        log.error((Object)msg);
        if (this.trace()) {
            trace.error((Object)msg);
        }
        throw new SynapseException(msg);
    }

    private void handleException(String msg, Exception e) {
        this.serviceLog.error((Object)msg);
        log.error((Object)msg, (Throwable)e);
        if (this.trace()) {
            trace.error((Object)(msg + " :: " + e.getMessage()));
        }
        throw new SynapseException(msg, e);
    }

    private void auditInfo(String message) {
        log.info((Object)message);
        this.serviceLog.info((Object)message);
        if (this.trace()) {
            trace.info((Object)message);
        }
    }

    private void auditWarn(String message) {
        log.warn((Object)message);
        this.serviceLog.warn((Object)message);
        if (this.trace()) {
            trace.warn((Object)message);
        }
    }

    private boolean trace() {
        return this.traceState == 1;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList getTransports() {
        return this.transports;
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Map<String, Object> getParameterMap() {
        return this.parameters;
    }

    public void setTransports(ArrayList transports) {
        this.transports = transports;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }

    public String getTargetInSequence() {
        return this.targetInSequence;
    }

    public void setTargetInSequence(String targetInSequence) {
        this.targetInSequence = targetInSequence;
    }

    public String getTargetOutSequence() {
        return this.targetOutSequence;
    }

    public void setTargetOutSequence(String targetOutSequence) {
        this.targetOutSequence = targetOutSequence;
    }

    public String getWSDLKey() {
        return this.wsdlKey;
    }

    public void setWSDLKey(String wsdlKey) {
        this.wsdlKey = wsdlKey;
    }

    public List<String> getServiceLevelPolicies() {
        return this.serviceLevelPolicies;
    }

    public void addServiceLevelPolicy(String serviceLevelPolicy) {
        this.serviceLevelPolicies.add(serviceLevelPolicy);
    }

    public boolean isWsAddrEnabled() {
        return this.wsAddrEnabled;
    }

    public void setWsAddrEnabled(boolean wsAddrEnabled) {
        this.wsAddrEnabled = wsAddrEnabled;
    }

    public boolean isWsRMEnabled() {
        return this.wsRMEnabled;
    }

    public void setWsRMEnabled(boolean wsRMEnabled) {
        this.wsRMEnabled = wsRMEnabled;
    }

    public boolean isWsSecEnabled() {
        return this.wsSecEnabled;
    }

    public void setWsSecEnabled(boolean wsSecEnabled) {
        this.wsSecEnabled = wsSecEnabled;
    }

    public boolean isStartOnLoad() {
        return this.startOnLoad;
    }

    public void setStartOnLoad(boolean startOnLoad) {
        this.startOnLoad = startOnLoad;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public int getTraceState() {
        return this.traceState;
    }

    public void setTraceState(int traceState) {
        this.traceState = traceState;
    }

    public String getTargetFaultSequence() {
        return this.targetFaultSequence;
    }

    public void setTargetFaultSequence(String targetFaultSequence) {
        this.targetFaultSequence = targetFaultSequence;
    }

    public Object getInLineWSDL() {
        return this.inLineWSDL;
    }

    public void setInLineWSDL(Object inLineWSDL) {
        this.inLineWSDL = inLineWSDL;
    }

    public URI getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(URI wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public Endpoint getTargetInLineEndpoint() {
        return this.targetInLineEndpoint;
    }

    public void setTargetInLineEndpoint(Endpoint targetInLineEndpoint) {
        this.targetInLineEndpoint = targetInLineEndpoint;
    }

    public SequenceMediator getTargetInLineInSequence() {
        return this.targetInLineInSequence;
    }

    public void setTargetInLineInSequence(SequenceMediator targetInLineInSequence) {
        this.targetInLineInSequence = targetInLineInSequence;
    }

    public SequenceMediator getTargetInLineOutSequence() {
        return this.targetInLineOutSequence;
    }

    public void setTargetInLineOutSequence(SequenceMediator targetInLineOutSequence) {
        this.targetInLineOutSequence = targetInLineOutSequence;
    }

    public SequenceMediator getTargetInLineFaultSequence() {
        return this.targetInLineFaultSequence;
    }

    public void setTargetInLineFaultSequence(SequenceMediator targetInLineFaultSequence) {
        this.targetInLineFaultSequence = targetInLineFaultSequence;
    }

    public List getPinnedServers() {
        return this.pinnedServers;
    }

    public void setPinnedServers(List pinnedServers) {
        this.pinnedServers = pinnedServers;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(ResourceMap resourceMap) {
        this.resourceMap = resourceMap;
    }

    public List<String> getInMessagePolicies() {
        return this.inMessagePolicies;
    }

    public void setInMessagePolicies(List<String> inMessagePolicies) {
        this.inMessagePolicies = inMessagePolicies;
    }

    public void addInMessagePolicy(String messagePolicy) {
        this.inMessagePolicies.add(messagePolicy);
    }

    public List<String> getOutMessagePolicies() {
        return this.outMessagePolicies;
    }

    public void setOutMessagePolicies(List<String> outMessagePolicies) {
        this.outMessagePolicies = outMessagePolicies;
    }

    public void addOutMessagePolicy(String messagePolicy) {
        this.outMessagePolicies.add(messagePolicy);
    }

    public List<PolicyInfo> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<PolicyInfo> policies) {
        this.policies = policies;
    }

    public void addPolicyInfo(PolicyInfo pi) {
        this.policies.add(pi);
    }

    @Override
    public void configure(AspectConfiguration aspectConfiguration) {
        this.aspectConfiguration = aspectConfiguration;
    }

    @Override
    public AspectConfiguration getAspectConfiguration() {
        return this.aspectConfiguration;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getServiceGroup() {
        return this.serviceGroup;
    }

    public void setServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    public boolean isModuleEngaged() {
        return this.moduleEngaged;
    }

    public void setModuleEngaged(boolean moduleEngaged) {
        this.moduleEngaged = moduleEngaged;
    }

    public boolean isWsdlPublished() {
        return this.wsdlPublished;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ Proxy Service [ Name : ").append(this.name).append(" ] ]");
        return sb.toString();
    }
}

