/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;

public class ClassEndpoint
extends AbstractEndpoint {
    private final Map<String, String> parameters = new HashMap<String, String>();
    private Endpoint classEndpoint;

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setClassEndpoint(Endpoint classEndpoint) {
        this.classEndpoint = classEndpoint;
    }

    public Endpoint getClassEndpoint() {
        return this.classEndpoint;
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initiate the synapse environment of the class endpoint");
        }
        try {
            this.classEndpoint.init(synapseEnvironment);
        }
        catch (Exception e) {
            throw new SynapseException("Error occured when initiate the class endpoint", e);
        }
    }

    @Override
    public void send(MessageContext synMessageContext) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Start sending message");
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Message : " + synMessageContext.getEnvelope()));
            }
        }
        try {
            this.classEndpoint.send(synMessageContext);
        }
        catch (Exception e) {
            throw new SynapseException("Error occured when execute the class endpoint", e);
        }
    }
}

