/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.axis2.transport.base.MessageLevelMetricsCollector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointViewMBean;

public class EndpointView
implements EndpointViewMBean,
MessageLevelMetricsCollector {
    private static final Log log = LogFactory.getLog(EndpointView.class);
    private static final Long ONE = 1L;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(20, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "endpoint-jmx-stat-collector");
        }
    });
    private String endpointName = null;
    private Endpoint endpoint = null;
    private long messagesReceived;
    private long faultsReceiving;
    private long timeoutsReceiving;
    private long bytesReceived;
    private long minSizeReceived;
    private long maxSizeReceived;
    private double avgSizeReceived;
    private final Map<Integer, Long> receivingFaultTable = Collections.synchronizedMap(new HashMap());
    private long messagesSent;
    private long faultsSending;
    private long timeoutsSending;
    private long bytesSent;
    private long minSizeSent;
    private long maxSizeSent;
    private double avgSizeSent;
    private int consecutiveSuspensions;
    private int consecutiveTimeouts;
    private int totalSuspensions;
    private int totalTimeouts;
    private AtomicInteger suspensions = new AtomicInteger(0);
    private AtomicInteger timeouts = new AtomicInteger(0);
    private Date suspendedAt;
    private Date timedoutAt;
    private final Map<Integer, Long> sendingFaultTable = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Long> responseCodeTable = Collections.synchronizedMap(new HashMap());
    private long lastResetTime = System.currentTimeMillis();
    private ScheduledFuture future;
    private Queue<Integer> suspensionCounts = new LinkedList<Integer>();
    private Queue<Integer> timeoutCounts = new LinkedList<Integer>();

    public EndpointView(String endpointName, Endpoint endpoint) {
        this.endpointName = endpointName;
        this.endpoint = endpoint;
        this.future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (EndpointView.this.suspensionCounts.size() == 15) {
                    EndpointView.this.suspensionCounts.remove();
                }
                EndpointView.this.suspensionCounts.offer(EndpointView.this.suspensions.getAndSet(0));
                if (EndpointView.this.timeoutCounts.size() == 15) {
                    EndpointView.this.timeoutCounts.remove();
                }
                EndpointView.this.timeoutCounts.offer(EndpointView.this.timeouts.getAndSet(0));
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public void destroy() {
        this.future.cancel(true);
    }

    @Override
    public void switchOn() throws Exception {
        if (this.endpoint.getChildren() != null) {
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                e.getMetricsMBean().switchOn();
            }
        } else if (this.endpoint.getContext() != null) {
            this.endpoint.getContext().switchOn();
        }
    }

    @Override
    public void switchOff() throws Exception {
        if (this.endpoint.getChildren() != null) {
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                e.getMetricsMBean().switchOff();
            }
        } else if (this.endpoint.getContext() != null) {
            this.endpoint.getContext().switchOff();
        }
    }

    @Override
    public boolean isActive() throws Exception {
        if (this.endpoint.getChildren() != null) {
            return this.getActiveChildren() > 0;
        }
        if (this.endpoint.getContext() != null) {
            return this.endpoint.getContext().isState(1);
        }
        return false;
    }

    @Override
    public boolean isTimedout() throws Exception {
        return this.isEndpointInState(2);
    }

    @Override
    public boolean isSuspended() throws Exception {
        return this.isEndpointInState(3);
    }

    @Override
    public boolean isSwitchedOff() throws Exception {
        return this.isEndpointInState(4);
    }

    @Override
    public int getTotalChildren() throws Exception {
        return this.endpoint.getChildren() == null ? 0 : this.endpoint.getChildren().size();
    }

    @Override
    public int getActiveChildren() throws Exception {
        if (this.endpoint.getChildren() == null) {
            return 0;
        }
        int activeCount = 0;
        for (Endpoint e : this.endpoint.getChildren()) {
            if (!e.getContext().isState(1)) continue;
            ++activeCount;
        }
        return activeCount;
    }

    @Override
    public int getReadyChildren() throws Exception {
        if (this.endpoint.getChildren() == null) {
            return 0;
        }
        int readyCount = 0;
        for (Endpoint e : this.endpoint.getChildren()) {
            if (!e.getContext().readyToSend()) continue;
            ++readyCount;
        }
        return readyCount;
    }

    @Override
    public long getLastResetTime() {
        return this.endpoint.getChildren() != null ? -1L : this.lastResetTime;
    }

    @Override
    public long getMetricsWindow() {
        return this.endpoint.getChildren() != null ? -1L : System.currentTimeMillis() - this.lastResetTime;
    }

    @Override
    public Map<Integer, Long> getReceivingFaultTable() {
        if (this.endpoint.getChildren() != null) {
            HashMap<Integer, Long> receivingFaultTable = new HashMap<Integer, Long>();
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                EndpointView.addTableMaps(receivingFaultTable, e.getMetricsMBean().getReceivingFaultTable());
            }
            EndpointView.addTableMaps(receivingFaultTable, this.receivingFaultTable);
            return receivingFaultTable;
        }
        return this.receivingFaultTable;
    }

    @Override
    public Map<Integer, Long> getSendingFaultTable() {
        if (this.endpoint.getChildren() != null) {
            HashMap<Integer, Long> sendingFaultTable = new HashMap<Integer, Long>();
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                EndpointView.addTableMaps(sendingFaultTable, e.getMetricsMBean().getSendingFaultTable());
            }
            EndpointView.addTableMaps(sendingFaultTable, this.sendingFaultTable);
            return sendingFaultTable;
        }
        return this.sendingFaultTable;
    }

    @Override
    public Map<Integer, Long> getResponseCodeTable() {
        if (this.endpoint.getChildren() != null) {
            HashMap<Integer, Long> responseCodeTable = new HashMap<Integer, Long>();
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                EndpointView.addTableMaps(responseCodeTable, e.getMetricsMBean().getResponseCodeTable());
            }
            return responseCodeTable;
        }
        return this.responseCodeTable;
    }

    @Override
    public Date getSuspendedAt() {
        return this.suspendedAt;
    }

    public void setSuspendedAt(Date suspendedAt) {
        this.suspendedAt = suspendedAt;
    }

    @Override
    public Date getTimedoutAt() {
        return this.timedoutAt;
    }

    public void setTimedoutAt(Date timedoutAt) {
        this.timedoutAt = timedoutAt;
    }

    @Override
    public int getConsecutiveEndpointSuspensions() {
        return this.consecutiveSuspensions;
    }

    public void incrementSuspensions() {
        ++this.consecutiveSuspensions;
        ++this.totalSuspensions;
        this.suspensions.incrementAndGet();
    }

    public void resetConsecutiveSuspensions() {
        this.consecutiveSuspensions = 0;
    }

    @Override
    public int getConsecutiveEndpointTimeouts() {
        return this.consecutiveTimeouts;
    }

    public void incrementTimeouts() {
        ++this.consecutiveTimeouts;
        ++this.totalTimeouts;
        this.timeouts.incrementAndGet();
    }

    public void resetConsecutiveTimeouts() {
        this.consecutiveTimeouts = 0;
    }

    @Override
    public int getTotalEndpointSuspensions() {
        return this.totalSuspensions;
    }

    @Override
    public int getTotalEndpointTimeouts() {
        return this.totalTimeouts;
    }

    @Override
    public int getLastMinuteEndpointSuspensions() {
        return this.getTotal(this.suspensionCounts, 1);
    }

    @Override
    public int getLast5MinuteEndpointSuspensions() {
        return this.getTotal(this.suspensionCounts, 5);
    }

    @Override
    public int getLast15MinuteEndpointSuspensions() {
        return this.getTotal(this.suspensionCounts, 15);
    }

    @Override
    public int getLastMinuteEndpointTimeouts() {
        return this.getTotal(this.timeoutCounts, 1);
    }

    @Override
    public int getLast5MinuteEndpointTimeouts() {
        return this.getTotal(this.timeoutCounts, 5);
    }

    @Override
    public int getLast15MinuteEndpointTimeouts() {
        return this.getTotal(this.timeoutCounts, 15);
    }

    private int getTotal(Queue<Integer> queue, int count) {
        int sum = 0;
        Integer[] array = queue.toArray(new Integer[queue.size()]);
        if (count > array.length) {
            for (int i = 0; i < array.length; ++i) {
                sum += array[i].intValue();
            }
        } else {
            for (int i = 0; i < count; ++i) {
                sum += array[array.length - 1 - i].intValue();
            }
        }
        return sum;
    }

    @Override
    public long getMessagesReceived() {
        if (this.endpoint.getChildren() != null) {
            long messagesReceived = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                messagesReceived += e.getMetricsMBean().getMessagesReceived();
            }
            return messagesReceived;
        }
        return this.messagesReceived;
    }

    @Override
    public long getFaultsReceiving() {
        if (this.endpoint.getChildren() != null) {
            long faultsReceiving = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                faultsReceiving += e.getMetricsMBean().getFaultsReceiving();
            }
            return faultsReceiving;
        }
        return this.faultsReceiving;
    }

    @Override
    public long getTimeoutsReceiving() {
        if (this.endpoint.getChildren() != null) {
            long timeoutsReceiving = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                timeoutsReceiving += e.getMetricsMBean().getTimeoutsReceiving();
            }
            return timeoutsReceiving;
        }
        return this.timeoutsReceiving;
    }

    @Override
    public long getBytesReceived() {
        if (this.endpoint.getChildren() != null) {
            long bytesReceived = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                bytesReceived += e.getMetricsMBean().getBytesReceived();
            }
            return bytesReceived;
        }
        return this.bytesReceived;
    }

    @Override
    public long getMessagesSent() {
        if (this.endpoint.getChildren() != null) {
            long messagesSent = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                messagesSent += e.getMetricsMBean().getMessagesSent();
            }
            return messagesSent;
        }
        return this.messagesSent;
    }

    @Override
    public long getFaultsSending() {
        if (this.endpoint.getChildren() != null) {
            long faultsSending = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                faultsSending += e.getMetricsMBean().getFaultsSending();
            }
            return faultsSending;
        }
        return this.faultsSending;
    }

    @Override
    public long getTimeoutsSending() {
        if (this.endpoint.getChildren() != null) {
            long timeoutsSending = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                timeoutsSending += e.getMetricsMBean().getTimeoutsSending();
            }
            return timeoutsSending;
        }
        return this.timeoutsSending;
    }

    @Override
    public long getBytesSent() {
        if (this.endpoint.getChildren() != null) {
            long bytesSent = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                bytesSent += e.getMetricsMBean().getBytesSent();
            }
            return bytesSent;
        }
        return this.bytesSent;
    }

    @Override
    public long getMinSizeReceived() {
        if (this.endpoint.getChildren() != null) {
            long minSizeReceived = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                if (minSizeReceived == 0L) {
                    minSizeReceived = e.getMetricsMBean().getMinSizeReceived();
                    continue;
                }
                if (e.getMetricsMBean().getMinSizeReceived() >= minSizeReceived) continue;
                minSizeReceived = e.getMetricsMBean().getMinSizeReceived();
            }
            return minSizeReceived;
        }
        return this.minSizeReceived;
    }

    @Override
    public long getMaxSizeReceived() {
        if (this.endpoint.getChildren() != null) {
            long maxSizeReceived = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                if (maxSizeReceived == 0L) {
                    maxSizeReceived = e.getMetricsMBean().getMaxSizeReceived();
                    continue;
                }
                if (e.getMetricsMBean().getMaxSizeReceived() <= maxSizeReceived) continue;
                maxSizeReceived = e.getMetricsMBean().getMaxSizeReceived();
            }
            return maxSizeReceived;
        }
        return this.maxSizeReceived;
    }

    @Override
    public long getMinSizeSent() {
        if (this.endpoint.getChildren() != null) {
            long minSizeSent = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                if (minSizeSent == 0L) {
                    minSizeSent = e.getMetricsMBean().getMinSizeSent();
                    continue;
                }
                if (e.getMetricsMBean().getMinSizeSent() >= minSizeSent) continue;
                minSizeSent = e.getMetricsMBean().getMinSizeSent();
            }
            return minSizeSent;
        }
        return this.minSizeSent;
    }

    @Override
    public long getMaxSizeSent() {
        if (this.endpoint.getChildren() != null) {
            long maxSizeSent = 0L;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                if (maxSizeSent == 0L) {
                    maxSizeSent = e.getMetricsMBean().getMaxSizeSent();
                    continue;
                }
                if (e.getMetricsMBean().getMaxSizeSent() <= maxSizeSent) continue;
                maxSizeSent = e.getMetricsMBean().getMaxSizeSent();
            }
            return maxSizeSent;
        }
        return this.maxSizeSent;
    }

    @Override
    public double getAvgSizeReceived() {
        if (this.endpoint.getChildren() != null) {
            double avgSizeReceived = 0.0;
            for (Endpoint e : this.endpoint.getChildren()) {
                double d = e.getMetricsMBean() == null ? 0.0 : e.getMetricsMBean().getAvgSizeReceived();
                double epValue = d;
                if (!(epValue > 0.0)) continue;
                avgSizeReceived = avgSizeReceived == 0.0 ? epValue : (avgSizeReceived + epValue) / 2.0;
            }
            return avgSizeReceived;
        }
        return this.avgSizeReceived;
    }

    @Override
    public double getAvgSizeSent() {
        if (this.endpoint.getChildren() != null) {
            double avgSizeSent = 0.0;
            for (Endpoint e : this.endpoint.getChildren()) {
                double d = e.getMetricsMBean() == null ? 0.0 : e.getMetricsMBean().getAvgSizeSent();
                double epValue = d;
                if (!(epValue > 0.0)) continue;
                avgSizeSent = avgSizeSent == 0.0 ? epValue : (avgSizeSent + epValue) / 2.0;
            }
            return avgSizeSent;
        }
        return this.avgSizeSent;
    }

    @Override
    public void resetStatistics() {
        this.messagesReceived = 0L;
        this.faultsReceiving = 0L;
        this.timeoutsReceiving = 0L;
        this.bytesReceived = 0L;
        this.minSizeReceived = 0L;
        this.maxSizeReceived = 0L;
        this.avgSizeReceived = 0.0;
        this.receivingFaultTable.clear();
        this.messagesSent = 0L;
        this.faultsSending = 0L;
        this.timeoutsSending = 0L;
        this.bytesSent = 0L;
        this.minSizeSent = 0L;
        this.maxSizeSent = 0L;
        this.avgSizeSent = 0.0;
        this.sendingFaultTable.clear();
        this.responseCodeTable.clear();
        this.lastResetTime = System.currentTimeMillis();
        if (this.endpoint.getChildren() != null) {
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getMetricsMBean() == null) continue;
                e.getMetricsMBean().resetStatistics();
            }
        }
        log.info((Object)("Endpoint statistics reset for : " + this.endpointName + " (and/or its children)"));
    }

    public synchronized void incrementMessagesReceived() {
        ++this.messagesReceived;
    }

    public synchronized void incrementFaultsReceiving(int errorCode) {
        ++this.faultsReceiving;
        Long o = this.receivingFaultTable.get(errorCode);
        if (o == null) {
            this.receivingFaultTable.put(errorCode, ONE);
        } else {
            this.receivingFaultTable.put(errorCode, o + 1L);
        }
    }

    public synchronized void incrementTimeoutsReceiving() {
        ++this.timeoutsReceiving;
    }

    public synchronized void incrementBytesReceived(long size) {
        this.bytesReceived += size;
    }

    public synchronized void incrementMessagesSent() {
        ++this.messagesSent;
    }

    public synchronized void incrementFaultsSending(int errorCode) {
        ++this.faultsSending;
        Long o = this.sendingFaultTable.get(errorCode);
        if (o == null) {
            this.sendingFaultTable.put(errorCode, ONE);
        } else {
            this.sendingFaultTable.put(errorCode, o + 1L);
        }
    }

    public synchronized void incrementTimeoutsSending() {
        ++this.timeoutsSending;
    }

    public synchronized void incrementBytesSent(long size) {
        this.bytesSent += size;
    }

    public synchronized void notifyReceivedMessageSize(long size) {
        if (this.minSizeReceived == 0L || size < this.minSizeReceived) {
            this.minSizeReceived = size;
        }
        if (size > this.maxSizeReceived) {
            this.maxSizeReceived = size;
        }
        this.avgSizeReceived = this.avgSizeReceived == 0.0 ? (double)size : (this.avgSizeReceived + (double)size) / 2.0;
    }

    public synchronized void notifySentMessageSize(long size) {
        if (this.minSizeSent == 0L || size < this.minSizeSent) {
            this.minSizeSent = size;
        }
        if (size > this.maxSizeSent) {
            this.maxSizeSent = size;
        }
        this.avgSizeSent = this.avgSizeSent == 0.0 ? (double)size : (this.avgSizeSent + (double)size) / 2.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSendingFault(int errorCode) {
        Map<Integer, Long> map = this.sendingFaultTable;
        synchronized (map) {
            Long o = this.sendingFaultTable.get(errorCode);
            if (o == null) {
                this.sendingFaultTable.put(errorCode, ONE);
            } else {
                this.sendingFaultTable.put(errorCode, o + 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportReceivingFault(int errorCode) {
        Map<Integer, Long> map = this.receivingFaultTable;
        synchronized (map) {
            Long o = this.receivingFaultTable.get(errorCode);
            if (o == null) {
                this.receivingFaultTable.put(errorCode, ONE);
            } else {
                this.receivingFaultTable.put(errorCode, o + 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResponseCode(int respCode) {
        Map<Integer, Long> map = this.responseCodeTable;
        synchronized (map) {
            Long o = this.responseCodeTable.get(respCode);
            if (o == null) {
                this.responseCodeTable.put(respCode, ONE);
            } else {
                this.responseCodeTable.put(respCode, o + 1L);
            }
        }
    }

    private static void addTableMaps(Map<Integer, Long> t, Map<Integer, Long> s) {
        for (Map.Entry<Integer, Long> o : s.entrySet()) {
            if (t.containsKey(o.getKey())) {
                t.put(o.getKey(), o.getValue() + s.get(o.getKey()));
                continue;
            }
            t.put(o.getKey(), s.get(o.getKey()));
        }
    }

    public boolean isEndpointInState(int state) {
        if (this.endpoint.getChildren() != null) {
            int count = 0;
            int total = 0;
            for (Endpoint e : this.endpoint.getChildren()) {
                if (e.getContext().isState(state)) {
                    ++count;
                }
                ++total;
            }
            return count == total;
        }
        if (this.endpoint.getContext() != null) {
            return this.endpoint.getContext().isState(state);
        }
        return false;
    }
}

