/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bean.enterprise;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.beanstalk.enterprise.EnterpriseBeanstalk;
import org.apache.synapse.commons.beanstalk.enterprise.EnterpriseBeanstalkManager;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.bean.BeanUtils;
import org.apache.synapse.mediators.bean.Target;

public class EJBMediator
extends AbstractMediator
implements ManagedLifecycle {
    private String beanstalkName;
    private String className;
    private Value beanId;
    private Target target;
    private String jndiName;
    private boolean remove;
    private List<Value> argumentList = new ArrayList<Value>();
    private volatile EnterpriseBeanstalk beanstalk;
    private volatile Method method;

    @Override
    public void init(SynapseEnvironment se) {
        EnterpriseBeanstalkManager beanstalkManager = (EnterpriseBeanstalkManager)se.getServerContextInformation().getProperty("__SYNAPSE.BEANSTALK.MANAGER");
        if (beanstalkManager == null) {
            throw new SynapseException("Initialization failed. BeanstalkManager not found.");
        }
        this.beanstalk = beanstalkManager.getBeanstalk(this.beanstalkName);
        if (this.beanstalk == null) {
            throw new SynapseException("Initialization failed. '" + this.beanstalkName + "' beanstalk not found.");
        }
    }

    @Override
    public boolean mediate(MessageContext synCtx) {
        Object ejb = this.beanstalk.getEnterpriseBean(this.className, this.beanId == null ? null : this.beanId.evaluateValue(synCtx), this.jndiName);
        if (ejb == null) {
            this.handleException("EJB was not found. class: " + this.className + ", bean id: " + this.beanId + ", jndi name: " + this.jndiName + ".", synCtx);
        }
        Object result = null;
        try {
            result = BeanUtils.invokeInstanceMethod(ejb, this.method, this.buildArguments(synCtx));
        }
        catch (SynapseException e) {
            this.handleException("Failed to invoke method: " + this.method + " on EJB object of " + "type: " + this.className, e, synCtx);
        }
        if (this.target != null) {
            this.target.insert(synCtx, result);
        }
        if (this.remove) {
            this.beanstalk.removeEnterpriseBean(this.className, this.beanId == null ? null : this.beanId.evaluateValue(synCtx));
        }
        return true;
    }

    @Override
    public void destroy() {
    }

    private Object[] buildArguments(MessageContext synCtx) {
        Object[] args = new Object[this.argumentList.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.argumentList.get(i).evaluateObjectValue(synCtx);
        }
        return args;
    }

    public String getBeanstalkName() {
        return this.beanstalkName;
    }

    public void setBeanstalkName(String beanstalkName) {
        this.beanstalkName = beanstalkName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Value getBeanId() {
        return this.beanId;
    }

    public void setBeanId(Value beanId) {
        this.beanId = beanId;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public List<Value> getArgumentList() {
        return this.argumentList;
    }

    public void addArgument(Value argument) {
        this.argumentList.add(argument);
    }
}

