/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.SOAPException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.FixedByteArrayOutputStream;
import org.apache.synapse.util.MessageHelper;
import org.wso2.caching.CachableResponse;
import org.wso2.caching.CacheManager;
import org.wso2.caching.CacheReplicationCommand;
import org.wso2.caching.CachingConstants;
import org.wso2.caching.CachingException;
import org.wso2.caching.RequestHash;
import org.wso2.caching.ServiceName;
import org.wso2.caching.digest.DigestGenerator;
import org.wso2.caching.util.SOAPMessageHelper;

public class CacheMediator
extends AbstractMediator
implements ManagedLifecycle {
    private String id = null;
    private String scope = "per-host";
    private boolean collector = false;
    private DigestGenerator digestGenerator = CachingConstants.DEFAULT_XML_IDENTIFIER;
    private int inMemoryCacheSize = 1000;
    private int diskCacheSize = 0;
    private long timeout = 0L;
    private SequenceMediator onCacheHitSequence = null;
    private String onCacheHitRef = null;
    private int maxMessageSize = 0;
    private static final String CACHE_KEY_PREFIX = "synapse.cache_key_";
    private String cacheKey = "synapse.cache_key";

    @Override
    public void init(SynapseEnvironment se) {
        if (this.onCacheHitSequence != null) {
            this.onCacheHitSequence.init(se);
        }
    }

    @Override
    public void destroy() {
        if (this.onCacheHitSequence != null) {
            this.onCacheHitSequence.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        CacheManager cacheManager;
        Object prop;
        ConfigurationContext cfgCtx;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Cache mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (!synCtx.isSOAP11()) {
            this.log.debug((Object)"Caching mediator does not support SOAP 1.2");
            return true;
        }
        if (this.maxMessageSize > 0) {
            FixedByteArrayOutputStream fbaos = new FixedByteArrayOutputStream(this.maxMessageSize);
            try {
                MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope()).serialize((OutputStream)fbaos);
            }
            catch (XMLStreamException e) {
                this.handleException("Error in checking the message size", e, synCtx);
            }
            catch (SynapseException syne) {
                synLog.traceOrDebug("Message size exceeds the upper bound for caching, request will not be cached");
                return true;
            }
        }
        if ((cfgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext()) == null) {
            this.handleException("Unable to perform caching,  ConfigurationContext cannot be found", synCtx);
            return false;
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Looking up cache at scope : " + this.scope + " with ID : " + this.cacheKey);
        }
        if ((prop = cfgCtx.getPropertyNonReplicable("cacheManager")) != null && prop instanceof CacheManager) {
            cacheManager = (CacheManager)prop;
        } else {
            ConfigurationContext configurationContext = cfgCtx;
            synchronized (configurationContext) {
                prop = cfgCtx.getPropertyNonReplicable("cacheManager");
                if (prop != null && prop instanceof CacheManager) {
                    cacheManager = (CacheManager)prop;
                } else {
                    synLog.traceOrDebug("Creating/recreating the cache object");
                    cacheManager = new CacheManager();
                    cfgCtx.setProperty("cacheManager", (Object)cacheManager);
                }
            }
        }
        boolean result = true;
        try {
            if (synCtx.isResponse()) {
                this.processResponseMessage(synCtx, cfgCtx, synLog, cacheManager);
            } else {
                result = this.processRequestMessage(synCtx, synLog, cacheManager);
            }
        }
        catch (ClusteringFault clusteringFault) {
            synLog.traceOrDebug("Unable to replicate Cache mediator state among the cluster");
        }
        synLog.traceOrDebug("End : Cache mediator");
        return result;
    }

    private void processResponseMessage(MessageContext synCtx, ConfigurationContext cfgCtx, SynapseLog synLog, CacheManager cacheManager) throws ClusteringFault {
        org.apache.axis2.context.MessageContext msgCtx;
        OperationContext operationContext;
        CachableResponse response;
        if (!this.collector) {
            this.handleException("Response messages cannot be handled in a non collector cache", synCtx);
        }
        if ((response = (CachableResponse)(operationContext = (msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext()).getOperationContext()).getPropertyNonReplicable("CachableResponse")) != null) {
            CacheReplicationCommand cacheReplicationCommand;
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Storing the response message into the cache at scope : " + this.scope + " with ID : " + this.cacheKey + " for request hash : " + response.getRequestHash());
            }
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Storing the response for the message with ID : " + synCtx.getMessageID() + " with request hash ID : " + response.getRequestHash() + " in the cache : " + this.cacheKey);
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                synCtx.getEnvelope().serialize((OutputStream)outStream);
                response.setResponseEnvelope(outStream.toByteArray());
            }
            catch (XMLStreamException e) {
                this.handleException("Unable to set the response to the Cache", e, synCtx);
            }
            if (response.getTimeout() > 0L) {
                response.setExpireTimeMillis(System.currentTimeMillis() + response.getTimeout());
            }
            if ((cacheReplicationCommand = (CacheReplicationCommand)msgCtx.getPropertyNonReplicable("StateReplicationObject")) != null) {
                try {
                    Replicator.replicateState((StateClusteringCommand)cacheReplicationCommand, (AxisConfiguration)msgCtx.getRootContext().getAxisConfiguration());
                }
                catch (ClusteringFault clusteringFault) {
                    this.log.error((Object)"Cannot replicate cache changes");
                }
            }
        } else {
            synLog.auditWarn("A response message without a valid mapping to the request hash found. Unable to store the response in cache");
        }
    }

    private boolean processRequestMessage(MessageContext synCtx, SynapseLog synLog, CacheManager cacheManager) throws ClusteringFault {
        if (this.collector) {
            this.handleException("Request messages cannot be handled in a collector cache", synCtx);
        }
        OperationContext opCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getOperationContext();
        String requestHash = null;
        try {
            requestHash = this.digestGenerator.getDigest(((Axis2MessageContext)synCtx).getAxis2MessageContext());
            synCtx.setProperty("requestHash", requestHash);
        }
        catch (CachingException e) {
            this.handleException("Error in calculating the hash value of the request", (Exception)((Object)e), synCtx);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Generated request hash : " + requestHash);
        }
        ServiceName service = this.id != null ? new ServiceName(this.id) : new ServiceName(this.cacheKey);
        RequestHash hash = new RequestHash(requestHash);
        CachableResponse cachedResponse = cacheManager.getCachedResponse(service, hash);
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        opCtx.setNonReplicableProperty("requestHash", (Object)requestHash);
        CacheReplicationCommand cacheReplicationCommand = new CacheReplicationCommand();
        if (cachedResponse != null) {
            if (!cachedResponse.isExpired()) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Cache-hit for message ID : " + synCtx.getMessageID());
                }
                cachedResponse.setInUse(true);
                synCtx.setResponse(true);
                opCtx.setNonReplicableProperty("CachableResponse", (Object)cachedResponse);
                SOAPEnvelope omSOAPEnv = null;
                try {
                    omSOAPEnv = SOAPMessageHelper.buildSOAPEnvelopeFromBytes((byte[])cachedResponse.getResponseEnvelope(), (boolean)msgCtx.isSOAP11());
                    if (omSOAPEnv != null) {
                        synCtx.setEnvelope(omSOAPEnv);
                    }
                }
                catch (AxisFault axisFault) {
                    this.handleException("Error setting response envelope from cache : " + this.cacheKey, synCtx);
                }
                catch (IOException ioe) {
                    this.handleException("Error setting response envelope from cache : " + this.cacheKey, ioe, synCtx);
                }
                catch (SOAPException soape) {
                    this.handleException("Error setting response envelope from cache : " + this.cacheKey, (Exception)((Object)soape), synCtx);
                }
                if (this.onCacheHitSequence != null) {
                    synLog.traceOrDebug("Delegating message to the onCachingHit Anonymous sequence");
                    this.onCacheHitSequence.mediate(synCtx);
                } else if (this.onCacheHitRef != null) {
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("Delegating message to the onCachingHit sequence : " + this.onCacheHitRef);
                    }
                    synCtx.getSequence(this.onCacheHitRef).mediate(synCtx);
                } else {
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("Request message " + synCtx.getMessageID() + " was served from the cache : " + this.cacheKey);
                    }
                    synCtx.setTo(null);
                    Axis2Sender.sendBack(synCtx);
                }
                return false;
            }
            cachedResponse.reincarnate(this.timeout);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Existing cached response has expired. Reset cache element");
            }
            cacheManager.cacheResponse(service, hash, cachedResponse, cacheReplicationCommand);
            opCtx.setNonReplicableProperty("CachableResponse", (Object)cachedResponse);
            opCtx.setNonReplicableProperty("StateReplicationObject", (Object)cacheReplicationCommand);
            Replicator.replicate((AbstractContext)opCtx);
        } else if (cacheManager.getCacheSize(service) >= (long)this.inMemoryCacheSize) {
            cacheManager.removeExpiredResponses(service, cacheReplicationCommand);
            if (cacheManager.getCacheSize(service) >= (long)this.inMemoryCacheSize) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"In-memory cache is full. Unable to cache");
                }
            } else {
                this.cacheNewResponse(msgCtx, service, hash, cacheManager, cacheReplicationCommand);
            }
        } else {
            this.cacheNewResponse(msgCtx, service, hash, cacheManager, cacheReplicationCommand);
        }
        return true;
    }

    private void cacheNewResponse(org.apache.axis2.context.MessageContext msgContext, ServiceName serviceName, RequestHash requestHash, CacheManager cacheManager, CacheReplicationCommand cacheReplicationCommand) throws ClusteringFault {
        OperationContext opCtx = msgContext.getOperationContext();
        CachableResponse response = new CachableResponse();
        response.setRequestHash(requestHash.getRequestHash());
        response.setTimeout(this.timeout);
        cacheManager.cacheResponse(serviceName, requestHash, response, cacheReplicationCommand);
        opCtx.setNonReplicableProperty("CachableResponse", (Object)response);
        opCtx.setNonReplicableProperty("StateReplicationObject", (Object)cacheReplicationCommand);
        Replicator.replicate((AbstractContext)opCtx);
    }

    private void storeRequestToCache(ConfigurationContext cfgCtx, String requestHash, CacheManager cacheManager) throws ClusteringFault {
        CachableResponse cachedObj = new CachableResponse();
        cachedObj.setRequestHash(requestHash);
        cachedObj.setTimeout(this.timeout);
        cacheManager.cacheResponse(new ServiceName(this.cacheKey), new RequestHash(requestHash), cachedObj, new CacheReplicationCommand());
        cfgCtx.setProperty("cacheManager", (Object)cacheManager);
        Replicator.replicate((AbstractContext)cfgCtx);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
        if ("per-mediator".equals(scope)) {
            this.cacheKey = CACHE_KEY_PREFIX + this.id;
        }
    }

    public boolean isCollector() {
        return this.collector;
    }

    public void setCollector(boolean collector) {
        this.collector = collector;
    }

    public DigestGenerator getDigestGenerator() {
        return this.digestGenerator;
    }

    public void setDigestGenerator(DigestGenerator digestGenerator) {
        this.digestGenerator = digestGenerator;
    }

    public int getInMemoryCacheSize() {
        return this.inMemoryCacheSize;
    }

    public void setInMemoryCacheSize(int inMemoryCacheSize) {
        this.inMemoryCacheSize = inMemoryCacheSize;
    }

    public int getDiskCacheSize() {
        return this.diskCacheSize;
    }

    public void setDiskCacheSize(int diskCacheSize) {
        this.diskCacheSize = diskCacheSize;
    }

    public long getTimeout() {
        return this.timeout / 1000L;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout * 1000L;
    }

    public SequenceMediator getOnCacheHitSequence() {
        return this.onCacheHitSequence;
    }

    public void setOnCacheHitSequence(SequenceMediator onCacheHitSequence) {
        this.onCacheHitSequence = onCacheHitSequence;
    }

    public String getOnCacheHitRef() {
        return this.onCacheHitRef;
    }

    public void setOnCacheHitRef(String onCacheHitRef) {
        this.onCacheHitRef = onCacheHitRef;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public SOAPFactory getSOAPFactory(org.apache.axis2.context.MessageContext msgContext) throws AxisFault {
        String nsURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage((String)"invalidSOAPversion"));
    }
}

