/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.commons.httpclient.Header;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class CalloutMediator
extends AbstractMediator
implements ManagedLifecycle {
    private ConfigurationContext configCtx = null;
    private String serviceURL = null;
    private String action = null;
    private String requestKey = null;
    private SynapseXPath requestXPath = null;
    private SynapseXPath targetXPath = null;
    private String targetKey = null;
    private String clientRepository = null;
    private String axis2xml = null;
    private String useServerConfig = null;
    private boolean initClientOptions = true;
    private String endpointKey = null;
    private boolean useEnvelopeAsSource = false;
    private boolean securityOn = false;
    private String wsSecPolicyKey = null;
    private String inboundWsSecPolicyKey = null;
    private String outboundWsSecPolicyKey = null;
    public static final String DEFAULT_CLIENT_REPO = "./samples/axis2Client/client_repo";
    public static final String DEFAULT_AXIS2_XML = "./samples/axis2Client/client_repo/conf/axis2.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Callout mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        try {
            OMElement request;
            Options options;
            if (this.initClientOptions) {
                options = new Options();
            } else {
                org.apache.axis2.context.MessageContext axis2MessageCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                options = axis2MessageCtx.getOptions();
            }
            String endpointReferenceValue = null;
            if (this.serviceURL != null) {
                endpointReferenceValue = this.serviceURL;
            } else if (this.endpointKey != null) {
                if (!(synCtx.getEndpoint(this.endpointKey) instanceof AddressEndpoint)) {
                    this.handleException("Specified Endpoint is not an Address Endpoint", synCtx);
                } else {
                    String address = ((AddressEndpoint)synCtx.getEndpoint(this.endpointKey)).getDefinition().getAddress();
                    if (address != null) {
                        endpointReferenceValue = address;
                    } else {
                        this.handleException("Endpoint Address is not specified", synCtx);
                    }
                }
            } else if (synCtx.getTo() != null && synCtx.getTo().getAddress() != null) {
                endpointReferenceValue = synCtx.getTo().getAddress();
            } else {
                this.handleException("Service url, Endpoint or 'To' header is required", synCtx);
            }
            options.setTo(new EndpointReference(endpointReferenceValue));
            this.copyTransportHeaders(synCtx, options);
            if (this.action != null) {
                options.setAction(this.action);
            } else if (synCtx.getWSAAction() != null) {
                options.setAction(synCtx.getWSAAction());
            } else {
                options.setAction(synCtx.getWSAAction());
            }
            options.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
            ConfigurationContext ctx = endpointReferenceValue.startsWith("local:") || "true".equals(this.useServerConfig) ? ((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext() : this.configCtx;
            ServiceClient sc = new ServiceClient(ctx, null);
            if (this.isSecurityOn()) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Callout mediator: using security");
                }
                if (this.wsSecPolicyKey != null) {
                    options.setProperty("rampartPolicy", (Object)MessageHelper.getPolicy(synCtx, this.wsSecPolicyKey));
                } else {
                    if (this.inboundWsSecPolicyKey != null) {
                        options.setProperty("rampartInPolicy", (Object)MessageHelper.getPolicy(synCtx, this.inboundWsSecPolicyKey));
                    }
                    if (this.outboundWsSecPolicyKey != null) {
                        options.setProperty("rampartOutPolicy", (Object)MessageHelper.getPolicy(synCtx, this.outboundWsSecPolicyKey));
                    }
                }
                sc.engageModule("rampart");
            }
            sc.setOptions(options);
            if (this.useEnvelopeAsSource) {
                request = MessageHelper.cloneMessageContext(synCtx).getEnvelope().getBody().getFirstElement();
                SOAPHeader soapHeader = synCtx.getEnvelope().getHeader();
                if (soapHeader != null) {
                    Iterator headers = synCtx.getEnvelope().getHeader().examineAllHeaderBlocks();
                    while (headers.hasNext()) {
                        sc.addHeader((SOAPHeaderBlock)headers.next());
                    }
                }
            } else {
                request = this.getRequestPayload(synCtx);
            }
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("About to invoke service : " + endpointReferenceValue + (this.action != null ? " with action : " + this.action : ""));
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace("Request message payload : " + request);
                }
            }
            OMElement result = null;
            options.setCallTransportCleanup(true);
            try {
                if ("true".equals(synCtx.getProperty("OUT_ONLY"))) {
                    sc.sendRobust(request);
                } else {
                    result = sc.sendReceive(request);
                }
            }
            catch (AxisFault axisFault) {
                this.handleFault(synCtx, axisFault);
            }
            finally {
                sc.cleanupTransport();
            }
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Response payload received : " + result);
            }
            if (result != null) {
                if (this.targetXPath != null) {
                    Object o = this.targetXPath.evaluate(synCtx);
                    if (o != null && o instanceof OMElement) {
                        OMElement tgtNode = (OMElement)o;
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else if (o != null && o instanceof List && !((List)o).isEmpty()) {
                        OMElement tgtNode = (OMElement)((List)o).get(0);
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else {
                        this.handleException("Evaluation of target XPath expression : " + this.targetXPath.toString() + " did not yeild an OMNode", synCtx);
                    }
                }
                if (this.targetKey != null) {
                    synCtx.setProperty(this.targetKey, result);
                }
            } else {
                synLog.traceOrDebug("Service returned a null response");
            }
        }
        catch (AxisFault e) {
            this.handleException("Error invoking service : " + this.serviceURL + (this.action != null ? " with action : " + this.action : ""), (Exception)((Object)e), synCtx);
        }
        catch (JaxenException e) {
            this.handleException("Error while evaluating the XPath expression: " + (Object)((Object)this.targetXPath), (Exception)((Object)e), synCtx);
        }
        synLog.traceOrDebug("End : Callout mediator");
        return true;
    }

    private void handleFault(MessageContext synCtx, AxisFault axisFault) {
        synCtx.setProperty("SENDING_FAULT", Boolean.TRUE);
        if (axisFault.getFaultCodeElement() != null) {
            synCtx.setProperty("ERROR_CODE", axisFault.getFaultCodeElement().getText());
        } else {
            synCtx.setProperty("ERROR_CODE", 401000);
        }
        if (axisFault.getFaultReasonElement() != null) {
            synCtx.setProperty("ERROR_MESSAGE", axisFault.getFaultReasonElement().getText());
        } else {
            synCtx.setProperty("ERROR_MESSAGE", "Error while performing the callout operation");
        }
        if (axisFault.getFaultDetailElement() != null) {
            if (axisFault.getFaultDetailElement().getFirstElement() != null) {
                synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getFirstElement());
            } else {
                synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getText());
            }
        }
        synCtx.setProperty("ERROR_EXCEPTION", (Object)axisFault);
        throw new SynapseException("Error while performing the callout operation", axisFault);
    }

    private OMElement getRequestPayload(MessageContext synCtx) throws AxisFault {
        if (this.requestKey != null) {
            Object request = synCtx.getProperty(this.requestKey);
            if (request == null) {
                request = synCtx.getEntry(this.requestKey);
            }
            if (request != null && request instanceof OMElement) {
                return (OMElement)request;
            }
            this.handleException("The property : " + this.requestKey + " is not an OMElement", synCtx);
        } else if (this.requestXPath != null) {
            try {
                Object o = this.requestXPath.evaluate(MessageHelper.cloneMessageContext(synCtx));
                if (o instanceof OMElement) {
                    return (OMElement)o;
                }
                if (o instanceof List && !((List)o).isEmpty()) {
                    return (OMElement)((List)o).get(0);
                }
                this.handleException("The evaluation of the XPath expression : " + this.requestXPath.toString() + " did not result in an OMElement", synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + this.requestXPath.toString(), (Exception)((Object)e), synCtx);
            }
        }
        return null;
    }

    @Override
    public void init(SynapseEnvironment synEnv) {
        try {
            this.configCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(this.clientRepository != null ? this.clientRepository : DEFAULT_CLIENT_REPO), (String)(this.axis2xml != null ? this.axis2xml : DEFAULT_AXIS2_XML));
        }
        catch (AxisFault e) {
            String msg = "Error initializing callout mediator : " + e.getMessage();
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    private void copyTransportHeaders(MessageContext synCtx, Options options) {
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        ArrayList<Header> list = new ArrayList<Header>();
        if (headers != null && headers instanceof Map) {
            Map headersMap = (Map)headers;
            for (Object next : headersMap.keySet()) {
                if (this.isSkipTransportHeader(next.toString())) continue;
                Object value = headersMap.get(next);
                if (!(next instanceof String) || !(value instanceof String)) continue;
                Header header = new Header(next.toString(), value.toString());
                list.add(header);
            }
        }
        options.setProperty("HTTP_HEADERS", list);
    }

    private boolean isSkipTransportHeader(String headerName) {
        return "Connection".equalsIgnoreCase(headerName) || "Transfer-Encoding".equalsIgnoreCase(headerName) || "Date".equalsIgnoreCase(headerName) || "Content-Type".equalsIgnoreCase(headerName) || "Content-Length".equalsIgnoreCase(headerName) || "Server".equalsIgnoreCase(headerName) || "User-Agent".equalsIgnoreCase(headerName) || "SOAPAction".equalsIgnoreCase(headerName);
    }

    @Override
    public void destroy() {
        try {
            this.configCtx.terminate();
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getUseServerConfig() {
        return this.useServerConfig;
    }

    public void setUseServerConfig(String useServerConfig) {
        this.useServerConfig = useServerConfig;
    }

    public String getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey;
    }

    public void setRequestXPath(SynapseXPath requestXPath) throws JaxenException {
        this.requestXPath = requestXPath;
    }

    public void setTargetXPath(SynapseXPath targetXPath) throws JaxenException {
        this.targetXPath = targetXPath;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public SynapseXPath getRequestXPath() {
        return this.requestXPath;
    }

    public SynapseXPath getTargetXPath() {
        return this.targetXPath;
    }

    public String getClientRepository() {
        return this.clientRepository;
    }

    public void setClientRepository(String clientRepository) {
        this.clientRepository = clientRepository;
    }

    public String getAxis2xml() {
        return this.axis2xml;
    }

    public void setAxis2xml(String axis2xml) {
        this.axis2xml = axis2xml;
    }

    public void setEndpointKey(String key) {
        this.endpointKey = key;
    }

    public String getEndpointKey() {
        return this.endpointKey;
    }

    public boolean getInitClientOptions() {
        return this.initClientOptions;
    }

    public void setInitClientOptions(boolean initClientOptions) {
        this.initClientOptions = initClientOptions;
    }

    public boolean isUseEnvelopeAsSource() {
        return this.useEnvelopeAsSource;
    }

    public void setUseEnvelopeAsSource(boolean useEnvelopeAsSource) {
        this.useEnvelopeAsSource = useEnvelopeAsSource;
    }

    public boolean isSecurityOn() {
        return this.securityOn;
    }

    public void setSecurityOn(boolean securityOn) {
        this.securityOn = securityOn;
    }

    public String getWsSecPolicyKey() {
        return this.wsSecPolicyKey;
    }

    public void setWsSecPolicyKey(String wsSecPolicyKey) {
        this.wsSecPolicyKey = wsSecPolicyKey;
    }

    public String getOutboundWsSecPolicyKey() {
        return this.outboundWsSecPolicyKey;
    }

    public void setOutboundWsSecPolicyKey(String outboundWsSecPolicyKey) {
        this.outboundWsSecPolicyKey = outboundWsSecPolicyKey;
    }

    public String getInboundWsSecPolicyKey() {
        return this.inboundWsSecPolicyKey;
    }

    public void setInboundWsSecPolicyKey(String inboundWsSecPolicyKey) {
        this.inboundWsSecPolicyKey = inboundWsSecPolicyKey;
    }
}

