/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorWorker;
import org.apache.synapse.mediators.base.SequenceMediator;

public class EnqueueMediator
extends AbstractMediator {
    private String executorName = null;
    private int priority = 0;
    private String sequenceName = null;

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog log = this.getLog(synCtx);
        if (log.isTraceOrDebugEnabled()) {
            log.traceOrDebug("Start: enqueue mediator");
        }
        assert (this.executorName != null) : "executor name shouldn't be null";
        PriorityExecutor executor = synCtx.getConfiguration().getPriorityExecutors().get(this.executorName);
        if (executor == null) {
            this.handleException("executor cannot be found for the name : " + this.executorName, synCtx);
            return false;
        }
        Mediator m = synCtx.getSequence(this.sequenceName);
        if (m != null && m instanceof SequenceMediator) {
            MediatorWorker worker = new MediatorWorker(m, synCtx);
            executor.execute((Runnable)worker, this.priority);
            ((Axis2MessageContext)synCtx).getAxis2MessageContext().getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
            if (log.isTraceOrDebugEnabled()) {
                log.traceOrDebug("End: enqueue mediator");
            }
            return true;
        }
        this.handleException("Sequence cannot be found : " + this.sequenceName, synCtx);
        return false;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    @Override
    public boolean isContentAware() {
        return false;
    }
}

