/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.mediators.db.AbstractDBMediator;
import org.apache.synapse.mediators.db.Statement;

public class DBLookupMediator
extends AbstractDBMediator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processStatement(Statement stmnt, MessageContext msgCtx) {
        block27: {
            SynapseLog synLog = this.getLog(msgCtx);
            Connection con = null;
            ResultSet rs = null;
            try {
                con = this.getDataSource().getConnection();
                PreparedStatement ps = this.getPreparedStatement(stmnt, con, msgCtx);
                rs = ps.executeQuery();
                if (rs.next()) {
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("Processing the first row returned : " + stmnt.getRawStatement());
                    }
                    for (String propName : stmnt.getResultsMap().keySet()) {
                        Object obj;
                        String columnStr = stmnt.getResultsMap().get(propName);
                        try {
                            int colNum = Integer.parseInt(columnStr);
                            obj = rs.getObject(colNum);
                        }
                        catch (NumberFormatException ignore) {
                            obj = rs.getObject(columnStr);
                        }
                        if (obj != null) {
                            if (synLog.isTraceOrDebugEnabled()) {
                                synLog.traceOrDebug("Column : " + columnStr + " returned value : " + obj + " Setting this as the message property : " + propName);
                            }
                            msgCtx.setProperty(propName, obj.toString());
                            continue;
                        }
                        if (!synLog.isTraceOrDebugEnabled()) continue;
                        synLog.traceOrDebugWarn("Column : " + columnStr + " returned null Skip setting message property : " + propName);
                    }
                    break block27;
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Statement : " + stmnt.getRawStatement() + " returned 0 rows");
                }
            }
            catch (SQLException e) {
                this.handleException("Error executing statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
        }
    }
}

